/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.CMCSignedRequestSigVerifyEvent;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.netscape.security.extensions.CertInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs10.CertificationRequest;
import org.mozilla.jss.pkcs11.PK11ECPublicKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.cmc.PKIData;
import org.mozilla.jss.pkix.cmc.TaggedAttribute;
import org.mozilla.jss.pkix.cmc.TaggedCertificationRequest;
import org.mozilla.jss.pkix.cmc.TaggedRequest;
import org.mozilla.jss.pkix.cmmf.RevRequest;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.cms.EncapsulatedContentInfo;
import org.mozilla.jss.pkix.cms.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.cms.SignedData;
import org.mozilla.jss.pkix.cms.SignerIdentifier;
import org.mozilla.jss.pkix.cms.SignerInfo;
import org.mozilla.jss.pkix.crmf.CertReqMsg;
import org.mozilla.jss.pkix.crmf.CertRequest;
import org.mozilla.jss.pkix.crmf.CertTemplate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMCAuth
extends AuthManager
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(CMCAuth.class);
    private boolean mBypassClientAuth = false;
    public static final String TOKEN_CERT_SERIAL = "certSerialToRevoke";
    public static final String REASON_CODE = "reasonCode";
    public static final String CRED_CMC = "cmcRequest";
    protected static String[] mRequiredCreds = new String[0];
    protected static Vector<String> mExtendedPluginInfo = null;
    private static final String SIGNED_AUDIT_ENROLLMENT_REQUEST_TYPE = "enrollment";
    private static final String SIGNED_AUDIT_REVOCATION_REQUEST_TYPE = "revocation";

    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        this.authenticationConfig = authenticationConfig;
        this.mName = name;
        this.mImplName = implName;
        this.mConfig = config;
        CAEngine caEngine = (CAEngine)this.engine;
        CAEngineConfig cs = caEngine.getConfig();
        this.mBypassClientAuth = cs.getBoolean("cmc.bypassClientAuth", false);
    }

    public AuthToken authenticate(AuthCredentials authCred) throws EMissingCredential, EInvalidCredentials, EBaseException {
        String method = "CMCAuth: authenticate: ";
        String msg = "";
        Auditor auditor = this.engine.getAuditor();
        String auditSubjectID = this.getAuditSubjectID();
        String auditReqType = "$Unidentified$";
        String auditCertSubject = "$Unidentified$";
        String auditSignerInfo = "$Unidentified$";
        CAEngine caEngine = (CAEngine)this.engine;
        CAEngineConfig cs = caEngine.getConfig();
        SessionContext auditContext = SessionContext.getExistingContext();
        X509Certificate clientCert = (X509Certificate)auditContext.get((Object)"sslClientCert");
        try {
            String cmc;
            ArgBlock argblock = authCred.getArgBlock();
            Object returnVal = null;
            if (argblock == null) {
                returnVal = authCred.get("cert_request");
                if (returnVal == null) {
                    returnVal = authCred.get(CRED_CMC);
                }
            } else {
                returnVal = authCred.get("cert_request");
                if (returnVal == null) {
                    returnVal = authCred.getArgBlock().get(CRED_CMC);
                }
            }
            if ((cmc = (String)returnVal) == null) {
                logger.error(method + "Authentication failed. Missing CMC.");
                throw new EMissingCredential(CMS.getUserMessage((String)"CMS_AUTHENTICATION_NULL_CREDENTIAL", (String[])new String[]{CRED_CMC}));
            }
            if (cmc.equals("")) {
                msg = "attempted login with empty CMC";
                logger.error(method + msg);
                throw new EInvalidCredentials(msg);
            }
            AuthToken authToken = new AuthToken((AuthManager)this);
            try {
                byte[] cmcBlob = CertUtil.parseCSR((String)cmc);
                ByteArrayInputStream cmcBlobIn = new ByteArrayInputStream(cmcBlob);
                ContentInfo cmcReq = (ContentInfo)ContentInfo.getTemplate().decode((InputStream)cmcBlobIn);
                if (!cmcReq.getContentType().equals((Object)ContentInfo.SIGNED_DATA) || !cmcReq.hasContent()) {
                    logger.error(method + "malformed cmc: either not ContentInfo.SIGNED_DATA or cmcReq has no content");
                    auditor.log((LogEvent)new CMCSignedRequestSigVerifyEvent(auditSubjectID, "Failure", auditReqType, auditCertSubject, auditSignerInfo));
                    throw new EBaseException("NO_CMC_CONTENT");
                }
                SignedData cmcFullReq = (SignedData)cmcReq.getInterpretedContent();
                EngineConfig cmc_config = this.engine.getConfig();
                boolean checkSignerInfo = cmc_config.getBoolean("cmc.signerInfo.verify", true);
                String userid = "defUser";
                String uid = "defUser";
                if (checkSignerInfo) {
                    AuthToken agentToken = this.verifySignerInfo(auditContext, authToken, cmcFullReq);
                    if (agentToken == null) {
                        logger.error(method + "agentToken null");
                        throw new EBaseException("CMCAuth: agent verifySignerInfo failure");
                    }
                    userid = agentToken.getInString("userid");
                    uid = agentToken.getInString("id");
                } else {
                    logger.debug(method + "signerInfo verification bypassed");
                }
                if (uid != null && !uid.equals("$Unidentified$")) {
                    auditSignerInfo = uid.trim();
                    auditSubjectID = uid.trim();
                    authToken.set("userid", auditSubjectID);
                } else if (userid != null && !userid.equals("$Unidentified$")) {
                    auditSubjectID = userid.trim();
                    authToken.set("userid", auditSubjectID);
                }
                EncapsulatedContentInfo ci = cmcFullReq.getContentInfo();
                OBJECT_IDENTIFIER id = ci.getContentType();
                if (!id.equals((Object)OBJECT_IDENTIFIER.id_cct_PKIData) || !ci.hasContent()) {
                    msg = "request EncapsulatedContentInfo content type not OBJECT_IDENTIFIER.id_cct_PKIData";
                    logger.error(method + msg);
                    auditor.log((LogEvent)new CMCSignedRequestSigVerifyEvent(auditSubjectID, "Failure", auditReqType, auditCertSubject, auditSignerInfo));
                    throw new EBaseException("NO_PKIDATA");
                }
                OCTET_STRING content = ci.getContent();
                ByteArrayInputStream s = new ByteArrayInputStream(content.toByteArray());
                PKIData pkiData = (PKIData)new PKIData.Template().decode((InputStream)s);
                SEQUENCE reqSequence = pkiData.getReqSequence();
                int numReqs = reqSequence.size();
                if (numReqs == 0) {
                    logger.debug(method + "numReqs 0, assume revocation request");
                    auditReqType = SIGNED_AUDIT_REVOCATION_REQUEST_TYPE;
                    SEQUENCE controlSequence = pkiData.getControlSequence();
                    int controlSize = controlSequence.size();
                    if (controlSize > 0) {
                        for (int i = 0; i < controlSize; ++i) {
                            TaggedAttribute taggedAttribute = (TaggedAttribute)controlSequence.elementAt(i);
                            OBJECT_IDENTIFIER type = taggedAttribute.getType();
                            if (!type.equals((Object)OBJECT_IDENTIFIER.id_cmc_revokeRequest)) continue;
                            SET values = taggedAttribute.getValues();
                            int numVals = values.size();
                            BigInteger[] bigIntArray = null;
                            bigIntArray = new BigInteger[numVals];
                            for (int j = 0; j < numVals; ++j) {
                                byte[] encoded = ASN1Util.encode((ASN1Value)values.elementAt(j));
                                RevRequest.Template template = new RevRequest.Template();
                                RevRequest revRequest = (RevRequest)ASN1Util.decode((ASN1Template)template, (byte[])encoded);
                                INTEGER temp = revRequest.getSerialNumber();
                                bigIntArray[j] = temp;
                                authToken.set(TOKEN_CERT_SERIAL, bigIntArray);
                                long reasonCode = revRequest.getReason().getValue();
                                Integer IntObject = (int)reasonCode;
                                authToken.set(REASON_CODE, IntObject);
                                authToken.set("uid", uid);
                                authToken.set("userid", userid);
                            }
                        }
                    }
                } else {
                    logger.debug(method + "numReqs not 0, assume enrollment request");
                    auditReqType = SIGNED_AUDIT_ENROLLMENT_REQUEST_TYPE;
                    X509CertInfo[] certInfoArray = new X509CertInfo[numReqs];
                    String[] reqIdArray = new String[numReqs];
                    for (int i = 0; i < numReqs; ++i) {
                        TaggedRequest taggedRequest = (TaggedRequest)reqSequence.elementAt(i);
                        TaggedRequest.Type type = taggedRequest.getType();
                        if (type.equals(TaggedRequest.PKCS10)) {
                            logger.debug("CMCAuth: type is PKCS10");
                            authToken.set("cert_request_type", "cmc-pkcs10");
                            TaggedCertificationRequest tcr = taggedRequest.getTcr();
                            int p10Id = tcr.getBodyPartID().intValue();
                            reqIdArray[i] = String.valueOf(p10Id);
                            CertificationRequest p10 = tcr.getCertificationRequest();
                            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                            p10.encode((OutputStream)ostream);
                            boolean sigver = true;
                            boolean tokenSwitched = false;
                            CryptoManager cm = null;
                            CryptoToken signToken = null;
                            CryptoToken savedToken = null;
                            sigver = cs.getBoolean("ca.requestVerify.enabled", true);
                            try {
                                cm = CryptoManager.getInstance();
                                if (sigver) {
                                    String tokenName = cs.getString("ca.requestVerify.token", "internal");
                                    savedToken = cm.getThreadToken();
                                    signToken = CryptoUtil.getCryptoToken((String)tokenName);
                                    if (!savedToken.getName().equals(signToken.getName())) {
                                        cm.setThreadToken(signToken);
                                        tokenSwitched = true;
                                    }
                                }
                                PKCS10 pkcs10 = new PKCS10(ostream.toByteArray(), sigver);
                                CertInfo certInfo = new CertInfo();
                                X500Name tempName = pkcs10.getSubjectName();
                                if (tempName != null) {
                                    auditCertSubject = tempName.toString().trim();
                                    if (auditCertSubject.equals("")) {
                                        auditCertSubject = "<null>";
                                    }
                                    authToken.set("tokenCertSubject", auditCertSubject);
                                    auditContext.put((Object)"cmcRequestCertSubject", (Object)auditCertSubject);
                                }
                                authToken.set("uid", uid);
                                authToken.set("userid", userid);
                                certInfoArray[i] = certInfo;
                                if (!sigver || !tokenSwitched) continue;
                            }
                            catch (Exception e) {
                                try {
                                    auditor.log((LogEvent)new CMCSignedRequestSigVerifyEvent(auditSubjectID, "Failure", auditReqType, auditCertSubject, auditSignerInfo));
                                    throw new EBaseException(e);
                                }
                                catch (Throwable throwable) {
                                    if (sigver && tokenSwitched) {
                                        cm.setThreadToken(savedToken);
                                    }
                                    throw throwable;
                                }
                            }
                            cm.setThreadToken(savedToken);
                            continue;
                        }
                        if (!type.equals(TaggedRequest.CRMF)) continue;
                        logger.debug("CMCAuth: type is CRMF");
                        authToken.set("cert_request_type", "cmc-crmf");
                        try {
                            CertReqMsg crm = taggedRequest.getCrm();
                            CertRequest certReq = crm.getCertReq();
                            INTEGER reqID = certReq.getCertReqId();
                            reqIdArray[i] = reqID.toString();
                            CertTemplate template = certReq.getCertTemplate();
                            Name name = template.getSubject();
                            CertInfo certInfo = new CertInfo();
                            if (name != null) {
                                String ss = name.getRFC1485();
                                auditCertSubject = ss;
                                if (auditCertSubject.equals("")) {
                                    auditCertSubject = "<null>";
                                }
                                authToken.set("tokenCertSubject", ss);
                                auditContext.put((Object)"cmcRequestCertSubject", (Object)auditCertSubject);
                                authToken.set("uid", uid);
                                authToken.set("userid", userid);
                            }
                            certInfoArray[i] = certInfo;
                            continue;
                        }
                        catch (Exception e) {
                            auditor.log((LogEvent)new CMCSignedRequestSigVerifyEvent(auditSubjectID, "Failure", auditReqType, auditCertSubject, auditSignerInfo));
                            throw new EBaseException(e);
                        }
                    }
                }
            }
            catch (Exception e) {
                auditor.log((LogEvent)new CMCSignedRequestSigVerifyEvent(auditSubjectID, "Failure", auditReqType, auditCertSubject, auditSignerInfo));
                throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]), e);
            }
            auditor.log((LogEvent)new CMCSignedRequestSigVerifyEvent(auditSubjectID, "Success", auditReqType, auditCertSubject, auditSignerInfo));
            return authToken;
        }
        catch (EMissingCredential eAudit1) {
            auditor.log((LogEvent)new CMCSignedRequestSigVerifyEvent(auditSubjectID, "Failure", auditReqType, auditCertSubject, auditSignerInfo));
            throw eAudit1;
        }
        catch (EInvalidCredentials eAudit2) {
            auditor.log((LogEvent)new CMCSignedRequestSigVerifyEvent(auditSubjectID, "Failure", auditReqType, auditCertSubject, auditSignerInfo));
            throw eAudit2;
        }
        catch (EBaseException eAudit3) {
            auditor.log((LogEvent)new CMCSignedRequestSigVerifyEvent(auditSubjectID, "Failure", auditReqType, auditCertSubject, auditSignerInfo));
            throw eAudit3;
        }
    }

    public String[] getRequiredCreds() {
        return mRequiredCreds;
    }

    public void shutdown() {
    }

    public String[] getExtendedPluginInfo() {
        logger.debug("CMCAuth: getExtendedPluginInfo()");
        String[] s = Utils.getStringArrayFromVector(mExtendedPluginInfo);
        logger.debug("CMCAuth: s.length = " + s.length);
        for (int i = 0; i < s.length; ++i) {
            logger.debug(i + " " + s[i]);
        }
        return s;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AuthToken verifySignerInfo(SessionContext auditContext, AuthToken authToken, SignedData cmcFullReq) throws EBaseException {
        CryptoManager cm;
        CryptoToken savedToken;
        boolean tokenSwitched;
        block35: {
            AuthToken authToken2;
            block34: {
                CAEngine caEngine = (CAEngine)this.engine;
                CAEngineConfig cs = caEngine.getConfig();
                String method = "CMCAuth: verifySignerInfo: ";
                String msg = "";
                EncapsulatedContentInfo ci = cmcFullReq.getContentInfo();
                OBJECT_IDENTIFIER id = ci.getContentType();
                OCTET_STRING content = ci.getContent();
                tokenSwitched = false;
                CryptoToken signToken = null;
                savedToken = null;
                cm = null;
                if (auditContext == null) {
                    logger.warn(method + " auditConext can't be null");
                    return null;
                }
                try {
                    cm = CryptoManager.getInstance();
                    ByteArrayInputStream s = new ByteArrayInputStream(content.toByteArray());
                    PKIData pkiData = (PKIData)new PKIData.Template().decode((InputStream)s);
                    SET dais = cmcFullReq.getDigestAlgorithmIdentifiers();
                    int numDig = dais.size();
                    Hashtable<String, byte[]> digs = new Hashtable<String, byte[]>();
                    for (int i = 0; i < numDig; ++i) {
                        AlgorithmIdentifier dai = (AlgorithmIdentifier)dais.elementAt(i);
                        String name = DigestAlgorithm.fromOID((OBJECT_IDENTIFIER)dai.getOID()).toString();
                        MessageDigest md = MessageDigest.getInstance(name);
                        byte[] digest = md.digest(content.toByteArray());
                        digs.put(name, digest);
                    }
                    SET sis = cmcFullReq.getSignerInfos();
                    int numSis = sis.size();
                    for (int i = 0; i < numSis; ++i) {
                        SignerIdentifier sid;
                        SignerInfo si = (SignerInfo)sis.elementAt(i);
                        String name = si.getDigestAlgorithm().toString();
                        byte[] digest = (byte[])digs.get(name);
                        if (digest == null) {
                            MessageDigest md = MessageDigest.getInstance(name);
                            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                            pkiData.encode((OutputStream)ostream);
                            digest = md.digest(ostream.toByteArray());
                        }
                        if (!(sid = si.getSignerIdentifier()).getType().equals(SignerIdentifier.ISSUER_AND_SERIALNUMBER)) continue;
                        IssuerAndSerialNumber issuerAndSerialNumber = sid.getIssuerAndSerialNumber();
                        java.security.cert.Certificate cert = null;
                        if (cmcFullReq.hasCertificates()) {
                            SET certs = cmcFullReq.getCertificates();
                            int numCerts = certs.size();
                            X509Certificate[] x509Certs = new X509Certificate[1];
                            byte[] certByteArray = new byte[]{};
                            for (int j = 0; j < numCerts; ++j) {
                                Certificate certJss = (Certificate)certs.elementAt(j);
                                CertificateInfo certI = certJss.getInfo();
                                Name issuer = certI.getIssuer();
                                byte[] issuerB = ASN1Util.encode((ASN1Value)issuer);
                                INTEGER sn = certI.getSerialNumber();
                                if (!new String(issuerB).equals(new String(ASN1Util.encode((ASN1Value)issuerAndSerialNumber.getIssuer()))) || !sn.toString().equals(issuerAndSerialNumber.getSerialNumber().toString())) continue;
                                ByteArrayOutputStream os = new ByteArrayOutputStream();
                                certJss.encode((OutputStream)os);
                                certByteArray = os.toByteArray();
                                X509CertImpl tempcert = new X509CertImpl(os.toByteArray());
                                cert = tempcert;
                                x509Certs[0] = cert;
                            }
                            logger.debug("CMCAuth: start checking signature");
                            if (cert == null) {
                                logger.debug("CMCAuth: verifying signature");
                                si.verify(digest, id);
                            } else {
                                logger.debug("CMCAuth: found signing cert... verifying");
                                X509Certificate clientCert = (X509Certificate)auditContext.get((Object)"sslClientCert");
                                if (clientCert == null) {
                                    if (!this.mBypassClientAuth) {
                                        msg = "missing SSL client authentication certificate;";
                                        logger.error(method + msg);
                                        s.close();
                                        throw new EMissingCredential(CMS.getUserMessage((String)"CMS_AUTHENTICATION_NO_CERT", (String[])new String[0]));
                                    }
                                    msg = "missing SSL client authentication certificate; allowed";
                                    logger.debug(method + msg);
                                } else {
                                    X500Name cmcPrincipal;
                                    X500Name clientPrincipal = (X500Name)clientCert.getSubjectDN();
                                    if (!clientPrincipal.equals((Object)(cmcPrincipal = (X500Name)x509Certs[0].getSubjectDN()))) {
                                        msg = "SSL client authentication certificate and CMC signer do not match";
                                        logger.error(method + msg);
                                        s.close();
                                        throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]) + ":" + msg);
                                    }
                                    logger.debug(method + "ssl client cert principal and cmc signer principal match");
                                }
                                PublicKey signKey = cert.getPublicKey();
                                PrivateKey.Type keyType = null;
                                String alg = signKey.getAlgorithm();
                                PK11PubKey pubK = null;
                                if (alg.equals("RSA")) {
                                    logger.debug("CMCAuth: signing key alg=RSA");
                                    keyType = PrivateKey.RSA;
                                    pubK = PK11PubKey.fromRaw((PrivateKey.Type)keyType, (byte[])((X509Key)signKey).getKey());
                                } else if (alg.equals("EC")) {
                                    logger.debug("CMCAuth: signing key alg=EC");
                                    keyType = PrivateKey.EC;
                                    byte[] publicKeyData = ((X509Key)signKey).getEncoded();
                                    pubK = PK11ECPublicKey.fromSPKI((byte[])publicKeyData);
                                } else if (alg.equals("DSA")) {
                                    logger.debug("CMCAuth: signing key alg=DSA");
                                    keyType = PrivateKey.DSA;
                                    pubK = PK11PubKey.fromSPKI((byte[])((X509Key)signKey).getKey());
                                }
                                String tokenName = cs.getString("ca.requestVerify.token", "internal");
                                if (!CryptoUtil.isInternalToken((String)tokenName)) {
                                    savedToken = cm.getThreadToken();
                                    signToken = CryptoUtil.getCryptoToken((String)tokenName);
                                    if (signToken != null) {
                                        cm.setThreadToken(signToken);
                                        tokenSwitched = true;
                                        logger.debug("CMCAuth: verifySignerInfo token switched:" + tokenName);
                                    } else {
                                        logger.debug("CMCAuth: verifySignerInfo token not found:" + tokenName + ", trying internal");
                                    }
                                }
                                logger.debug("CMCAuth: verifying signature with public key");
                                si.verify(digest, id, (PublicKey)pubK);
                            }
                            logger.debug("CMCAuth: finished checking signature");
                            AuthSubsystem authSS = this.engine.getAuthSubsystem();
                            AuthManager agentAuth = authSS.getAuthManager("certUserDBAuthMgr");
                            if (agentAuth == null) {
                                throw new EBaseException(CMS.getUserMessage((String)"CMS_AUTHENTICATION_MANAGER_NOT_FOUND", (String[])new String[]{"certUserDBAuthMgr"}));
                            }
                            AuthCredentials agentCred = new AuthCredentials();
                            agentCred.set("sslClientCert", (Object)x509Certs);
                            AuthToken tempToken = agentAuth.authenticate(agentCred);
                            X500Name tempPrincipal = (X500Name)x509Certs[0].getSubjectDN();
                            String ID = tempPrincipal.getName();
                            logger.debug(method + " Principal name = " + ID);
                            authToken.set("tokenAuthenticatedCertSubject", ID);
                            BigInteger agentCertSerial = x509Certs[0].getSerialNumber();
                            authToken.set("sslClientCert", agentCertSerial.toString());
                            tempToken.set("id", ID);
                            authToken2 = tempToken;
                            if (!tokenSwitched) return authToken2;
                            if (savedToken == null) return authToken2;
                            break block34;
                        }
                        si.verify(digest, id);
                    }
                    if (!tokenSwitched) return null;
                    break block35;
                }
                catch (InvalidBERException e) {
                    logger.warn("CMCAuth: " + e.getMessage(), (Throwable)e);
                    return null;
                }
                catch (IOException e) {
                    logger.warn("CMCAuth: " + e.getMessage(), (Throwable)e);
                    return null;
                }
                catch (NotInitializedException e) {
                    logger.warn("CMCAuth: " + e.getMessage(), (Throwable)e);
                    return null;
                }
                catch (Exception e) {
                    logger.warn("CMCAuth: " + e.getMessage(), (Throwable)e);
                    throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]), e);
                }
            }
            cm.setThreadToken(savedToken);
            logger.debug("CMCAuth: verifySignerInfo token restored");
            return authToken2;
        }
        if (savedToken == null) return null;
        cm.setThreadToken(savedToken);
        logger.debug("CMCAuth: verifySignerInfo token restored");
        return null;
        finally {
            if (tokenSwitched && savedToken != null) {
                cm.setThreadToken(savedToken);
                logger.debug("CMCAuth: verifySignerInfo token restored");
            }
        }
    }

    public void init(ConfigStore config) throws EProfileException {
    }

    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHENTICATION_CMS_SIGN_NAME", (String[])new String[0]);
    }

    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHENTICATION_CMS_SIGN_TEXT", (String[])new String[0]);
    }

    public Enumeration<String> getValueNames() {
        Vector<String> v = new Vector<String>();
        v.addElement("cert_request");
        return v.elements();
    }

    public boolean isValueWriteable(String name) {
        return false;
    }

    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(CRED_CMC)) {
            return new Descriptor("string_list", null, null, "CMC request");
        }
        return null;
    }

    public void populate(AuthToken token, Request request) throws EProfileException {
        request.setExtData("authenticatedName", token.getInString("tokenAuthenticatedCertSubject"));
    }

    public boolean isSSLClientRequired() {
        return false;
    }

    private String getAuditSubjectID() {
        String subjectID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        subjectID = auditContext != null ? ((subjectID = (String)auditContext.get((Object)"userid")) != null ? subjectID.trim() : "$NonRoleUser$") : "$Unidentified$";
        return subjectID;
    }

    static {
        mExtendedPluginInfo = new Vector();
        mExtendedPluginInfo.add("HELP_TEXT;Authenticate the CMC request. The signer must be an agent. The \"Authentication Instance ID\" must be named \"CMCAuth\"");
        mExtendedPluginInfo.add("HELP_TOKEN;configuration-authentication");
    }
}

