/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.common;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.profile.EDeferException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.profile.common.ProfileConfig;
import com.netscape.cms.profile.common.ProfileInput;
import com.netscape.cms.profile.common.ProfileInputConfig;
import com.netscape.cms.profile.common.ProfileInputsConfig;
import com.netscape.cms.profile.common.ProfileOutput;
import com.netscape.cms.profile.common.ProfileOutputConfig;
import com.netscape.cms.profile.common.ProfileOutputsConfig;
import com.netscape.cms.profile.common.ProfilePoliciesConfig;
import com.netscape.cms.profile.common.ProfilePolicy;
import com.netscape.cms.profile.constraint.PolicyConstraint;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.profile.updater.ProfileUpdater;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.registry.PluginInfo;
import com.netscape.cmscore.registry.PluginRegistry;
import com.netscape.cmscore.request.Request;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Profile {
    public static Logger logger = LoggerFactory.getLogger(Profile.class);
    public static final String PROP_INPUT_LIST = "list";
    public static final String PROP_OUTPUT_LIST = "list";
    public static final String PROP_UPDATER_LIST = "list";
    public static final String PROP_POLICY_LIST = "list";
    public static final String PROP_DEFAULT = "default";
    public static final String PROP_CONSTRAINT = "constraint";
    public static final String PROP_INPUT = "input";
    public static final String PROP_OUTPUT = "output";
    public static final String PROP_CLASS_ID = "class_id";
    public static final String PROP_PARAMS = "params";
    public static final String PROP_NO_DEFAULT = "noDefaultImpl";
    public static final String PROP_NO_CONSTRAINT = "noConstraintImpl";
    public static final String PROP_GENERIC_EXT_DEFAULT = "genericExtDefaultImpl";
    protected CAEngineConfig engineConfig;
    protected ProfileConfig mConfig;
    protected PluginRegistry registry;
    protected Vector<String> mInputNames = new Vector();
    protected Hashtable<String, ProfileInput> mInputs = new Hashtable();
    protected Vector<String> mInputIds = new Vector();
    protected Hashtable<String, ProfileOutput> mOutputs = new Hashtable();
    protected Vector<String> mOutputIds = new Vector();
    protected Hashtable<String, ProfileUpdater> mUpdaters = new Hashtable();
    protected Vector<String> mUpdaterIds = new Vector();
    protected String mAuthInstanceId = null;
    protected String mId = null;
    protected String mAuthzAcl = "";
    protected Hashtable<String, Vector<ProfilePolicy>> mPolicySet = new Hashtable();

    public boolean isEnable() {
        try {
            return this.mConfig.getEnable();
        }
        catch (EBaseException e) {
            return false;
        }
    }

    public String isRenewal() {
        try {
            return this.mConfig.getRenewal();
        }
        catch (EBaseException e) {
            return "false";
        }
    }

    public void setRenewal(boolean renewal) {
        this.mConfig.setRenewal(renewal);
    }

    public String isXmlOutput() {
        try {
            return this.mConfig.getXmlOutput();
        }
        catch (EBaseException e) {
            return "false";
        }
    }

    public void setXMLOutput(boolean xmlOutput) {
        this.mConfig.setXMLOutput(xmlOutput);
    }

    public String getApprovedBy() {
        try {
            return this.mConfig.getEnableBy();
        }
        catch (EBaseException e) {
            return "";
        }
    }

    public void setId(String id) {
        this.mId = id;
    }

    public String getId() {
        return this.mId;
    }

    public String getRequestorDN(Request request) {
        return null;
    }

    public String getAuthenticatorId() {
        return this.mAuthInstanceId;
    }

    public void setAuthenticatorId(String id) {
        this.mAuthInstanceId = id;
        this.mConfig.setAuthenticatorID(id);
    }

    public void setAuthzAcl(String id) {
        this.mAuthzAcl = id;
        this.mConfig.setAuthzAcl(id);
    }

    public String getAuthzAcl() {
        return this.mAuthzAcl;
    }

    public void init(CAEngineConfig engineConfig, PluginRegistry registry, ProfileConfig profileConfig) throws EBaseException {
        logger.debug("Profile: start init");
        this.engineConfig = engineConfig;
        this.registry = registry;
        this.mConfig = profileConfig;
        try {
            this.mAuthInstanceId = profileConfig.getAuthenticatorID();
            this.mAuthzAcl = profileConfig.getAuthzAcl();
        }
        catch (EBaseException e) {
            logger.warn("Profile: authentication class not found " + e.getMessage(), (Throwable)e);
        }
        ProfileInputsConfig inputStore = profileConfig.getProfileInputsConfig();
        String input_list = inputStore.getString("list", "");
        StringTokenizer input_st = new StringTokenizer(input_list, ",");
        while (input_st.hasMoreTokens()) {
            String input_id = input_st.nextToken();
            ProfileInputConfig inputConfig = inputStore.getProfileInputConfig(input_id);
            String inputClassId = inputConfig.getString(PROP_CLASS_ID);
            PluginInfo inputInfo = registry.getPluginInfo("profileInput", inputClassId);
            String inputClass = inputInfo.getClassName();
            ProfileInput input = null;
            try {
                input = (ProfileInput)Class.forName(inputClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.error("Profile: input plugin Class.forName " + inputClass + " " + e.getMessage(), (Throwable)e);
                throw new EBaseException(e.toString());
            }
            input.init(this, inputConfig);
            this.mInputs.put(input_id, input);
            this.mInputIds.addElement(input_id);
        }
        ProfileOutputsConfig outputStore = profileConfig.getProfileOutputsConfig();
        String output_list = outputStore.getString("list", "");
        StringTokenizer output_st = new StringTokenizer(output_list, ",");
        while (output_st.hasMoreTokens()) {
            String output_id = output_st.nextToken();
            ProfileOutputConfig outputConfig = outputStore.getProfileOutputConfig(output_id);
            String outputClassId = outputConfig.getString(PROP_CLASS_ID);
            PluginInfo outputInfo = registry.getPluginInfo("profileOutput", outputClassId);
            String outputClass = outputInfo.getClassName();
            ProfileOutput output = null;
            try {
                output = (ProfileOutput)Class.forName(outputClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.error("Profile: output plugin Class.forName " + outputClass + " " + e.getMessage(), (Throwable)e);
                throw new EBaseException(e.toString());
            }
            output.init(outputConfig);
            this.mOutputs.put(output_id, output);
            this.mOutputIds.addElement(output_id);
        }
        ConfigStore updaterStore = profileConfig.getSubStore("updater", ConfigStore.class);
        String updater_list = updaterStore.getString("list", "");
        StringTokenizer updater_st = new StringTokenizer(updater_list, ",");
        while (updater_st.hasMoreTokens()) {
            String updater_id = updater_st.nextToken();
            String updaterClassId = updaterStore.getString(updater_id + ".class_id");
            PluginInfo updaterInfo = registry.getPluginInfo("profileUpdater", updaterClassId);
            String updaterClass = updaterInfo.getClassName();
            ProfileUpdater updater = null;
            try {
                updater = (ProfileUpdater)Class.forName(updaterClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.error("Profile: updater plugin Class.forName " + updaterClass + " " + e.getMessage(), (Throwable)e);
                throw new EBaseException(e.toString());
            }
            ConfigStore updaterConfig = updaterStore.getSubStore(updater_id, ConfigStore.class);
            updater.init(updaterConfig);
            this.mUpdaters.put(updater_id, updater);
            this.mUpdaterIds.addElement(updater_id);
        }
        ProfilePoliciesConfig policySetStore = profileConfig.getPoliciesConfig();
        String setlist = policySetStore.getString("list", "");
        StringTokenizer st = new StringTokenizer(setlist, ",");
        while (st.hasMoreTokens()) {
            String setId = st.nextToken();
            ConfigStore policyStore = policySetStore.getSubStore(setId, ConfigStore.class);
            String list = policyStore.getString("list", "");
            StringTokenizer st1 = new StringTokenizer(list, ",");
            while (st1.hasMoreTokens()) {
                String id = st1.nextToken();
                String defaultRoot = id + ".default";
                String defaultClassId = policyStore.getString(defaultRoot + ".class_id");
                String constraintRoot = id + ".constraint";
                String constraintClassId = policyStore.getString(constraintRoot + ".class_id");
                this.createProfilePolicy(setId, id, defaultClassId, constraintClassId, false);
            }
        }
        logger.debug("Profile: done init");
    }

    public ProfileConfig getConfigStore() {
        return this.mConfig;
    }

    public Enumeration<String> getInputNames() {
        return this.mInputNames.elements();
    }

    public Enumeration<String> getProfileUpdaterIds() {
        return this.mUpdaterIds.elements();
    }

    public ProfileUpdater getProfileUpdater(String name) {
        return this.mUpdaters.get(name);
    }

    public Enumeration<String> getProfileOutputIds() {
        return this.mOutputIds.elements();
    }

    public ProfileOutput getProfileOutput(String id) {
        return this.mOutputs.get(id);
    }

    public Enumeration<String> getProfileInputIds() {
        return this.mInputIds.elements();
    }

    public ProfileInput getProfileInput(String id) {
        return this.mInputs.get(id);
    }

    public void addInputName(String name) {
        this.mInputNames.addElement(name);
    }

    public Enumeration<String> getProfilePolicySetIds() {
        return this.mPolicySet.keys();
    }

    public void deleteProfilePolicy(String setId, String policyId) throws EProfileException {
        Vector<ProfilePolicy> policies = this.mPolicySet.get(setId);
        if (policies == null) {
            return;
        }
        try {
            ProfilePoliciesConfig policySetSubStore = this.mConfig.getPoliciesConfig();
            ConfigStore policySubStore = policySetSubStore.getSubStore(setId, ConfigStore.class);
            policySubStore.removeSubStore(policyId);
            String list = policySubStore.getString("list", null);
            StringTokenizer st = new StringTokenizer(list, ",");
            String newlist = "";
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                if (e.equals(policyId)) continue;
                sb.append(e);
                sb.append(",");
            }
            newlist = sb.toString();
            if (!newlist.equals("")) {
                newlist = newlist.substring(0, newlist.length() - 1);
                policySubStore.putString("list", newlist);
            } else {
                policySetSubStore.removeSubStore(setId);
            }
            int size = policies.size();
            for (int i = 0; i < size; ++i) {
                ProfilePolicy policy = policies.elementAt(i);
                String id = policy.getId();
                if (!id.equals(policyId)) continue;
                policies.removeElementAt(i);
                if (size != 1) break;
                this.mPolicySet.remove(setId);
                String setlist = policySetSubStore.getString("list", null);
                StringTokenizer st1 = new StringTokenizer(setlist, ",");
                Object newlist1 = "";
                while (st1.hasMoreTokens()) {
                    String e = st1.nextToken();
                    if (e.equals(setId)) continue;
                    newlist1 = (String)newlist1 + e + ",";
                }
                if (!((String)newlist1).equals("")) {
                    newlist1 = ((String)newlist1).substring(0, ((String)newlist1).length() - 1);
                }
                policySetSubStore.putString("list", (String)newlist1);
                break;
            }
            this.mConfig.putString("lastModified", Long.toString(new Date().getTime()));
            this.mConfig.commit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteAllProfilePolicies() throws EProfileException {
        for (Map.Entry<String, Vector<ProfilePolicy>> entry : this.mPolicySet.entrySet()) {
            String setId = entry.getKey();
            Vector pList = new Vector(entry.getValue());
            for (ProfilePolicy policy : pList) {
                this.deleteProfilePolicy(setId, policy.getId());
            }
        }
        this.mPolicySet.clear();
    }

    public void deleteProfileInput(String inputId) throws EProfileException {
        try {
            ProfileInputsConfig inputsConfig = this.mConfig.getProfileInputsConfig();
            inputsConfig.removeProfileInputConfig(inputId);
            String list = inputsConfig.getString("list", null);
            StringTokenizer st = new StringTokenizer(list, ",");
            String newlist = "";
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                if (e.equals(inputId)) continue;
                sb.append(e);
                sb.append(",");
            }
            newlist = sb.toString();
            if (!newlist.equals("")) {
                newlist = newlist.substring(0, newlist.length() - 1);
            }
            int size = this.mInputIds.size();
            for (int i = 0; i < size; ++i) {
                String id = this.mInputIds.elementAt(i);
                if (!id.equals(inputId)) continue;
                this.mInputIds.removeElementAt(i);
                break;
            }
            this.mInputs.remove(inputId);
            inputsConfig.putString("list", newlist);
            this.mConfig.putString("lastModified", Long.toString(new Date().getTime()));
            this.mConfig.commit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteAllProfileInputs() throws EProfileException {
        Vector<String> inputs = new Vector<String>(this.mInputIds);
        for (String id : inputs) {
            this.deleteProfileInput(id);
        }
    }

    public void deleteProfileOutput(String outputId) throws EProfileException {
        try {
            ProfileOutputsConfig outputsConfig = this.mConfig.getProfileOutputsConfig();
            outputsConfig.removeProfileOutputConfig(outputId);
            String list = outputsConfig.getString("list", null);
            StringTokenizer st = new StringTokenizer(list, ",");
            String newlist = "";
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                if (e.equals(outputId)) continue;
                sb.append(e);
                sb.append(",");
            }
            newlist = sb.toString();
            if (!newlist.equals("")) {
                newlist = newlist.substring(0, newlist.length() - 1);
            }
            int size = this.mOutputIds.size();
            for (int i = 0; i < size; ++i) {
                String id = this.mOutputIds.elementAt(i);
                if (!id.equals(outputId)) continue;
                this.mOutputIds.removeElementAt(i);
                break;
            }
            this.mOutputs.remove(outputId);
            outputsConfig.putString("list", newlist);
            this.mConfig.putString("lastModified", Long.toString(new Date().getTime()));
            this.mConfig.commit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteAllProfileOutputs() throws EProfileException {
        Vector<String> outputs = new Vector<String>(this.mOutputIds);
        for (String id : outputs) {
            this.deleteProfileOutput(id);
        }
    }

    public ProfileOutput createProfileOutput(String id, String outputID, NameValuePairs nvps) throws EProfileException {
        return this.createProfileOutput(id, outputID, nvps, true);
    }

    public ProfileOutput createProfileOutput(String id, String outputId, NameValuePairs nvps, boolean createConfig) throws EProfileException {
        ProfileOutputsConfig outputsConfig = this.mConfig.getProfileOutputsConfig();
        PluginInfo outputInfo = this.registry.getPluginInfo("profileOutput", outputId);
        if (outputInfo == null) {
            logger.error("Cannot find " + outputId);
            throw new EProfileException("Cannot find " + outputId);
        }
        String outputClass = outputInfo.getClassName();
        logger.debug("Profile: loading output class " + outputClass);
        ProfileOutput output = null;
        try {
            output = (ProfileOutput)Class.forName(outputClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        if (output == null) {
            logger.warn("Profile: failed to create " + outputClass);
        } else {
            logger.debug("Profile: initing " + id + " output");
            logger.debug("Profile: outputStore " + outputsConfig);
            output.init(outputsConfig);
            this.mOutputs.put(id, output);
            this.mOutputIds.addElement(id);
        }
        if (createConfig) {
            String list = null;
            try {
                list = outputsConfig.getString("list", null);
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            if (list == null || list.equals("")) {
                outputsConfig.putString("list", id);
            } else {
                StringTokenizer st1 = new StringTokenizer(list, ",");
                while (st1.hasMoreTokens()) {
                    String pid = st1.nextToken();
                    if (!pid.equals(id)) continue;
                    throw new EProfileException("Duplicate output id: " + id);
                }
                outputsConfig.putString("list", list + "," + id);
            }
            ProfileOutputConfig outputConfig = outputsConfig.getProfileOutputConfig(id);
            outputConfig.putString("name", outputInfo.getName(Locale.getDefault()));
            outputConfig.putString(PROP_CLASS_ID, outputId);
            for (String name : nvps.keySet()) {
                outputConfig.putString("params." + name, (String)nvps.get((Object)name));
                try {
                    if (output == null) continue;
                    output.setConfig(name, (String)nvps.get((Object)name));
                }
                catch (EBaseException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
            try {
                this.mConfig.putString("lastModified", Long.toString(new Date().getTime()));
                this.mConfig.commit(false);
            }
            catch (EBaseException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return output;
    }

    public ProfileInput createProfileInput(String id, String inputID, NameValuePairs nvps) throws EProfileException {
        return this.createProfileInput(id, inputID, nvps, true);
    }

    public ProfileInput createProfileInput(String id, String inputId, NameValuePairs nvps, boolean createConfig) throws EProfileException {
        ProfileInputsConfig inputsConfig = this.mConfig.getProfileInputsConfig();
        PluginInfo inputInfo = this.registry.getPluginInfo("profileInput", inputId);
        if (inputInfo == null) {
            logger.error("Cannot find " + inputId);
            throw new EProfileException("Cannot find " + inputId);
        }
        String inputClass = inputInfo.getClassName();
        logger.debug("Profile: loading input class " + inputClass);
        ProfileInput input = null;
        try {
            input = (ProfileInput)Class.forName(inputClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        if (input == null) {
            logger.warn("Profile: failed to create " + inputClass);
        } else {
            logger.debug("Profile: initing " + id + " input");
            logger.debug("Profile: inputs: " + inputsConfig);
            input.init(this, inputsConfig);
            this.mInputs.put(id, input);
            this.mInputIds.addElement(id);
        }
        if (createConfig) {
            String list = null;
            try {
                list = inputsConfig.getString("list", null);
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            if (list == null || list.equals("")) {
                inputsConfig.putString("list", id);
            } else {
                StringTokenizer st1 = new StringTokenizer(list, ",");
                while (st1.hasMoreTokens()) {
                    String pid = st1.nextToken();
                    if (!pid.equals(id)) continue;
                    throw new EProfileException("Duplicate input id: " + id);
                }
                inputsConfig.putString("list", list + "," + id);
            }
            ProfileInputConfig inputConfig = inputsConfig.getProfileInputConfig(id);
            inputConfig.putString("name", inputInfo.getName(Locale.getDefault()));
            inputConfig.putString(PROP_CLASS_ID, inputId);
            for (String name : nvps.keySet()) {
                inputConfig.putString("params." + name, (String)nvps.get((Object)name));
                try {
                    if (input == null) continue;
                    input.setConfig(name, (String)nvps.get((Object)name));
                }
                catch (EBaseException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
            try {
                this.mConfig.putString("lastModified", Long.toString(new Date().getTime()));
                this.mConfig.commit(false);
            }
            catch (EBaseException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return input;
    }

    public ProfilePolicy createProfilePolicy(String setId, String id, String defaultClassId, String constraintClassId) throws EProfileException {
        return this.createProfilePolicy(setId, id, defaultClassId, constraintClassId, true);
    }

    public ProfilePolicy createProfilePolicy(String setId, String id, String defaultClassId, String constraintClassId, boolean createConfig) throws EProfileException {
        CharSequence setlist;
        String method = "Profile: createProfilePolicy: ";
        logger.debug(method + "begins");
        Vector<ProfilePolicy> policies = this.mPolicySet.get(setId);
        ProfilePoliciesConfig policySetStore = this.mConfig.getPoliciesConfig();
        ConfigStore policyStore = policySetStore.getSubStore(setId, ConfigStore.class);
        if (policies == null) {
            policies = new Vector();
            this.mPolicySet.put(setId, policies);
            if (createConfig) {
                setlist = new StringBuffer();
                Enumeration<String> keys = this.mPolicySet.keys();
                while (keys.hasMoreElements()) {
                    String k = keys.nextElement();
                    if (!((StringBuffer)setlist).toString().equals("")) {
                        ((StringBuffer)setlist).append(",");
                    }
                    ((StringBuffer)setlist).append(k);
                }
                policySetStore.putString("list", ((StringBuffer)setlist).toString());
            }
        } else {
            String ids = null;
            try {
                ids = policyStore.getString("list", "");
            }
            catch (Exception keys) {
                // empty catch block
            }
            if (ids == null) {
                logger.warn("Profile: createProfilePolicy() - ids is null!");
                return null;
            }
            StringTokenizer st1 = new StringTokenizer(ids, ",");
            int appearances = 0;
            int appearancesTooMany = 0;
            appearancesTooMany = createConfig ? 1 : 2;
            while (st1.hasMoreTokens()) {
                String pid = st1.nextToken();
                if (!pid.equals(id) || ++appearances < appearancesTooMany) continue;
                logger.warn("detected duplicate policy id:   " + id + " Profile: " + this.mId);
                if (!createConfig) continue;
                throw new EProfileException("Duplicate policy id: " + id);
            }
        }
        setlist = null;
        try {
            setlist = policySetStore.getString("list", "");
        }
        catch (Exception st1) {
            // empty catch block
        }
        StringTokenizer st = new StringTokenizer((String)setlist, ",");
        int matches = 0;
        while (st.hasMoreTokens()) {
            String sId = st.nextToken();
            if (!sId.equals(setId)) continue;
            ConfigStore pStore = policySetStore.getSubStore(sId, ConfigStore.class);
            String list = null;
            try {
                list = pStore.getString("list", "");
            }
            catch (Exception e) {
                logger.warn("can't get policy id list!");
            }
            StringTokenizer st1 = new StringTokenizer(list, ",");
            while (st1.hasMoreTokens()) {
                String curId = st1.nextToken();
                String defaultRoot = curId + ".default";
                String curDefaultClassId = null;
                try {
                    curDefaultClassId = pStore.getString(defaultRoot + ".class_id");
                }
                catch (Exception e) {
                    logger.warn("can't get default plugin id!");
                }
                if (!curDefaultClassId.equals(defaultClassId) || curDefaultClassId.equals(PROP_NO_DEFAULT) || curDefaultClassId.equals(PROP_GENERIC_EXT_DEFAULT)) continue;
                ++matches;
                if (createConfig) {
                    if (matches != 1) continue;
                    logger.warn("attempt to add duplicate Policy " + defaultClassId + ":" + constraintClassId + " Contact System Administrator.");
                    throw new EProfileException("Attempt to add duplicate Policy : " + defaultClassId + ":" + constraintClassId);
                }
                if (matches <= 1) continue;
                logger.warn("attempt to add duplicate Policy " + defaultClassId + ":" + constraintClassId + " Contact System Administrator.");
            }
        }
        String defaultRoot = id + ".default";
        String constraintRoot = id + ".constraint";
        PluginInfo defInfo = this.registry.getPluginInfo("defaultPolicy", defaultClassId);
        if (defInfo == null) {
            logger.error(method + " Cannot find " + defaultClassId);
            throw new EProfileException("Cannot find " + defaultClassId);
        }
        String defaultClass = defInfo.getClassName();
        logger.debug(method + " loading default class " + defaultClass);
        PolicyDefault def = null;
        try {
            def = (PolicyDefault)Class.forName(defaultClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.warn(method + " default policy " + defaultClass + " " + e.getMessage(), (Throwable)e);
        }
        if (def == null) {
            logger.warn("Profile: failed to create " + defaultClass);
        } else {
            ConfigStore defStore = policyStore.getSubStore(defaultRoot, ConfigStore.class);
            def.init(this.engineConfig, defStore);
            logger.debug(method + " default class initialized.");
        }
        PluginInfo conInfo = this.registry.getPluginInfo("constraintPolicy", constraintClassId);
        if (conInfo == null) {
            logger.error(method + " Cannot find " + constraintClassId);
            throw new EProfileException("Cannot find " + constraintClassId);
        }
        String constraintClass = conInfo.getClassName();
        logger.debug(method + " loading constraint class " + constraintClass);
        PolicyConstraint constraint = null;
        try {
            constraint = (PolicyConstraint)Class.forName(constraintClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.warn(method + " constraint policy " + constraintClass + " " + e.getMessage(), (Throwable)e);
        }
        ProfilePolicy policy = null;
        if (constraint == null) {
            logger.warn(method + " failed to create " + constraintClass);
        } else {
            ConfigStore conStore = policyStore.getSubStore(constraintRoot, ConfigStore.class);
            constraint.init(conStore);
            policy = new ProfilePolicy(id, def, constraint);
            policies.addElement(policy);
            logger.debug(method + " constraint class initialized.");
        }
        if (createConfig) {
            logger.debug(method + " createConfig true; creating...");
            String list = null;
            try {
                list = policyStore.getString("list", null);
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            if (list == null || list.equals("")) {
                policyStore.putString("list", id);
            } else {
                policyStore.putString("list", list + "," + id);
            }
            policyStore.putString(id + ".default.name", defInfo.getName(Locale.getDefault()));
            policyStore.putString(id + ".default.class_id", defaultClassId);
            policyStore.putString(id + ".constraint.name", conInfo.getName(Locale.getDefault()));
            policyStore.putString(id + ".constraint.class_id", constraintClassId);
            try {
                this.mConfig.putString("lastModified", Long.toString(new Date().getTime()));
                policyStore.commit(false);
            }
            catch (EBaseException e) {
                logger.warn("Profile: commiting config store " + e.getMessage(), (Throwable)e);
            }
            logger.debug(method + " config created.");
        }
        logger.debug(method + "ends");
        return policy;
    }

    public ProfilePolicy getProfilePolicy(String setId, String id) {
        Vector<ProfilePolicy> policies = this.mPolicySet.get(setId);
        if (policies == null) {
            return null;
        }
        for (int i = 0; i < policies.size(); ++i) {
            ProfilePolicy policy = policies.elementAt(i);
            if (!policy.getId().equals(id)) continue;
            return policy;
        }
        return null;
    }

    public boolean isVisible() {
        try {
            return this.mConfig.getVisible();
        }
        catch (EBaseException e) {
            return false;
        }
    }

    public void setVisible(boolean visible) {
        this.mConfig.setVisible(visible);
    }

    public String getName(Locale locale) {
        try {
            return this.mConfig.getProfileName();
        }
        catch (EBaseException e) {
            return "";
        }
    }

    public void setName(Locale locale, String name) {
        this.mConfig.setProfileName(name);
    }

    public abstract Request[] createRequests(Map<String, String> var1, Locale var2) throws Exception;

    public String getDescription(Locale locale) {
        try {
            return this.mConfig.getDescription();
        }
        catch (EBaseException e) {
            return "";
        }
    }

    public void setDescription(Locale locale, String desc) {
        this.mConfig.setDescription(desc);
    }

    public void populateInput(Map<String, String> ctx, Request request) throws Exception {
        Enumeration<String> ids = this.getProfileInputIds();
        while (ids.hasMoreElements()) {
            String id = ids.nextElement();
            ProfileInput input = this.getProfileInput(id);
            input.populate(ctx, request);
        }
    }

    public Vector<ProfilePolicy> getPolicies(String setId) {
        return this.mPolicySet.get(setId);
    }

    public abstract String getPolicySetId(Request var1);

    public void populate(Request request) throws EProfileException {
        String method = "Profile: populate: ";
        String setId = this.getPolicySetId(request);
        Vector<ProfilePolicy> policies = this.getPolicies(setId);
        logger.debug(method + "policy setid =" + setId);
        for (int i = 0; i < policies.size(); ++i) {
            ProfilePolicy policy = policies.elementAt(i);
            policy.getDefault().populate(request);
        }
    }

    public void validate(Request request) throws ERejectException {
        String setId = this.getPolicySetId(request);
        logger.debug("Profile: validate start on setId=" + setId);
        Vector<ProfilePolicy> policies = this.getPolicies(setId);
        for (int i = 0; i < policies.size(); ++i) {
            ProfilePolicy policy = policies.elementAt(i);
            policy.getConstraint().validate(request);
        }
        logger.debug("Profile: change to pending state");
        request.setRequestStatus(RequestStatus.PENDING);
        logger.debug("Profile: validate end");
    }

    public Enumeration<ProfilePolicy> getProfilePolicies(String setId) {
        Vector<ProfilePolicy> policies = this.mPolicySet.get(setId);
        if (policies == null) {
            return null;
        }
        return policies.elements();
    }

    public Enumeration<String> getProfilePolicyIds(String setId) {
        Vector<ProfilePolicy> policies = this.mPolicySet.get(setId);
        if (policies == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < policies.size(); ++i) {
            ProfilePolicy policy = policies.elementAt(i);
            v.addElement(policy.getId());
        }
        return v.elements();
    }

    public void execute(Request request) throws EProfileException {
    }

    public abstract void submit(AuthToken var1, Request var2) throws EDeferException, EProfileException;

    public abstract void submit(AuthToken var1, Request var2, boolean var3) throws EDeferException, EProfileException;

    protected String auditSubjectID() {
        String subjectID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        subjectID = auditContext != null ? ((subjectID = (String)auditContext.get((Object)"userid")) != null ? subjectID.trim() : "$NonRoleUser$") : "$Unidentified$";
        return subjectID;
    }
}

