/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.mappers;

import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.cms.publish.mappers.MapAVAPattern;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.Vector;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MapRDNPattern {
    public static Logger logger = LoggerFactory.getLogger(MapRDNPattern.class);
    protected String[] mReqAttrs = null;
    protected String[] mCertAttrs = null;
    protected MapAVAPattern[] mAVAPatterns = null;
    protected String mPatternString = null;
    protected String mTestDN = null;

    public MapRDNPattern(String pattern) throws ELdapException {
        if (pattern == null || pattern.equals("")) {
            logger.debug("MapDNPattern: null pattern");
        } else {
            this.mPatternString = pattern;
            PushbackReader in = new PushbackReader(new StringReader(pattern));
            this.parse(in);
        }
    }

    public MapRDNPattern(PushbackReader in) throws ELdapException {
        this.parse(in);
    }

    private void parse(PushbackReader in) throws ELdapException {
        int lastChar;
        Vector<MapAVAPattern> avaPatterns = new Vector<MapAVAPattern>();
        MapAVAPattern avaPattern = null;
        do {
            avaPattern = new MapAVAPattern(in);
            avaPatterns.addElement(avaPattern);
            try {
                lastChar = in.read();
            }
            catch (IOException e) {
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
            }
        } while (lastChar == 43);
        if (lastChar != -1) {
            try {
                in.unread(lastChar);
            }
            catch (IOException e) {
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
            }
        }
        this.mAVAPatterns = new MapAVAPattern[avaPatterns.size()];
        avaPatterns.copyInto(this.mAVAPatterns);
        Vector<String> reqAttrs = new Vector<String>();
        for (int i = 0; i < this.mAVAPatterns.length; ++i) {
            String avaAttr = this.mAVAPatterns[i].getReqAttr();
            if (avaAttr == null || avaAttr.length() == 0) continue;
            reqAttrs.addElement(avaAttr);
        }
        this.mReqAttrs = new String[reqAttrs.size()];
        reqAttrs.copyInto(this.mReqAttrs);
        Vector<String> certAttrs = new Vector<String>();
        for (int i = 0; i < this.mAVAPatterns.length; ++i) {
            String avaAttr = this.mAVAPatterns[i].getCertAttr();
            if (avaAttr == null || avaAttr.length() == 0) continue;
            certAttrs.addElement(avaAttr);
        }
        this.mCertAttrs = new String[certAttrs.size()];
        certAttrs.copyInto(this.mCertAttrs);
    }

    public String formRDN(Request req, X500Name subject, CertificateExtensions ext) throws ELdapException {
        StringBuffer formedRDN = new StringBuffer();
        for (int i = 0; i < this.mAVAPatterns.length; ++i) {
            String ava;
            if (this.mTestDN != null) {
                this.mAVAPatterns[i].mTestDN = this.mTestDN;
            }
            if ((ava = this.mAVAPatterns[i].formAVA(req, subject, ext)) == null || ava.length() <= 0) continue;
            if (formedRDN.length() != 0) {
                formedRDN.append("+");
            }
            formedRDN.append(ava);
        }
        return formedRDN.toString();
    }

    public String[] getReqAttrs() {
        return (String[])this.mReqAttrs.clone();
    }

    public String[] getCertAttrs() {
        return (String[])this.mCertAttrs.clone();
    }
}

