/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.publishers;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.ELdapServerDownException;
import com.netscape.certsrv.publish.Publisher;
import com.netscape.cms.publish.publishers.LdapUserCertPublisher;
import com.netscape.cms.publish.publishers.PublisherUtils;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapCertSubjPublisher
extends Publisher {
    public static Logger logger = LoggerFactory.getLogger(LdapCertSubjPublisher.class);
    public static final String LDAP_CERTSUBJNAME_ATTR = "certSubjectName";
    protected String mCertAttr = "userCertificate;binary";
    protected String mSubjNameAttr = "certSubjectName";
    private boolean mInited = false;
    protected ConfigStore mConfig;

    public LdapCertSubjPublisher() {
    }

    public String getImplName() {
        return "LdapCertSubjPublisher";
    }

    public String getDescription() {
        return "LdapCertSubjPublisher";
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("certAttr=" + this.mCertAttr);
        v.addElement("subjectNameAttr=" + this.mSubjNameAttr);
        return v;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("certAttr=" + this.mCertAttr);
        v.addElement("subjectNameAttr=" + this.mSubjNameAttr);
        return v;
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public void init(ConfigStore config) throws EBaseException {
        if (this.mInited) {
            return;
        }
        this.mConfig = config;
        this.mCertAttr = this.mConfig.getString("certAttr", "userCertificate;binary");
        this.mSubjNameAttr = this.mConfig.getString(LDAP_CERTSUBJNAME_ATTR, LDAP_CERTSUBJNAME_ATTR);
        this.mInited = true;
    }

    public LdapCertSubjPublisher(String certAttr, String subjNameAttr) {
        this.mCertAttr = certAttr;
        this.mSubjNameAttr = subjNameAttr;
    }

    public String getCertAttr() {
        return this.mCertAttr;
    }

    public String getSubjNameAttr() {
        return this.mSubjNameAttr;
    }

    public void setSubjNameAttr(String subjNameAttr) {
        this.mSubjNameAttr = subjNameAttr;
    }

    public void setCertAttr(String certAttr) {
        this.mCertAttr = certAttr;
    }

    public void publish(LDAPConnection conn, String dn, Object certObj) throws ELdapException {
        if (conn == null) {
            logger.warn("LdapCertSubjPublisher: no LDAP connection");
            return;
        }
        if (!(certObj instanceof X509Certificate)) {
            throw new IllegalArgumentException("Illegal arg to publish");
        }
        X509Certificate cert = (X509Certificate)certObj;
        try {
            boolean hasCert = false;
            boolean hasSubjname = false;
            byte[] certEnc = cert.getEncoded();
            String subjName = ((X500Name)cert.getSubjectDN()).toLdapDNString();
            LDAPSearchResults res = conn.search(dn, 0, "(objectclass=*)", new String[]{this.mCertAttr, this.mSubjNameAttr}, false);
            LDAPEntry entry = res.next();
            LDAPAttribute certs = entry.getAttribute(this.mCertAttr);
            LDAPAttribute subjnames = entry.getAttribute(this.mSubjNameAttr);
            if (certs != null) {
                hasCert = LdapUserCertPublisher.ByteValueExists(certs, certEnc);
            }
            if (subjnames != null) {
                hasSubjname = LdapUserCertPublisher.StringValueExists(subjnames, subjName);
            }
            if (hasCert && hasSubjname) {
                logger.info("publish: " + subjName + " already has cert & subject name");
                return;
            }
            LDAPModificationSet modSet = new LDAPModificationSet();
            if (!hasCert) {
                logger.info("publish: adding cert to " + subjName);
                modSet.add(0, new LDAPAttribute(this.mCertAttr, certEnc));
            }
            if (!hasSubjname) {
                logger.info("publish: adding " + subjName + " to " + dn);
                modSet.add(0, new LDAPAttribute(this.mSubjNameAttr, subjName));
            }
            conn.modify(dn, modSet);
        }
        catch (CertificateEncodingException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_PUBLISH_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_GET_DER_ENCODED_CERT_FAILED", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}), (Throwable)e);
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_PUBLISHER_EXCEPTION", (Object[])new Object[]{"", e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_PUBLISH_USERCERT_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_PUBLISH_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_PUBLISH_USERCERT_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
    }

    public void unpublish(LDAPConnection conn, String dn, Object certObj) throws ELdapException {
        if (!(certObj instanceof X509Certificate)) {
            throw new IllegalArgumentException("Illegal arg to publish");
        }
        try {
            boolean hasCert = false;
            boolean hasSubjname = false;
            boolean hasAnotherCert = false;
            X509Certificate cert = (X509Certificate)certObj;
            String subjName = ((X500Name)cert.getSubjectDN()).toLdapDNString();
            byte[] certEnc = cert.getEncoded();
            LDAPSearchResults res = conn.search(dn, 0, "(objectclass=*)", new String[]{this.mCertAttr, this.mSubjNameAttr}, false);
            LDAPEntry entry = res.next();
            LDAPAttribute certs = entry.getAttribute(this.mCertAttr);
            LDAPAttribute subjnames = entry.getAttribute(this.mSubjNameAttr);
            if (certs != null) {
                hasCert = LdapUserCertPublisher.ByteValueExists(certs, certEnc);
                Enumeration vals = certs.getByteValues();
                byte[] val = null;
                while (vals.hasMoreElements()) {
                    val = (byte[])vals.nextElement();
                    if (PublisherUtils.byteArraysAreEqual(certEnc, val)) {
                        hasCert = true;
                        continue;
                    }
                    try {
                        X509CertImpl certval = new X509CertImpl(val);
                        String subjnam = ((X500Name)certval.getSubjectDN()).toLdapDNString();
                        if (!subjnam.equalsIgnoreCase(subjName)) continue;
                        hasAnotherCert = true;
                    }
                    catch (CertificateEncodingException e) {
                        logger.warn("LdapCertSubjPublisher: unpublish: an invalid cert in dn entry encountered: " + e.getMessage(), (Throwable)e);
                    }
                    catch (CertificateException e) {
                        logger.warn("LdapCertSubjPublisher: unpublish: an invalid cert in dn entry encountered: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (subjnames != null) {
                hasSubjname = LdapUserCertPublisher.StringValueExists(subjnames, subjName);
            }
            if (!hasCert && !hasSubjname) {
                logger.info("unpublish: " + subjName + " already has not cert & subjname");
                return;
            }
            LDAPModificationSet modSet = new LDAPModificationSet();
            if (hasCert) {
                logger.info("unpublish: deleting cert " + subjName + " from " + dn);
                modSet.add(1, new LDAPAttribute(this.mCertAttr, certEnc));
            }
            if (hasSubjname && !hasAnotherCert) {
                logger.info("unpublish: deleting subject name " + subjName + " from " + dn);
                modSet.add(1, new LDAPAttribute(this.mSubjNameAttr, subjName));
            }
            conn.modify(dn, modSet);
        }
        catch (CertificateEncodingException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_UNPUBLISH_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_GET_DER_ENCODED_CERT_FAILED", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_UNPUBLISH_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_GET_LDAP_DN_STRING_FAILED", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}), (Throwable)e);
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_UNPUBLISH_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_UNPUBLISH_USERCERT_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
    }
}

