/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.CertStatusChangeRequestEvent;
import com.netscape.certsrv.logging.event.CertStatusChangeRequestProcessedEvent;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caDoUnrevoke1", urlPatterns={"/ee/subsystem/ca/doUnrevoke"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="ID", value="caDoUnrevoke1"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.ca.certificate"), @WebInitParam(name="interface", value="ee")})
public class DoUnrevokeTPS
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(DoUnrevokeTPS.class);
    private static final long serialVersionUID = -6245049221697655642L;
    private CertificateRepository mCertDB;
    private RequestQueue mQueue;
    private CAPublisherProcessor mPublisherProcessor;
    private String errorString = "error=";
    private String o_status = "status=0";
    private static final String OFF_HOLD = "off-hold";
    private static final int OFF_HOLD_REASON = 6;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        this.mCertDB = engine.getCertificateRepository();
        this.mPublisherProcessor = engine.getPublisherProcessor();
        this.mQueue = engine.getRequestQueue();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        this.mRenderResult = false;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        EBaseException error = null;
        Locale[] locale = new Locale[1];
        try {
            BigInteger[] serialNumbers = this.getSerialNumbers(req);
            AuthToken authToken = this.authenticate(cmsReq);
            String authMgr = "noAuthManager";
            if (authToken == null) {
                logger.warn("DoUnrevokeTPS::process() -  authToken is null!");
                return;
            }
            authMgr = authToken.getInString("authMgrInstName");
            String agentID = authToken.getInString("userid");
            String initiative = "fromAgent agentID: " + agentID + " authenticated by " + authMgr;
            AuthzToken authzToken = null;
            try {
                authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "unrevoke");
            }
            catch (EAuthzAccessDenied e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (authzToken == null) {
                cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
                this.o_status = "status=3";
                this.errorString = "error=unauthorized";
                String pp = this.o_status + "&" + this.errorString;
                byte[] b = pp.getBytes();
                resp.setContentType("application/x-www-form-urlencoded");
                resp.setContentLength(b.length);
                ServletOutputStream os = resp.getOutputStream();
                os.write(b);
                os.flush();
                return;
            }
            this.process(serialNumbers, req, resp, locale[0], initiative);
        }
        catch (NumberFormatException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_INVALID_SERIAL_NUM_FORMAT", (Object[])new Object[0]), (Throwable)e);
            error = new EBaseException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_BASE_INVALID_NUMBER_FORMAT", (String[])new String[0]), (Throwable)e);
        }
        catch (EBaseException e) {
            error = e;
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (error == null) {
                this.o_status = "status=0";
                this.errorString = "error=";
            } else {
                this.o_status = "status=3";
                this.errorString = "error=" + error.toString();
            }
            String pp = this.o_status + "&" + this.errorString;
            byte[] b = pp.getBytes();
            resp.setContentType("application/x-www-form-urlencoded");
            resp.setContentLength(b.length);
            ServletOutputStream os = resp.getOutputStream();
            os.write(b);
            os.flush();
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    private void process(BigInteger[] serialNumbers, HttpServletRequest req, HttpServletResponse resp, Locale locale, String initiative) throws EBaseException {
        block27: {
            X509CertImpl[] certs;
            CAEngine engine = CAEngine.getInstance();
            CertificateRepository certRepository = engine.getCertificateRepository();
            Auditor auditor = engine.getAuditor();
            String auditSubjectID = this.auditSubjectID();
            String auditSerialNumber = this.auditSerialNumber(serialNumbers[0].toString());
            String auditRequestType = OFF_HOLD;
            RequestStatus auditApprovalStatus = null;
            String auditReasonNum = String.valueOf(6);
            Request unrevReq = null;
            try {
                Object snList = "";
                certs = new X509CertImpl[serialNumbers.length];
                for (int i = 0; i < serialNumbers.length; ++i) {
                    certs[i] = certRepository.getX509Certificate(serialNumbers[i]);
                    if (((String)snList).length() > 0) {
                        snList = (String)snList + ", ";
                    }
                    snList = (String)snList + "0x" + serialNumbers[i].toString(16);
                }
                CertRequestRepository requestRepository = engine.getCertRequestRepository();
                unrevReq = requestRepository.createRequest("unrevocation");
                auditor.log((LogEvent)new CertStatusChangeRequestEvent(auditSubjectID, "Success", unrevReq, auditSerialNumber, auditRequestType));
                unrevReq.setExtData("requestType", "unrevocation");
                unrevReq.setExtData("OLD_SERIALS", serialNumbers);
                unrevReq.setExtData("requestorType", "Agent");
            }
            catch (EBaseException e) {
                auditor.log((LogEvent)new CertStatusChangeRequestEvent(auditSubjectID, "Failure", unrevReq, auditSerialNumber, auditRequestType));
                return;
            }
            try {
                this.mQueue.processRequest(unrevReq);
                auditApprovalStatus = unrevReq.getRequestStatus();
                RequestStatus status = unrevReq.getRequestStatus();
                String type = unrevReq.getRequestType();
                if (status == RequestStatus.COMPLETE || type.equals("uncert4crl") && status == RequestStatus.SVC_PENDING) {
                    Integer updateCRLResult;
                    Integer result = unrevReq.getExtDataInInteger("Result");
                    if (result != null && result.equals(Request.RES_SUCCESS)) {
                        if (certs[0] != null) {
                            logger.info("Unrevocation request reqID {} {} is {}. DN requested: {} serial number: 0x{}", new Object[]{unrevReq.getRequestId(), initiative, "completed", certs[0].getSubjectName(), "0x" + serialNumbers[0].toString(16)});
                        }
                    } else {
                        String error = unrevReq.getExtDataInString("Error");
                        if (error != null) {
                            this.o_status = "status=3";
                            this.errorString = "error=" + error;
                            if (certs[0] != null) {
                                logger.info("Unrevocation request reqID {} {} is {}. DN requested: {} serial number: 0x{}", new Object[]{unrevReq.getRequestId(), initiative, "completed with error: " + error, certs[0].getSubjectName(), "0x" + serialNumbers[0].toString(16)});
                            }
                        }
                    }
                    if ((updateCRLResult = unrevReq.getExtDataInInteger("crlUpdateStatus")) != null) {
                        String publError;
                        Object publishCRLResult;
                        String crlError;
                        if (!updateCRLResult.equals(Request.RES_SUCCESS) && (crlError = unrevReq.getExtDataInString("crlUpdateError")) != null) {
                            this.o_status = "status=3";
                            this.errorString = "error=" + crlError;
                        }
                        if ((publishCRLResult = unrevReq.getExtDataInInteger("crlPublishStatus")) != null && !((Integer)publishCRLResult).equals(Request.RES_SUCCESS) && (publError = unrevReq.getExtDataInString("crlPublishError")) != null) {
                            this.o_status = "status=3";
                            this.errorString = "error=" + publError;
                        }
                    }
                    for (CRLIssuingPoint crl : engine.getCRLIssuingPoints()) {
                        String publishErrorStr;
                        String error;
                        String publishStatusStr;
                        Integer publishResult;
                        String updateErrorStr;
                        String error2;
                        String updateStatusStr;
                        Integer updateResult;
                        String crlId = crl.getId();
                        if (crlId.equals("MasterCRL") || (updateResult = unrevReq.getExtDataInInteger(updateStatusStr = crl.getCrlUpdateStatusStr())) == null) continue;
                        if (!updateResult.equals(Request.RES_SUCCESS) && (error2 = unrevReq.getExtDataInString(updateErrorStr = crl.getCrlUpdateErrorStr())) != null) {
                            this.o_status = "status=3";
                            this.errorString = "error=" + error2;
                        }
                        if ((publishResult = unrevReq.getExtDataInInteger(publishStatusStr = crl.getCrlPublishStatusStr())) == null || publishResult.equals(Request.RES_SUCCESS) || (error = unrevReq.getExtDataInString(publishErrorStr = crl.getCrlPublishErrorStr())) == null) continue;
                        this.o_status = "status=3";
                        this.errorString = "error=" + error;
                    }
                    if (this.mPublisherProcessor != null && this.mPublisherProcessor.ldapEnabled()) {
                        Integer[] ldapPublishStatus = unrevReq.getExtDataInIntegerArray("ldapPublishStatus");
                        if (ldapPublishStatus != null && ldapPublishStatus[0] != Request.RES_SUCCESS) {
                            this.o_status = "status=3";
                            this.errorString = "error=Problem in publishing to LDAP";
                        }
                    } else if (this.mPublisherProcessor == null || !this.mPublisherProcessor.ldapEnabled()) {
                        this.o_status = "status=3";
                        this.errorString = "error=LDAP Publisher not enabled";
                    }
                } else if (status == RequestStatus.PENDING) {
                    this.o_status = "status=2";
                    this.errorString = "error=" + status.toString();
                    if (certs[0] != null) {
                        logger.info("Unrevocation request reqID {} {} is {}. DN requested: {} serial number: 0x{}", new Object[]{unrevReq.getRequestId(), initiative, "pending", certs[0].getSubjectName(), "0x" + serialNumbers[0].toString(16)});
                    }
                } else {
                    this.o_status = "status=2";
                    this.errorString = "error=Undefined request status";
                    if (certs[0] != null) {
                        logger.info("Unrevocation request reqID {} {} is {}. DN requested: {} serial number: 0x{}", new Object[]{unrevReq.getRequestId(), initiative, status, certs[0].getSubjectName(), "0x" + serialNumbers[0].toString(16)});
                    }
                }
                if (auditApprovalStatus == RequestStatus.COMPLETE || auditApprovalStatus == RequestStatus.REJECTED || auditApprovalStatus == RequestStatus.CANCELED) {
                    auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Success", unrevReq, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus));
                }
            }
            catch (EBaseException eAudit1) {
                if (auditApprovalStatus != RequestStatus.COMPLETE && auditApprovalStatus != RequestStatus.REJECTED && auditApprovalStatus != RequestStatus.CANCELED) break block27;
                auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", unrevReq, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus));
            }
        }
    }

    private BigInteger[] getSerialNumbers(HttpServletRequest req) throws NumberFormatException {
        String serialNumString = req.getParameter("serialNumber");
        StringTokenizer snList = new StringTokenizer(serialNumString, " ");
        Vector<BigInteger> biList = new Vector<BigInteger>();
        while (snList.hasMoreTokens()) {
            String snStr = snList.nextToken();
            if (snStr != null) {
                BigInteger bi = (snStr = snStr.trim()).startsWith("0x") || snStr.startsWith("0X") ? new BigInteger(snStr.substring(2), 16) : new BigInteger(snStr);
                if (bi.compareTo(BigInteger.ZERO) < 0) {
                    throw new NumberFormatException();
                }
                biList.addElement(bi);
                continue;
            }
            throw new NumberFormatException();
        }
        if (biList.size() < 1) {
            throw new NumberFormatException();
        }
        BigInteger[] biNumbers = new BigInteger[biList.size()];
        for (int i = 0; i < biList.size(); ++i) {
            biNumbers[i] = (BigInteger)biList.elementAt(i);
        }
        return biNumbers;
    }

    private String auditSerialNumber(String eeSerialNumber) {
        Object serialNumber = null;
        if (eeSerialNumber != null) {
            serialNumber = eeSerialNumber.trim();
            serialNumber = "0x" + new BigInteger((String)serialNumber).toString(16);
        } else {
            serialNumber = "<null>";
        }
        return serialNumber;
    }
}

