/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.UnauthorizedException;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.CertStatusChangeRequestEvent;
import com.netscape.certsrv.logging.event.CertStatusChangeRequestProcessedEvent;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.certsrv.usrgrp.Certificates;
import com.netscape.cms.servlet.cert.CertProcessor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.usrgrp.User;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.InvalidityDateExtension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationProcessor
extends CertProcessor {
    public static Logger logger = LoggerFactory.getLogger(RevocationProcessor.class);
    public static final String REVOKE = "revoke";
    public static final String ON_HOLD = "on-hold";
    public static final String OFF_HOLD = "off-hold";
    long startTime;
    CertificateAuthority authority;
    CertificateRepository repo;
    RequestQueue requestQueue;
    CAPublisherProcessor publisherProcessor;
    String initiative;
    CertId serialNumber;
    RevocationReason revocationReason;
    Date invalidityDate;
    String comments;
    String requestType;
    CRLExtensions entryExtn;
    Collection<X509CertImpl> certificates = new ArrayList<X509CertImpl>();
    Collection<RevokedCertImpl> revCertImpls = new ArrayList<RevokedCertImpl>();
    Request request;
    RequestStatus requestStatus;

    public RevocationProcessor(String id, Locale locale) {
        super(id, locale);
    }

    public CertificateAuthority getAuthority() {
        return this.authority;
    }

    public void setAuthority(CertificateAuthority authority) {
        this.authority = authority;
        CAEngine engine = CAEngine.getInstance();
        this.repo = engine.getCertificateRepository();
        this.requestQueue = engine.getRequestQueue();
        this.publisherProcessor = engine.getPublisherProcessor();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public String getInitiative() {
        return this.initiative;
    }

    public void setInitiative(String initiative) {
        this.initiative = initiative;
    }

    public CertId getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(CertId serialNumber) {
        this.serialNumber = serialNumber;
    }

    public RevocationReason getRevocationReason() {
        return this.revocationReason;
    }

    public void setRevocationReason(RevocationReason revocationReason) {
        this.revocationReason = revocationReason;
    }

    public Date getInvalidityDate() {
        return this.invalidityDate;
    }

    public void setInvalidityDate(Date invalidityDate) {
        this.invalidityDate = invalidityDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public RequestStatus getRequestStatus() {
        return this.requestStatus;
    }

    public void setRequestStatus(RequestStatus requestStatus) {
        this.requestStatus = requestStatus;
    }

    public void addCertificate(X509CertImpl cert) {
        this.certificates.add(cert);
    }

    public Collection<X509CertImpl> getCertificates() {
        return this.certificates;
    }

    public Request getRequest() {
        return this.request;
    }

    public boolean isMemberOfSubsystemGroup(X509Certificate clientCert) {
        if (clientCert == null) {
            return false;
        }
        try {
            X509Certificate[] certChain = new X509Certificate[]{clientCert};
            User user = this.ul.locateUser(new Certificates(certChain));
            return this.ug.isMemberOf(user, "Subsystem Group");
        }
        catch (Exception e) {
            logger.warn("RevocationProcessor:  Failed to map certificate '" + clientCert.getSubjectDN().getName() + "' to user: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void validateCertificateToRevoke(String subjectDN, CertRecord targetRecord, boolean revokingCACert) throws EBaseException {
        X509CertImpl targetCert = targetRecord.getCertificate();
        BigInteger targetSerialNumber = targetCert.getSerialNumber();
        X500Name targetSubjectDN = targetCert.getSubjectName();
        if (subjectDN != null && !subjectDN.equals(targetSubjectDN.toString())) {
            throw new UnauthorizedException("Certificate 0x" + targetSerialNumber.toString(16) + " belongs to different subject.");
        }
        boolean targetIsCACert = this.isSystemCertificate((X509Certificate)targetCert);
        if (!revokingCACert && targetIsCACert) {
            throw new UnauthorizedException("Certificate 0x" + targetSerialNumber.toString(16) + " is a CA signing certificate");
        }
        if (revokingCACert && !targetIsCACert) {
            throw new UnauthorizedException("Certificate 0x" + targetSerialNumber.toString(16) + " is not a CA signing certificate");
        }
        if (targetRecord.getStatus().equals("REVOKED")) {
            throw new BadRequestException(CMS.getLogMessage((String)"CA_CERTIFICATE_ALREADY_REVOKED_1", (Object[])new Object[]{targetSerialNumber.toString(16)}));
        }
    }

    public void addCertificateToRevoke(X509CertImpl cert) {
        this.addCertificate(cert);
        this.revCertImpls.add(new RevokedCertImpl(cert.getSerialNumber(), new Date(), this.entryExtn));
    }

    public void addSerialNumberToUnrevoke(BigInteger serialNumber) throws EBaseException {
        CertRecord record = this.getCertificateRecord(serialNumber);
        X509CertImpl cert = record.getCertificate();
        this.addCertificate(cert);
    }

    public CertRecord[] getCertificateRecords(BigInteger[] serialNumbers) throws EBaseException {
        CertRecord[] records = new CertRecord[serialNumbers.length];
        for (int i = 0; i < serialNumbers.length; ++i) {
            records[i] = this.getCertificateRecord(serialNumbers[i]);
        }
        return records;
    }

    public CertRecord getCertificateRecord(CertId id) throws EBaseException {
        return this.getCertificateRecord(id.toBigInteger());
    }

    public CertRecord getCertificateRecord(BigInteger serialNumber) throws EBaseException {
        return this.repo.readCertificateRecord(serialNumber);
    }

    public X509CertImpl[] getCertificates(CertRecord[] records) throws EBaseException {
        X509CertImpl[] certs = new X509CertImpl[records.length];
        for (int i = 0; i < records.length; ++i) {
            certs[i] = records[i].getCertificate();
        }
        return certs;
    }

    public void createCRLExtension() throws IOException {
        this.entryExtn = new CRLExtensions();
        CRLReasonExtension crlReasonExtn = new CRLReasonExtension(this.revocationReason);
        this.entryExtn.set(crlReasonExtn.getName(), (Extension)crlReasonExtn);
        if (this.invalidityDate != null) {
            InvalidityDateExtension invalidityDateExtn = new InvalidityDateExtension(this.invalidityDate);
            this.entryExtn.set(invalidityDateExtn.getName(), (Extension)invalidityDateExtn);
        }
    }

    public void createRevocationRequest() throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertRequestRepository requestRepository = engine.getCertRequestRepository();
        this.request = requestRepository.createRequest("revocation");
        this.request.setExtData("requestType", "revocation");
        this.request.setExtData("OLD_CERTS", this.certificates.toArray(new X509CertImpl[this.certificates.size()]));
        this.request.setExtData("CERT_INFO", this.revCertImpls.toArray(new RevokedCertImpl[this.revCertImpls.size()]));
        if ("fromUser".equals(this.initiative)) {
            this.request.setExtData("requestorType", "EE");
        } else {
            this.request.setExtData("requestorType", "Agent");
        }
        if (this.comments != null) {
            this.request.setExtData("csrRequestorComments", this.comments);
        }
        this.request.setExtData("revocationReason", Integer.valueOf(this.revocationReason.getCode()));
    }

    public void processRevocationRequest() throws EBaseException {
        logger.info("RevocationProcessor: Processing revocation request " + this.request.getRequestId().toHexString());
        logger.debug("RevocationProcessor: - initiative: " + this.initiative);
        logger.debug("RevocationProcessor: - reason: " + this.revocationReason);
        logger.debug("RevocationProcessor: - certs:");
        for (X509CertImpl cert : this.certificates) {
            logger.debug("RevocationProcessor:   - serial number: " + cert.getSerialNumber().toString(16));
            logger.debug("RevocationProcessor:   - subject: " + cert.getSubjectName());
        }
        this.requestQueue.processRequest(this.request);
        this.requestStatus = this.request.getRequestStatus();
        logger.debug("RevocationProcessor: - status: " + this.requestStatus);
        String type = this.request.getRequestType();
        logger.debug("RevocationProcessor: - type: " + type);
        if (this.requestStatus == RequestStatus.COMPLETE || this.requestStatus == RequestStatus.SVC_PENDING && type.equals("cert4crl")) {
            Integer result = this.request.getExtDataInInteger("Result");
            if (result.equals(Request.RES_ERROR)) {
                String[] svcErrors = this.request.getExtDataInStringArray("serviceErrors");
                if (svcErrors != null) {
                    for (String err : svcErrors) {
                        logger.debug("RevocationProcessor: - error: " + err);
                    }
                }
                throw new EBaseException(CMS.getLogMessage((String)"CMSGW_ERROR_MARKING_CERT_REVOKED", (Object[])new Object[0]));
            }
            long endTime = new Date().getTime();
            logger.debug("RevocationProcessor: - time: " + (endTime - this.startTime));
        }
    }

    public void createUnrevocationRequest() throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertRequestRepository requestRepository = engine.getCertRequestRepository();
        this.request = requestRepository.createRequest("unrevocation");
        this.request.setExtData("requestType", "unrevocation");
        ArrayList<BigInteger> serialNumbers = new ArrayList<BigInteger>();
        for (X509CertImpl cert : this.certificates) {
            serialNumbers.add(cert.getSerialNumber());
        }
        this.request.setExtData("OLD_SERIALS", serialNumbers.toArray(new BigInteger[serialNumbers.size()]));
        this.request.setExtData("requestorType", "Agent");
    }

    public void processUnrevocationRequest() throws EBaseException {
        Integer result;
        logger.info("RevocationProcessor: Processing unrevocation request " + this.request.getRequestId().toHexString());
        logger.debug("RevocationProcessor: - initiative: " + this.initiative);
        logger.debug("RevocationProcessor: - certs:");
        for (X509CertImpl cert : this.certificates) {
            logger.debug("RevocationProcessor:   - serial number: " + cert.getSerialNumber().toString(16));
            logger.debug("RevocationProcessor:   - subject: " + cert.getSubjectName());
        }
        this.requestQueue.processRequest(this.request);
        this.requestStatus = this.request.getRequestStatus();
        logger.debug("RevocationProcessor: - status: " + this.requestStatus);
        String type = this.request.getRequestType();
        logger.debug("RevocationProcessor: - type: " + type);
        if ((this.requestStatus == RequestStatus.COMPLETE || this.requestStatus == RequestStatus.SVC_PENDING && type.equals("uncert4crl")) && (result = this.request.getExtDataInInteger("Result")).equals(Request.RES_ERROR)) {
            String error = this.request.getExtDataInString("Error");
            logger.debug("RevocationProcessor: - error: " + error);
        }
    }

    public boolean isSystemCertificate(X509Certificate cert) throws EBaseException {
        X509CertImpl caCert = this.authority.getCACert();
        if (caCert == null) {
            return false;
        }
        if (!caCert.getSerialNumber().equals(cert.getSerialNumber())) {
            return false;
        }
        return caCert.getSubjectDN().equals(caCert.getIssuerDN());
    }

    public void auditChangeRequest(String status) {
        Auditor auditor = this.engine.getAuditor();
        auditor.log((LogEvent)new CertStatusChangeRequestEvent(auditor.getSubjectID(), status, this.request, this.serialNumber == null ? "<null>" : this.serialNumber.toHexString(), this.requestType));
    }

    public void auditChangeRequestProcessed(String status) {
        Auditor auditor = this.engine.getAuditor();
        if (this.requestStatus != RequestStatus.COMPLETE && this.requestStatus != RequestStatus.REJECTED && this.requestStatus != RequestStatus.CANCELED) {
            return;
        }
        auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditor.getSubjectID(), status, this.request, this.serialNumber == null ? "<null>" : this.serialNumber.toHexString(), this.requestType, String.valueOf(this.revocationReason.getCode()), this.requestStatus));
    }
}

