/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.nss;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.nss.NSSCertCLI;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSCertShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(NSSCertShowCLI.class);

    public NSSCertShowCLI(NSSCertCLI nssCertCLI) {
        super("show", "Show certificate", (CLI)nssCertCLI);
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] <nickname>", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        String nickname = null;
        if (cmdArgs.length < 1) {
            throw new Exception("Missing certificate nickname");
        }
        nickname = cmdArgs[0];
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        CryptoManager cm = CryptoManager.getInstance();
        X509Certificate cert = cm.findCertByNickname(nickname);
        NSSCertCLI.printCertInfo(cert);
    }
}

