/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.selftests;

import com.netscape.certsrv.selftests.SelfTestClient;
import com.netscape.certsrv.selftests.SelfTestCollection;
import com.netscape.certsrv.selftests.SelfTestData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.selftests.SelfTestCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfTestFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(SelfTestFindCLI.class);
    public SelfTestCLI selfTestCLI;

    public SelfTestFindCLI(SelfTestCLI selfTestCLI) {
        super("find", "Find selftests", (CLI)selfTestCLI);
        this.selfTestCLI = selfTestCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [FILTER] [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        String filter = cmdArgs.length > 0 ? cmdArgs[0] : null;
        String s = cmd.getOptionValue("start");
        Integer start = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        SelfTestClient selfTestClient = this.selfTestCLI.getSelfTestClient();
        SelfTestCollection result = selfTestClient.findSelfTests(filter, start, size);
        MainCLI.printMessage(result.getTotal() + " entries matched");
        if (result.getTotal() == 0) {
            return;
        }
        Collection selfTests = result.getEntries();
        boolean first = true;
        for (SelfTestData selfTestInfo : selfTests) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            SelfTestCLI.printSelfTestData(selfTestInfo);
        }
        MainCLI.printMessage("Number of entries returned " + selfTests.size());
    }
}

