/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.user;

import com.netscape.certsrv.user.UserClient;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.user.UserCertCLI;
import java.net.URLEncoder;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCertRemoveCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(UserCertRemoveCLI.class);
    public UserCertCLI userCertCLI;

    public UserCertRemoveCLI(UserCertCLI userCertCLI) {
        super("del", "Remove user certificate", (CLI)userCertCLI);
        this.userCertCLI = userCertCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <User ID> <Cert ID> [OPTIONS...]", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 2) {
            throw new Exception("Incorrect number of arguments specified.");
        }
        String userID = cmdArgs[0];
        String certID = cmdArgs[1];
        logger.info("Removing cert " + certID + " from user " + userID);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        UserClient userClient = this.userCertCLI.getUserClient();
        userClient.removeUserCert(userID, URLEncoder.encode(certID, "UTF-8"));
        MainCLI.printMessage("Deleted certificate \"" + certID + "\"");
    }
}

