/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ocsp.cli;

import com.netscape.certsrv.ocsp.IDefStore;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.base.FileConfigStorage;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import java.io.File;
import java.util.Enumeration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.tomcat.util.net.jss.TomcatJSS;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.server.ocsp.OCSPConfig;
import org.dogtagpki.server.ocsp.OCSPEngineConfig;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPCRLIssuingPointFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(OCSPCRLIssuingPointFindCLI.class);

    public OCSPCRLIssuingPointFindCLI(CLI parent) {
        super("find", "Find OCSP CRL issuing points", parent);
    }

    public void createOptions() {
        Option option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String s = cmd.getOptionValue("size", "100");
        int size = Integer.valueOf(s);
        TomcatJSS tomcatjss = TomcatJSS.getInstance();
        tomcatjss.loadConfig();
        tomcatjss.init();
        String instanceDir = CMS.getInstanceDir();
        String subsystem = this.parent.getParent().getParent().getName();
        String subsystemDir = instanceDir + File.separator + subsystem;
        String configFile = subsystemDir + File.separator + "conf" + File.separator + "CS.cfg";
        logger.info("Loading " + configFile);
        FileConfigStorage storage = new FileConfigStorage(configFile);
        OCSPEngineConfig cs = new OCSPEngineConfig((ConfigStorage)storage);
        cs.load();
        DatabaseConfig dbConfig = cs.getDatabaseConfig();
        LDAPConfig ldapConfig = dbConfig.getLDAPConfig();
        ldapConfig.putInteger("minConns", 1);
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        DBSubsystem dbSubsystem = new DBSubsystem();
        dbSubsystem.setEngineConfig((EngineConfig)cs);
        dbSubsystem.init(dbConfig, ldapConfig, socketConfig, passwordStore);
        OCSPConfig ocspConfig = cs.getOCSPConfig();
        String storeID = ocspConfig.getString("storeId");
        String className = ocspConfig.getString("store." + storeID + ".class");
        ConfigStore storeConfig = ocspConfig.getSubStore("store." + storeID, ConfigStore.class);
        IDefStore store = (IDefStore)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        store.init(storeConfig, dbSubsystem);
        Enumeration<CRLIssuingPointRecord> records = store.searchAllCRLIssuingPointRecord(size);
        boolean first = true;
        while (records.hasMoreElements()) {
            CRLIssuingPointRecord record = records.nextElement();
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            System.out.println("  CRL Issuing Point ID: " + record.getId());
            X509CertImpl certImpl = new X509CertImpl(record.getCACert());
            System.out.println("  CA Subject DN: " + certImpl.getSubjectName());
            System.out.println("  CA Issuer DN: " + certImpl.getIssuerName());
            System.out.println("  CRL Number: " + record.getCRLNumber());
            System.out.println("  CRL Size: " + record.getCRLSize());
            System.out.println("  Delta CRL Number: " + record.getDeltaCRLNumber());
            System.out.println("  Delta CRL Size: " + record.getDeltaCRLSize());
            System.out.println("  This Update: " + record.getThisUpdate());
            System.out.println("  Next Update: " + record.getNextUpdate());
            System.out.println("  First Unsaved: " + record.getFirstUnsaved());
        }
    }
}

