/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.logging.event;

import com.netscape.certsrv.logging.SignedAuditEvent;
import com.netscape.cmscore.request.Request;
import java.security.cert.CertificateEncodingException;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class CertRequestProcessedEvent
extends SignedAuditEvent {
    private static final String LOGGING_PROPERTY = "LOGGING_SIGNED_AUDIT_CERT_REQUEST_PROCESSED";
    public static final String SIGNED_AUDIT_CERT_REQUEST_REASON = "requestNotes";

    public CertRequestProcessedEvent() {
        super(LOGGING_PROPERTY);
    }

    public static CertRequestProcessedEvent createSuccessEvent(String subjectID, String requesterID, String infoName, String infoValue) {
        CertRequestProcessedEvent event = new CertRequestProcessedEvent();
        event.setAttribute("SubjectID", subjectID);
        event.setAttribute("Outcome", "Success");
        event.setAttribute("ReqID", requesterID);
        event.setAttribute("InfoName", infoName);
        event.setAttribute("InfoValue", infoValue);
        return event;
    }

    public static CertRequestProcessedEvent createSuccessEvent(String subjectID, String requesterID, String infoName, X509CertImpl x509cert) {
        CertRequestProcessedEvent event = new CertRequestProcessedEvent();
        event.setAttribute("SubjectID", subjectID);
        event.setAttribute("Outcome", "Success");
        event.setAttribute("ReqID", requesterID);
        event.setAttribute("CertSerialNum", "0x" + x509cert.getSerialNumber().toString(16));
        return event;
    }

    public static CertRequestProcessedEvent createFailureEvent(String subjectID, String requesterID, String infoName, String infoValue) {
        CertRequestProcessedEvent event = new CertRequestProcessedEvent();
        event.setAttribute("SubjectID", subjectID);
        event.setAttribute("Outcome", "Failure");
        event.setAttribute("ReqID", requesterID);
        event.setAttribute("InfoName", infoName);
        event.setAttribute("InfoValue", infoValue);
        return event;
    }

    public static CertRequestProcessedEvent createFailureEvent(String subjectID, String requesterID, String infoName, Request request) {
        CertRequestProcessedEvent event = new CertRequestProcessedEvent();
        event.setAttribute("SubjectID", subjectID);
        event.setAttribute("Outcome", "Failure");
        event.setAttribute("ReqID", requesterID);
        event.setAttribute("InfoName", infoName);
        event.setAttribute("InfoValue", CertRequestProcessedEvent.auditInfoValue(request));
        return event;
    }

    static String auditInfoCertValue(X509CertImpl x509cert) {
        if (x509cert == null) {
            return "<null>";
        }
        byte[] rawData = null;
        try {
            rawData = x509cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            return "<null>";
        }
        String cert = null;
        if (rawData != null) {
            String base64Data = Utils.base64encode((byte[])rawData, (boolean)true).trim();
            cert = base64Data.replace("\r", "").replace("\n", "");
        }
        if (cert == null) {
            return "<null>";
        }
        return (cert = cert.trim()).equals("") ? "<null>" : cert;
    }

    static String auditInfoValue(Request request) {
        String info;
        String reason = "<null>";
        if (request != null && (info = request.getExtDataInString(SIGNED_AUDIT_CERT_REQUEST_REASON)) != null && (reason = info.trim()).equals("")) {
            reason = "<null>";
        }
        return reason;
    }
}

