/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.security.JssSubsystem;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;

public class EnableEnrollResult
extends CMSServlet {
    private static final long serialVersionUID = -2646998784859783012L;
    private static final String TPL_FILE = "enableEnrollResult.template";
    private String mFormPath = null;
    private SecureRandom random = null;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/" + this.mAuthority.getId() + "/enableEnrollResult.template";
        this.mTemplates.remove(CMSRequest.SUCCESS);
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        this.random = jssSubsystem.getRandomNumberGenerator();
    }

    @Override
    protected CMSRequest newCMSRequest() {
        return new CMSRequest();
    }

    @Override
    protected void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "enable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        X509Certificate sslClientCert = null;
        sslClientCert = this.getSSLClientCertificate(httpReq);
        String dn = sslClientCert.getSubjectDN().toString();
        ArgBlock args = cmsReq.getHttpParams();
        logger.error(CMS.getLogMessage("CMSGW_CA_FROM_RA_NOT_IMP", new Object[0]));
        cmsReq.setError(new ECMSGWException(CMS.getUserMessage("CMS_GW_NOT_YET_IMPLEMENTED", new String[0])));
        cmsReq.setStatus(CMSRequest.ERROR);
    }
}

