/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.netscape.certsrv.account.AccountClient;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.client.ClientConfig;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.system.InstallToken;
import com.netscape.certsrv.system.SecurityDomainClient;
import com.netscape.cms.servlet.csadmin.ConfigCertApprovalCallback;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.apps.ServerConfig;
import java.util.StringTokenizer;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configurator {
    public static final Logger logger = LoggerFactory.getLogger(Configurator.class);
    public static ConfigCertApprovalCallback certApprovalCallback = new ConfigCertApprovalCallback();
    protected CMSEngine engine;
    protected EngineConfig cs;
    protected ServerConfig serverConfig;

    public Configurator(CMSEngine engine) {
        this.engine = engine;
        this.cs = engine.getConfig();
        this.serverConfig = engine.getServerConfig();
    }

    public static PKIClient createClient(String serverURL, String clientnickname, SSLCertificateApprovalCallback certApprovalCallback) throws Exception {
        ClientConfig config = new ClientConfig();
        config.setServerURL(serverURL);
        config.setCertNickname(clientnickname);
        if (certApprovalCallback == null) {
            certApprovalCallback = Configurator.certApprovalCallback;
        }
        return new PKIClient(config, null, certApprovalCallback);
    }

    public void setConfigStore(EngineConfig cs) {
        this.cs = cs;
    }

    public void setServerConfig(ServerConfig serverConfig) throws Exception {
        this.serverConfig = serverConfig;
    }

    public String getInstallToken(String sdhost, int sdport, String user, String passwd) throws Exception {
        String csType = this.cs.getType();
        ClientConfig config = new ClientConfig();
        config.setServerURL("https://" + sdhost + ":" + sdport);
        config.setUsername(user);
        config.setPassword(passwd);
        PKIClient client = new PKIClient(config);
        client.addIgnoredCertStatus(Integer.valueOf(-8172));
        client.addIgnoredCertStatus(Integer.valueOf(-8156));
        AccountClient accountClient = new AccountClient(client, "ca", "rest");
        SecurityDomainClient sdClient = new SecurityDomainClient(client, "ca");
        try {
            logger.info("Logging into security domain");
            accountClient.login();
            logger.info("Getting install token");
            InstallToken token = sdClient.getInstallToken(sdhost, csType);
            logger.info("Logging out of security domain");
            accountClient.logout();
            return token.getToken();
        }
        catch (PKIException e) {
            if (e.getCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                logger.warn("Getting old cookie");
                String tokenString = this.getOldCookie(sdhost, sdport, user, passwd);
                logger.debug("Token: " + tokenString);
                return tokenString;
            }
            throw e;
        }
    }

    public String getOldCookie(String sdhost, int sdport, String user, String passwd) throws Exception {
        String subca_url = "https://" + this.cs.getHostname() + ":" + this.engine.getAdminPort() + "/ca/admin/console/config/wizard?p=5&subsystem=" + this.cs.getType();
        MultivaluedHashMap content = new MultivaluedHashMap();
        content.putSingle((Object)"uid", (Object)user);
        content.putSingle((Object)"pwd", (Object)passwd);
        content.putSingle((Object)"url", (Object)subca_url);
        String serverURL = "https://" + sdhost + ":" + sdport;
        PKIClient client = Configurator.createClient(serverURL, null, null);
        String response = (String)client.post("ca/admin/ca/getCookie", (MultivaluedMap)content, String.class);
        logger.debug("Configurator: Response: " + response);
        return this.getContentValue(response, "header.session_id");
    }

    public String getContentValue(String body, String header) {
        logger.debug("Configurator: searching for " + header);
        StringTokenizer st = new StringTokenizer(body, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int eqPos = line.indexOf(61);
            if (eqPos == -1) continue;
            String name = line.substring(0, eqPos).trim();
            String tempval = line.substring(eqPos + 1).trim();
            String value = tempval.replaceAll("(^\")|(\";$)", "");
            if (!name.equals(header)) continue;
            return value;
        }
        return null;
    }
}

