/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.apps;

import com.netscape.certsrv.base.SessionContext;
import java.io.File;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CMS {
    public static Logger logger = LoggerFactory.getLogger(CMS.class);
    private static final String PRODUCT_NAME_FILE = "/usr/share/pki/CS_SERVER_VERSION";
    public static final int DEBUG_OBNOXIOUS = 1;
    public static final int DEBUG_VERBOSE = 5;
    public static final int DEBUG_INFORM = 10;
    public static final String CONFIG_FILE = "CS.cfg";
    public static final int PRE_OP_MODE = 0;
    public static final int RUNNING_MODE = 1;

    public static String getProductName() throws Exception {
        File file = new File(PRODUCT_NAME_FILE);
        if (!file.exists()) {
            return null;
        }
        return new String(Files.readAllBytes(file.toPath())).trim();
    }

    public static String getProductVersion() {
        return System.getenv("PKI_VERSION");
    }

    public static String getInstanceDir() {
        return System.getProperty("catalina.base");
    }

    public static String getUserMessage(String msgID, String ... params) {
        return CMS.getUserMessage(null, msgID, params);
    }

    public static String getUserMessage(Locale locale, String msgID, String ... params) {
        SessionContext sc;
        if (locale == null && (sc = SessionContext.getExistingContext()) != null) {
            locale = (Locale)sc.get((Object)"locale");
        }
        ResourceBundle rb = null;
        rb = locale == null ? ResourceBundle.getBundle("UserMessages", Locale.ENGLISH) : ResourceBundle.getBundle("UserMessages", locale);
        String msg = rb.getString(msgID);
        if (params == null) {
            return msg;
        }
        MessageFormat mf = new MessageFormat(msg);
        return mf.format(params);
    }

    public static String getLogMessage(String msgID, Object ... params) {
        String bundleName = msgID.startsWith("LOGGING_SIGNED_AUDIT_") ? "audit-events" : "LogMessages";
        ResourceBundle rb = ResourceBundle.getBundle(bundleName);
        String msg = rb.getString(msgID);
        if (params == null) {
            return msg;
        }
        MessageFormat mf = new MessageFormat(msg);
        Object[] escapedParams = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            escapedParams[i] = param instanceof String ? CMS.escapeLogMessageParam((String)param) : param;
        }
        return mf.format(escapedParams);
    }

    private static String escapeLogMessageParam(String s) {
        if (s == null) {
            return null;
        }
        if (s.contains("{") || s.contains("}")) {
            return "'" + s.replaceAll("'", "''") + "'";
        }
        return s;
    }

    public static boolean isSensitive(String name) {
        return name.startsWith("__") || name.endsWith("password") || name.endsWith("passwd") || name.endsWith("pwd") || name.equalsIgnoreCase("admin_password_again") || name.equalsIgnoreCase("directoryManagerPwd") || name.equalsIgnoreCase("bindpassword") || name.equalsIgnoreCase("bindpwd") || name.equalsIgnoreCase("passwd") || name.equalsIgnoreCase("password") || name.equalsIgnoreCase("pin") || name.equalsIgnoreCase("pwd") || name.equalsIgnoreCase("pwdagain") || name.equalsIgnoreCase("uPasswd") || name.equalsIgnoreCase("PASSWORD_CACHE_ADD") || name.startsWith("p12Password") || name.startsWith("serverSideKeygenP12Passwd") || name.equalsIgnoreCase("host_challenge") || name.equalsIgnoreCase("card_challenge") || name.equalsIgnoreCase("card_cryptogram") || name.equalsIgnoreCase("drm_trans_desKey") || name.equalsIgnoreCase("cert_request");
    }
}

