/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.extensions.CMSExtension;
import com.netscape.certsrv.extensions.EExtensionsException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;

public class CMSExtensionsMap {
    public static String ID = "extensions";
    private static final String PROP_CLASS = "class";
    private Hashtable<String, CMSExtension> mName2Ext = new Hashtable();
    private Hashtable<String, CMSExtension> mOID2Ext = new Hashtable();
    private ConfigStore mConfig;

    public void init(ConfigStore config) throws EBaseException {
        this.mConfig = config;
        Enumeration<String> sstores = this.mConfig.getSubStoreNames().elements();
        while (sstores.hasMoreElements()) {
            String name = sstores.nextElement();
            ConfigStore c = this.mConfig.getSubStore(name, ConfigStore.class);
            String className = c.getString(PROP_CLASS);
            CMSExtension ext = null;
            try {
                ext = (CMSExtension)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ext.init(c);
                this.addExt(ext);
            }
            catch (Exception e) {
                throw new EExtensionsException("CMSExtensionsMap: " + e.getMessage(), e);
            }
        }
    }

    public void addExt(CMSExtension ext) throws EBaseException {
        String name = ext.getName();
        ObjectIdentifier oid = ext.getOID();
        if (name == null || oid == null) {
            throw new EExtensionsException(CMS.getUserMessage("CMS_EXTENSION_INCORRECT_IMPL", ext.getClass().getName()));
        }
        this.mName2Ext.put(name, ext);
        this.mOID2Ext.put(oid.toString(), ext);
    }

    public void startup() throws EBaseException {
    }

    public void shutdown() {
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public String getId() {
        return ID;
    }

    public void setId(String Id) {
    }

    public CMSExtension getByName(String name) {
        return this.mName2Ext.get(name);
    }

    public CMSExtension getByOID(ObjectIdentifier oid) {
        return this.mOID2Ext.get(oid.toString());
    }
}

