/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.AgentApprovals;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IExpression;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.policy.IPolicyRule;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APolicyRule
implements IPolicyRule {
    public static Logger logger = LoggerFactory.getLogger(APolicyRule.class);
    protected String NAME = null;
    protected String DESC = null;
    protected IExpression mFilterExp = null;
    protected String mInstanceName = null;

    @Override
    public abstract void init(IPolicyProcessor var1, ConfigStore var2) throws EBaseException;

    @Override
    public String getDescription() {
        return this.DESC;
    }

    @Override
    public void setPredicate(IExpression exp) {
        this.mFilterExp = exp;
    }

    @Override
    public IExpression getPredicate() {
        return this.mFilterExp;
    }

    @Override
    public String getName() {
        return this.NAME;
    }

    @Override
    public void setInstanceName(String instanceName) {
        this.mInstanceName = instanceName;
    }

    @Override
    public String getInstanceName() {
        return this.mInstanceName != null ? this.mInstanceName : this.NAME;
    }

    @Override
    public abstract PolicyResult apply(Request var1);

    @Override
    public abstract Vector<String> getInstanceParams();

    @Override
    public abstract Vector<String> getDefaultParams();

    @Override
    public void setError(Request req, String format, Object[] params) {
        this.setPolicyException(req, format, params);
    }

    public void setError(Request req, String format, String arg1, String arg2) {
        Object[] np = new Object[]{arg1, arg2};
        this.setPolicyException(req, format, np);
    }

    public void setError(Request req, String format, String arg) {
        Object[] np = new Object[]{arg};
        this.setPolicyException(req, format, np);
    }

    @Override
    public void setPolicyException(Request req, EBaseException ex) {
        Vector<String> ev = req.getExtDataInStringVector("errors");
        if (ev == null) {
            ev = new Vector();
        }
        ev.addElement(ex.toString());
        req.setExtData("errors", ev);
    }

    protected PolicyResult deferred(Request req) {
        AgentApprovals aa = AgentApprovals.fromStringVector(req.getExtDataInStringVector(AgentApprovals.class.getName()));
        return aa != null && aa.elements().hasMoreElements() ? PolicyResult.ACCEPTED : PolicyResult.DEFERRED;
    }

    protected boolean agentApproved(Request req) {
        AgentApprovals aa = AgentApprovals.fromStringVector(req.getExtDataInStringVector(AgentApprovals.class.getName()));
        return aa != null && aa.elements().hasMoreElements();
    }

    public void setPolicyException(Request req, String format, Object[] params) {
        if (format == null) {
            return;
        }
        EPolicyException ex = params == null ? new EPolicyException(format) : new EPolicyException(format, params);
        Vector<String> ev = req.getExtDataInStringVector("errors");
        if (ev == null) {
            ev = new Vector();
        }
        ev.addElement(ex.toString());
        req.setExtData("errors", ev);
    }

    public static KeyIdentifier createKeyIdentifier(X509Key key) throws NoSuchAlgorithmException, InvalidKeyException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(key.getEncoded());
        return new KeyIdentifier(md.digest());
    }

    protected KeyIdentifier formSpkiSHA1KeyId(X509CertInfo certInfo) throws EBaseException {
        KeyIdentifier keyId = null;
        try {
            CertificateX509Key certKey = (CertificateX509Key)certInfo.get("key");
            if (certKey == null) {
                logger.error(CMS.getLogMessage("POLICY_MISSING_KEY_1", ""));
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_MISSING_KEY", this.NAME));
            }
            X509Key key = (X509Key)certKey.get("value");
            if (key == null) {
                logger.error(CMS.getLogMessage("POLICY_MISSING_KEY_1", ""));
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_MISSING_KEY", this.NAME));
            }
            keyId = APolicyRule.createKeyIdentifier(key);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("POLICY_ERROR_SUBJECT_KEY_ID_1", this.NAME), (Throwable)e);
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_SUBJECT_KEY_ID_ERROR", this.NAME), e);
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage("POLICY_ERROR_SUBJECT_KEY_ID_1", this.NAME), (Throwable)e);
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_SUBJECT_KEY_ID_ERROR", this.NAME), e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(CMS.getLogMessage("POLICY_ERROR_SUBJECT_KEY_ID_1", this.NAME), (Throwable)e);
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_SUBJECT_KEY_ID_ERROR", this.NAME), e);
        }
        catch (InvalidKeyException e) {
            logger.error(CMS.getLogMessage("POLICY_ERROR_SUBJECT_KEY_ID_1", this.NAME), (Throwable)e);
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_SUBJECT_KEY_ID_ERROR", this.NAME), e);
        }
        return keyId;
    }

    protected KeyIdentifier formSHA1KeyId(X509CertInfo certInfo) throws EBaseException {
        KeyIdentifier keyId = null;
        try {
            CertificateX509Key certKey = (CertificateX509Key)certInfo.get("key");
            if (certKey == null) {
                logger.error(CMS.getLogMessage("POLICY_MISSING_KEY_1", ""));
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_MISSING_KEY", this.NAME));
            }
            X509Key key = (X509Key)certKey.get("value");
            if (key == null) {
                logger.error(CMS.getLogMessage("POLICY_MISSING_KEY_1", ""));
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_MISSING_KEY", this.NAME));
            }
            byte[] rawKey = key.getKey();
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(rawKey);
            keyId = new KeyIdentifier(md.digest());
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("POLICY_ERROR_SUBJECT_KEY_ID_1", this.NAME), (Throwable)e);
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_SUBJECT_KEY_ID_ERROR", this.NAME), e);
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage("POLICY_ERROR_SUBJECT_KEY_ID_1", this.NAME), (Throwable)e);
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_SUBJECT_KEY_ID_ERROR", this.NAME), e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(CMS.getLogMessage("POLICY_ERROR_SUBJECT_KEY_ID_1", this.NAME), (Throwable)e);
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_SUBJECT_KEY_ID_ERROR", this.NAME), e);
        }
        return keyId;
    }
}

