/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps;

import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.tps.token.TokenStatus;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.base.FileConfigStorage;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.tps.TPSConfig;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.dogtagpki.server.tps.TokenDB;
import org.dogtagpki.server.tps.TokenDBConfig;
import org.dogtagpki.server.tps.authentication.AuthenticationManager;
import org.dogtagpki.server.tps.cms.ConnectionManager;
import org.dogtagpki.server.tps.config.AuthenticatorDatabase;
import org.dogtagpki.server.tps.config.ConfigDatabase;
import org.dogtagpki.server.tps.config.ConnectorDatabase;
import org.dogtagpki.server.tps.config.ProfileDatabase;
import org.dogtagpki.server.tps.config.ProfileMappingDatabase;
import org.dogtagpki.server.tps.dbs.ActivityDatabase;
import org.dogtagpki.server.tps.dbs.TPSCertDatabase;
import org.dogtagpki.server.tps.dbs.TPSCertRecord;
import org.dogtagpki.server.tps.dbs.TokenDatabase;
import org.dogtagpki.server.tps.dbs.TokenRecord;
import org.dogtagpki.server.tps.mapping.MappingResolverManager;
import org.dogtagpki.tps.TPSConnection;
import org.dogtagpki.tps.main.TPSException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSSubsystem
extends Subsystem
implements IAuthority {
    public static Logger logger = LoggerFactory.getLogger(TPSSubsystem.class);
    public static final String ID = "tps";
    public String id;
    public String nickname;
    public Subsystem owner;
    public TPSConfig config;
    public ActivityDatabase activityDatabase;
    public AuthenticatorDatabase authenticatorDatabase;
    public TPSCertDatabase certDatabase;
    public ConfigDatabase configDatabase;
    public ConnectorDatabase connectorDatabase;
    public ProfileDatabase profileDatabase;
    public ProfileMappingDatabase profileMappingDatabase;
    public TokenDatabase tokenDatabase;
    public ConnectionManager connManager;
    public AuthenticationManager authManager;
    public MappingResolverManager mappingResolverManager;
    public TokenDB tdb;
    public Map<TokenStatus, Collection<TokenStatus>> uiTransitions;
    public Map<TokenStatus, Collection<TokenStatus>> operationTransitions;

    public String getId() {
        return this.id;
    }

    public void setId(String id) throws EBaseException {
        this.id = id;
    }

    public void init(ConfigStore config) throws Exception {
        ConfigStore defaultConfig;
        logger.info("Initializing TPS subsystem");
        TPSEngine tpsEngine = (TPSEngine)this.engine;
        TPSEngineConfig cs = tpsEngine.getConfig();
        this.config = cs.getTPSConfig();
        DBSubsystem dbSubsystem = this.engine.getDBSubsystem();
        TokenDBConfig tdbConfig = cs.getTokenDBConfig();
        String activityDatabaseDN = tdbConfig.getString("activityBaseDN");
        this.activityDatabase = new ActivityDatabase(dbSubsystem, activityDatabaseDN);
        String certDatabaseDN = tdbConfig.getString("certBaseDN");
        this.certDatabase = new TPSCertDatabase(dbSubsystem, certDatabaseDN);
        String tokenDatabaseDN = tdbConfig.getString("baseDN");
        this.tokenDatabase = new TokenDatabase(dbSubsystem, tokenDatabaseDN);
        this.configDatabase = new ConfigDatabase();
        this.authenticatorDatabase = new AuthenticatorDatabase();
        this.authenticatorDatabase.setEngineConfig(cs);
        this.connectorDatabase = new ConnectorDatabase();
        this.connectorDatabase.setEngineConfig(cs);
        this.profileDatabase = new ProfileDatabase();
        this.profileDatabase.setEngineConfig(cs);
        this.profileMappingDatabase = new ProfileMappingDatabase();
        this.profileMappingDatabase.setEngineConfig(cs);
        try {
            FileConfigStorage storage = new FileConfigStorage("/usr/share/pki/tps/conf/CS.cfg");
            defaultConfig = new ConfigStore((ConfigStorage)storage);
            defaultConfig.load();
        }
        catch (Exception e) {
            throw new EBaseException("Unable to load default TPS configuration: " + e.getMessage(), (Throwable)e);
        }
        String allowedTransitions = tdbConfig.getString("allowedTransitions");
        this.uiTransitions = this.loadTokenStateTransitions("tokendb.allowedTransitions", allowedTransitions);
        this.operationTransitions = this.loadAndValidateTokenStateTransitions(defaultConfig, (ConfigStore)cs, "tps.operations.allowedTransitions");
        this.configureTPSConnection((ConfigStore)cs);
        this.tdb = new TokenDB(this);
    }

    public Map<TokenStatus, Collection<TokenStatus>> loadTokenStateTransitions(String property, String value) throws EBaseException {
        if (StringUtils.isEmpty((CharSequence)value)) {
            logger.error("Missing token state transitions in " + property);
            throw new EBaseException("Missing token state transition in " + property);
        }
        HashMap<TokenStatus, Collection<TokenStatus>> transitions = new HashMap<TokenStatus, Collection<TokenStatus>>();
        for (TokenStatus state : TokenStatus.values()) {
            transitions.put(state, new LinkedHashSet());
        }
        for (String transition : value.split(",")) {
            String[] states = transition.split(":");
            if (states.length < 2) {
                logger.error("Invalid token state transition in " + property + ": " + transition);
                throw new EBaseException("Invalid token state transition in " + property + ": " + transition);
            }
            TokenStatus currentState = TokenStatus.fromInt((Integer)Integer.valueOf(states[0]));
            TokenStatus nextState = TokenStatus.fromInt((Integer)Integer.valueOf(states[1]));
            if (!currentState.isValid() || !nextState.isValid()) {
                logger.debug("Invalid token state transition in " + property + ": " + transition);
                throw new EBaseException("Invalid token state transition in " + property + ": " + transition);
            }
            String info = currentState + " to " + nextState + " (" + currentState.getValue() + ":" + nextState.getValue() + ")";
            logger.debug("TokenSubsystem:   - " + info);
            Collection nextStates = (Collection)transitions.get(currentState);
            nextStates.add(nextState);
        }
        return transitions;
    }

    public void validateTokenStateTransitions(Map<TokenStatus, Collection<TokenStatus>> defaultConfig, Map<TokenStatus, Collection<TokenStatus>> userConfig) throws EBaseException {
        for (TokenStatus currentState : userConfig.keySet()) {
            Collection<TokenStatus> nextStates = userConfig.get(currentState);
            Collection<TokenStatus> defaultNextStates = defaultConfig.get(currentState);
            for (TokenStatus nextState : nextStates) {
                if (defaultNextStates.contains(nextState)) continue;
                String info = currentState + " to " + nextState + " (" + currentState.getValue() + ":" + nextState.getValue() + ")";
                throw new EBaseException("Unsupported token state transition: " + info);
            }
        }
    }

    public Map<TokenStatus, Collection<TokenStatus>> loadAndValidateTokenStateTransitions(ConfigStore defaultConfig, ConfigStore userDefinedConfig, String property) throws EBaseException {
        logger.debug("TokenSubsystem: Loading transitions in " + property);
        logger.debug("TokenSubsystem: * default transitions:");
        String defaultTransitionsStr = defaultConfig.getString(property);
        Map<TokenStatus, Collection<TokenStatus>> defaultTransitions = this.loadTokenStateTransitions(property, defaultTransitionsStr);
        logger.debug("TokenSubsystem: * user-defined transitions:");
        String userDefinedTransitionsStr = userDefinedConfig.getString(property);
        Map<TokenStatus, Collection<TokenStatus>> userDefinedTransitions = this.loadTokenStateTransitions(property, userDefinedTransitionsStr);
        logger.debug("TokenSubsystem: Validating transitions in " + property);
        this.validateTokenStateTransitions(defaultTransitions, userDefinedTransitions);
        return userDefinedTransitions;
    }

    public Collection<TokenStatus> getUINextTokenStates(TokenRecord tokenRecord) throws TPSException {
        TokenStatus currentState = tokenRecord.getTokenStatus();
        Collection<TokenStatus> nextStates = this.uiTransitions.get(currentState);
        if (currentState == TokenStatus.SUSPENDED) {
            LinkedHashSet<TokenStatus> ns = new LinkedHashSet<TokenStatus>();
            Collection<TPSCertRecord> certRecords = this.tdb.tdbGetCertRecordsByCUID(tokenRecord.getId());
            if (certRecords.isEmpty()) {
                ns.add(TokenStatus.FORMATTED);
            } else {
                ns.add(TokenStatus.ACTIVE);
            }
            ns.addAll(nextStates);
            return ns;
        }
        return nextStates;
    }

    public Collection<TokenStatus> getOperationNextTokenStates(TokenRecord tokenRecord) {
        TokenStatus currentState = tokenRecord.getTokenStatus();
        return this.operationTransitions.get(currentState);
    }

    public void configureTPSConnection(ConfigStore cs) {
        String configValue = "tps.connection.maxMessageSize";
        int configValueDefault = 9999;
        logger.debug("TPSConnection: Retrieving config value with name: " + configValue);
        try {
            TPSConnection.setMaxMessageSize((int)cs.getInteger(configValue));
            logger.debug("TPSConnection: maxMessageSize set to " + TPSConnection.getMaxMessageSize());
        }
        catch (EBaseException e) {
            TPSConnection.setMaxMessageSize((int)configValueDefault);
            logger.debug("TPSConnection: Could not find given config line. Defaulting to value: " + configValueDefault);
        }
    }

    public void startup() throws EBaseException {
        logger.debug("TPSSubsystem: startup() begins");
        this.connManager = new ConnectionManager();
        this.connManager.initConnectors();
        this.authManager = new AuthenticationManager();
        this.authManager.initAuthInstances();
        this.mappingResolverManager = new MappingResolverManager();
        this.mappingResolverManager.initMappingResolverInstances();
        logger.debug("TPSSubsystem: startup() ends.");
    }

    public void shutdown() {
    }

    public TPSConfig getConfigStore() {
        return this.config;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getOfficialName() {
        return ID;
    }

    public ActivityDatabase getActivityDatabase() {
        return this.activityDatabase;
    }

    public AuthenticatorDatabase getAuthenticatorDatabase() {
        return this.authenticatorDatabase;
    }

    public TPSCertDatabase getCertDatabase() {
        return this.certDatabase;
    }

    public ConfigDatabase getConfigDatabase() {
        return this.configDatabase;
    }

    public ConnectorDatabase getConnectorDatabase() {
        return this.connectorDatabase;
    }

    public ProfileDatabase getProfileDatabase() {
        return this.profileDatabase;
    }

    public ProfileMappingDatabase getProfileMappingDatabase() {
        return this.profileMappingDatabase;
    }

    public TokenDatabase getTokenDatabase() {
        return this.tokenDatabase;
    }

    public ConnectionManager getConnectionManager() {
        return this.connManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authManager;
    }

    public MappingResolverManager getMappingResolverManager() {
        return this.mappingResolverManager;
    }

    public TokenDB getTokendb() {
        return this.tdb;
    }

    public X509Certificate getSubsystemCert() throws EBaseException, NotInitializedException, ObjectNotFoundException, TokenException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig cs = engine.getConfig();
        Object nickname = cs.getString("tps.subsystem.nickname", "");
        String tokenname = cs.getString("tps.subsystem.tokenname", "");
        if (!CryptoUtil.isInternalToken((String)tokenname)) {
            nickname = tokenname + ":" + (String)nickname;
        }
        CryptoManager cm = CryptoManager.getInstance();
        return cm.findCertByNickname((String)nickname);
    }

    public boolean isUITransitionAllowed(TokenRecord tokenRecord, TokenStatus nextState) throws Exception {
        Collection<TokenStatus> nextStates = this.getUINextTokenStates(tokenRecord);
        return nextStates.contains(nextState);
    }

    public boolean isOperationTransitionAllowed(TokenRecord tokenRecord, TokenStatus nextState) {
        Collection<TokenStatus> nextStates = this.getOperationNextTokenStates(tokenRecord);
        return nextStates.contains(nextState);
    }
}

