/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.key;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.authorization.EAuthzException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.key.KeyRecordParser;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.kra.KeyRecoveryAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;

public class DisplayBySerialForRecovery
extends CMSServlet {
    private static final long serialVersionUID = 6876016034084761827L;
    private static final String INFO = "displayBySerial";
    private static final String TPL_FILE = "displayBySerialForRecovery.template";
    private static final String IN_SERIALNO = "serialNumber";
    private static final String OUT_OP = "op";
    private static final String OUT_SERVICE_URL = "serviceURL";
    private static final String OUT_ERROR = "errorDetails";
    private KeyRepository mKeyDB;
    private String mFormPath = null;
    private KeyRecoveryAuthority mService;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/agent/kra/displayBySerialForRecovery.template";
        KRAEngine engine = KRAEngine.getInstance();
        KeyRecoveryAuthority kra = engine.getKRA();
        this.mKeyDB = kra.getKeyRepository();
        this.mService = kra;
        this.mTemplates.remove(CMSRequest.SUCCESS);
    }

    public String getServletInfo() {
        return INFO;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        BigInteger seqNum = BigInteger.ZERO;
        try {
            if (req.getParameter(IN_SERIALNO) != null) {
                seqNum = new BigInteger(req.getParameter(IN_SERIALNO));
            }
            this.process(header, req.getParameter("publicKeyData"), seqNum, req, locale[0], authToken);
        }
        catch (EAuthzException e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        catch (NumberFormatException e) {
            header.addStringValue(OUT_ERROR, CMS.getUserMessage((Locale)locale[0], (String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
        }
        catch (Exception e) {
            logger.warn("DisplayBySerialForRecovery: " + e.getMessage(), (Throwable)e);
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            resp.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
    }

    private synchronized void process(ArgBlock header, String publicKeyData, BigInteger seq, HttpServletRequest req, Locale locale, AuthToken authToken) throws EAuthzException {
        KRAEngine engine = KRAEngine.getInstance();
        KRAEngineConfig cs = engine.getConfig();
        try {
            header.addIntegerValue("noOfRequiredAgents", this.mService.getNoOfRequiredAgents());
            header.addStringValue(OUT_OP, req.getParameter(OUT_OP));
            header.addStringValue("keySplitting", cs.getString("kra.keySplitting"));
            header.addStringValue(OUT_SERVICE_URL, req.getRequestURI());
            if (publicKeyData != null) {
                header.addStringValue("publicKeyData", publicKeyData);
            }
            KeyRecord rec = this.mKeyDB.readKeyRecord(seq);
            this.mAuthz.checkRealm(rec.getRealm(), authToken, rec.getOwnerName(), this.mAuthzResourceName, "read");
            KeyRecordParser.fillRecordIntoArg((KeyRecord)rec, (ArgBlock)header);
            header.addStringValue("recoveryID", this.mService.getRecoveryID());
        }
        catch (EAuthzException e) {
            throw e;
        }
        catch (EBaseException e) {
            header.addStringValue(OUT_ERROR, e.toString(locale));
        }
    }
}

