/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.key;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.kra.KeyRecoveryAuthority;
import com.netscape.kra.TransportKeyUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;

@WebServlet(name="kraKRADisplayTransport", urlPatterns={"/agent/kra/displayTransportCert"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="kra"), @WebInitParam(name="ID", value="kraKRADisplayTransport"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.kra.certificate.transport")})
public class DisplayTransport
extends CMSServlet {
    private static final long serialVersionUID = -6509083753395783705L;
    private static final String INFO = "displayTransport";

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mTemplates.remove(CMSRequest.SUCCESS);
    }

    public String getServletInfo() {
        return INFO;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        try {
            KRAEngine engine = KRAEngine.getInstance();
            KeyRecoveryAuthority kra = engine.getKRA();
            TransportKeyUnit tu = kra.getTransportKeyUnit();
            X509Certificate transportCert = tu.getCertificate();
            resp.setStatus(200);
            resp.setContentType("text/html");
            Object content = "";
            content = (String)content + "<HTML><PRE>";
            String mime64 = "-----BEGIN CERTIFICATE-----\n" + Utils.base64encode((byte[])transportCert.getEncoded(), (boolean)true) + "-----END CERTIFICATE-----\n";
            content = (String)content + mime64;
            content = (String)content + "</PRE></HTML>";
            resp.setContentType("text/html");
            resp.getOutputStream().write(((String)content).getBytes());
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), e);
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
    }
}

