/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.request;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.key.KeyRecordParser;
import com.netscape.cms.servlet.request.ReqParser;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.request.Request;
import com.netscape.kra.KeyRecoveryAuthority;
import java.math.BigInteger;
import java.util.Locale;
import org.dogtagpki.server.kra.KRAEngine;

public class KeyReqParser
extends ReqParser {
    public static final KeyReqParser PARSER = new KeyReqParser();
    public static final String OUTPUT_SERIALNO = "serialNumber";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fillRequestIntoArg(Locale l, Request req, CMSTemplateParams argSet, ArgBlock arg) throws EBaseException {
        super.fillRequestIntoArg(l, req, argSet, arg);
        String type = req.getRequestType();
        KRAEngine engine = KRAEngine.getInstance();
        if (type.equals("enrollment")) {
            BigInteger recSerialNo = req.getExtDataInBigInteger("keyRecord");
            KeyRecoveryAuthority kra = (KeyRecoveryAuthority)engine.getSubsystem("kra");
            if (kra == null) throw new EBaseException("KRA is not available");
            KeyRecordParser.fillRecordIntoArg((KeyRecord)kra.getKeyRepository().readKeyRecord(recSerialNo), (ArgBlock)arg);
            return;
        } else if (type.equals("recovery")) {
            BigInteger kid = req.getExtDataInBigInteger(OUTPUT_SERIALNO);
            arg.addStringValue(OUTPUT_SERIALNO, kid.toString());
            String agents = req.getExtDataInString("approvingAgents");
            arg.addStringValue("approvingAgents", agents);
            return;
        } else {
            System.out.println("Bad Request " + type);
        }
    }
}

