/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.junit.jupiter.api.DynamicNode;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.EXPERIMENTAL, since="5.0")
public class DynamicContainer
extends DynamicNode {
    private final Stream<? extends DynamicNode> children;

    public static DynamicContainer dynamicContainer(String displayName, Iterable<? extends DynamicNode> dynamicNodes) {
        return new DynamicContainer(displayName, StreamSupport.stream(dynamicNodes.spliterator(), false));
    }

    public static DynamicContainer dynamicContainer(String displayName, Stream<? extends DynamicNode> dynamicNodes) {
        return new DynamicContainer(displayName, dynamicNodes);
    }

    private DynamicContainer(String displayName, Stream<? extends DynamicNode> children) {
        super(displayName);
        Preconditions.notNull(children, (String)"children must not be null");
        this.children = children;
    }

    public Stream<? extends DynamicNode> getChildren() {
        return this.children;
    }
}

