"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.closeMilestoneTask = void 0;
var tslib_1 = require("tslib");
var task_1 = require("./task");
var githubClient_1 = tslib_1.__importDefault(require("../utils/githubClient"));
var closeMilestoneTaskRunner = function (_a) {
    var milestone = _a.milestone, dryRun = _a.dryRun;
    return tslib_1.__awaiter(void 0, void 0, void 0, function () {
        var githubClient, cherryPickLabel, client, milestoneRes, milestoneState, totalIssues, issuesRes, comparativeStr, _b, _c, issue, resDelete, e_1_1, resClose;
        var e_1, _d;
        return tslib_1.__generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    githubClient = new githubClient_1.default({ required: true });
                    cherryPickLabel = 'cherry-pick needed';
                    client = githubClient.client;
                    if (!/^\d+$/.test(milestone)) {
                        console.log('Use milestone number not title, find number in milestone url');
                        return [2 /*return*/];
                    }
                    if (dryRun) {
                        console.log('dry run is enabled');
                    }
                    return [4 /*yield*/, client.get("/milestones/" + milestone, {})];
                case 1:
                    milestoneRes = _e.sent();
                    milestoneState = milestoneRes.data.state;
                    if (milestoneState === 'closed') {
                        console.log('milestone already closed. ✅');
                        return [2 /*return*/];
                    }
                    console.log('fetching issues/PRs of the milestone ⏬');
                    totalIssues = 0;
                    _e.label = 2;
                case 2:
                    if (!true) return [3 /*break*/, 12];
                    return [4 /*yield*/, client.get('/issues', {
                            params: {
                                state: 'closed',
                                labels: cherryPickLabel,
                                per_page: 100,
                                milestone: milestone,
                            },
                        })];
                case 3:
                    issuesRes = _e.sent();
                    if (issuesRes.data.length < 1) {
                        return [3 /*break*/, 12];
                    }
                    comparativeStr = totalIssues === 0 ? ' ' : ' more ';
                    console.log("found " + issuesRes.data.length + comparativeStr + "issues to remove the cherry-pick label from \uD83D\uDD0E");
                    totalIssues += issuesRes.data.length;
                    _e.label = 4;
                case 4:
                    _e.trys.push([4, 9, 10, 11]);
                    _b = (e_1 = void 0, tslib_1.__values(issuesRes.data)), _c = _b.next();
                    _e.label = 5;
                case 5:
                    if (!!_c.done) return [3 /*break*/, 8];
                    issue = _c.value;
                    // the reason for using stdout.write is for achieving 'action -> result' on
                    // the same line
                    process.stdout.write("\uD83D\uDD27removing label from issue #" + issue.number + " \uD83D\uDDD1...");
                    if (!!dryRun) return [3 /*break*/, 7];
                    return [4 /*yield*/, client.delete("/issues/" + issue.number + "/labels/" + cherryPickLabel, {})];
                case 6:
                    resDelete = _e.sent();
                    if (resDelete.status === 200) {
                        process.stdout.write('done ✅\n');
                    }
                    else {
                        console.log('failed ❌');
                    }
                    _e.label = 7;
                case 7:
                    _c = _b.next();
                    return [3 /*break*/, 5];
                case 8: return [3 /*break*/, 11];
                case 9:
                    e_1_1 = _e.sent();
                    e_1 = { error: e_1_1 };
                    return [3 /*break*/, 11];
                case 10:
                    try {
                        if (_c && !_c.done && (_d = _b.return)) _d.call(_b);
                    }
                    finally { if (e_1) throw e_1.error; }
                    return [7 /*endfinally*/];
                case 11: return [3 /*break*/, 2];
                case 12:
                    if (totalIssues === 0) {
                        console.log('no issues to remove label from');
                    }
                    else {
                        console.log("cleaned up " + totalIssues + " issues/prs \u26A1\uFE0F");
                    }
                    if (!!dryRun) return [3 /*break*/, 14];
                    return [4 /*yield*/, client.patch("/milestones/" + milestone, {
                            state: 'closed',
                        })];
                case 13:
                    resClose = _e.sent();
                    if (resClose.status === 200) {
                        console.log('milestone closed 🙌');
                    }
                    else {
                        console.log('failed to close the milestone, response:');
                        console.log(resClose);
                    }
                    _e.label = 14;
                case 14: return [2 /*return*/];
            }
        });
    });
};
exports.closeMilestoneTask = new task_1.Task('Close Milestone generator task', closeMilestoneTaskRunner);
//# sourceMappingURL=closeMilestone.js.map