/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import org.mozilla.jss.netscape.security.extensions.AccessDescription;
import org.mozilla.jss.netscape.security.extensions.AuthInfoAccessExtension;
import org.mozilla.jss.netscape.security.extensions.CertificateScopeEntry;
import org.mozilla.jss.netscape.security.extensions.CertificateScopeOfUseExtension;
import org.mozilla.jss.netscape.security.extensions.ExtendedKeyUsageExtension;
import org.mozilla.jss.netscape.security.extensions.InhibitAnyPolicyExtension;
import org.mozilla.jss.netscape.security.extensions.NSCertTypeExtension;
import org.mozilla.jss.netscape.security.extensions.OCSPNoCheckExtension;
import org.mozilla.jss.netscape.security.extensions.PresenceServerExtension;
import org.mozilla.jss.netscape.security.extensions.SubjectInfoAccessExtension;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.util.PrettyPrintResources;
import org.mozilla.jss.netscape.security.x509.Attribute;
import org.mozilla.jss.netscape.security.x509.AuthorityKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.CPSuri;
import org.mozilla.jss.netscape.security.x509.CRLDistributionPoint;
import org.mozilla.jss.netscape.security.x509.CRLDistributionPointsExtension;
import org.mozilla.jss.netscape.security.x509.CRLNumberExtension;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.CertificateIssuerExtension;
import org.mozilla.jss.netscape.security.x509.CertificatePoliciesExtension;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyInfo;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyMap;
import org.mozilla.jss.netscape.security.x509.DeltaCRLIndicatorExtension;
import org.mozilla.jss.netscape.security.x509.DisplayText;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.FreshestCRLExtension;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.HoldInstructionExtension;
import org.mozilla.jss.netscape.security.x509.InvalidityDateExtension;
import org.mozilla.jss.netscape.security.x509.IssuerAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.IssuingDistributionPoint;
import org.mozilla.jss.netscape.security.x509.IssuingDistributionPointExtension;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.NSCCommentExtension;
import org.mozilla.jss.netscape.security.x509.NameConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.NoticeReference;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.PolicyConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.PolicyMappingsExtension;
import org.mozilla.jss.netscape.security.x509.PolicyQualifierInfo;
import org.mozilla.jss.netscape.security.x509.PolicyQualifiers;
import org.mozilla.jss.netscape.security.x509.PrivateKeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.Qualifier;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.SerialNumber;
import org.mozilla.jss.netscape.security.x509.SubjectAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.SubjectDirAttributesExtension;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.UserNotice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtPrettyPrint {
    private static final Logger logger = LoggerFactory.getLogger(ExtPrettyPrint.class);
    private Extension mExt = null;
    private ResourceBundle mResource = null;
    private PrettyPrintFormat pp = null;
    private int mIndentSize = 0;
    DateFormat dateFormater = null;

    public ExtPrettyPrint(Extension ext, int indentSize) {
        this.mExt = ext;
        this.mResource = ResourceBundle.getBundle(PrettyPrintResources.class.getName());
        this.mIndentSize = indentSize;
        this.pp = new PrettyPrintFormat(":");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.mExt instanceof KeyUsageExtension) {
            return this.getKeyUsage();
        }
        if (this.mExt instanceof NSCertTypeExtension) {
            return this.getCertType();
        }
        if (this.mExt instanceof AuthorityKeyIdentifierExtension) {
            return this.getAuthorityKeyIdentifier();
        }
        if (this.mExt instanceof SubjectKeyIdentifierExtension) {
            return this.getSubjectKeyIdentifier();
        }
        if (this.mExt instanceof CRLReasonExtension) {
            return this.getCRLReasonExtension();
        }
        if (this.mExt instanceof BasicConstraintsExtension) {
            return this.getBasicConstraintsExtension();
        }
        if (this.mExt instanceof NSCCommentExtension) {
            return this.getNSCCommentExtension();
        }
        if (this.mExt instanceof NameConstraintsExtension) {
            return this.getNameConstraintsExtension();
        }
        if (this.mExt instanceof CRLNumberExtension) {
            return this.getCRLNumberExtension();
        }
        if (this.mExt instanceof DeltaCRLIndicatorExtension) {
            return this.getDeltaCRLIndicatorExtension();
        }
        if (this.mExt instanceof IssuerAlternativeNameExtension) {
            return this.getIssuerAlternativeNameExtension();
        }
        if (this.mExt instanceof SubjectAlternativeNameExtension) {
            return this.getSubjectAlternativeNameExtension();
        }
        if (this.mExt instanceof FreshestCRLExtension) {
            return this.getFreshestCRLExtension();
        }
        if (this.mExt instanceof CRLDistributionPointsExtension) {
            return this.getCRLDistributionPointsExtension();
        }
        if (this.mExt instanceof IssuingDistributionPointExtension) {
            return this.getIssuingDistributionPointExtension();
        }
        if (this.mExt instanceof ExtendedKeyUsageExtension) {
            return this.getExtendedKeyUsageExtension();
        }
        if (this.mExt instanceof AuthInfoAccessExtension) {
            return this.getAuthInfoAccessExtension();
        }
        if (this.mExt instanceof SubjectInfoAccessExtension) {
            return this.getSubjectInfoAccessExtension();
        }
        if (this.mExt instanceof OCSPNoCheckExtension) {
            return this.getOCSPNoCheckExtension();
        }
        if (this.mExt instanceof PrivateKeyUsageExtension) {
            return this.getPrivateKeyUsageExtension();
        }
        if (this.mExt instanceof InvalidityDateExtension) {
            return this.getInvalidityDateExtension();
        }
        if (this.mExt instanceof CertificateIssuerExtension) {
            return this.getCertificateIssuerExtension();
        }
        if (this.mExt instanceof HoldInstructionExtension) {
            return this.getHoldInstructionExtension();
        }
        if (this.mExt instanceof PolicyConstraintsExtension) {
            return this.getPolicyConstraintsExtension();
        }
        if (this.mExt instanceof PolicyMappingsExtension) {
            return this.getPolicyMappingsExtension();
        }
        if (this.mExt instanceof SubjectDirAttributesExtension) {
            return this.getSubjectDirAttributesExtension();
        }
        if (this.mExt instanceof CertificateScopeOfUseExtension) {
            return this.getCertificateScopeOfUseExtension();
        }
        if (this.mExt instanceof PresenceServerExtension) {
            return this.getPresenceServerExtension();
        }
        if (this.mExt instanceof InhibitAnyPolicyExtension) {
            return this.getInhibitAnyPolicyExtension();
        }
        if (this.mExt instanceof CertificatePoliciesExtension) {
            return this.getCertificatePoliciesExtension();
        }
        String extName = OIDMap.getName(this.mExt.getExtensionId());
        if (extName == null) {
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier") + this.mExt.getExtensionId().toString() + "\n");
        } else {
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier") + " " + extName + " - " + this.mExt.getExtensionId().toString() + "\n");
        }
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenValue") + "\n");
        sb.append(this.pp.toHexString(this.mExt.getExtensionValue(), this.mIndentSize + 8, 16));
        return sb.toString();
    }

    private String getNSCCommentExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("tokenNSCComment") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        sb.append(this.pp.indent(this.mIndentSize + 4) + ((NSCCommentExtension)this.mExt).toPrint(this.mIndentSize) + "\n");
        return sb.toString();
    }

    private String getNameConstraintsExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("tokenNameConstraints") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        sb.append(this.pp.indent(this.mIndentSize + 4) + ((NameConstraintsExtension)this.mExt).toPrint(this.mIndentSize + 4));
        return sb.toString();
    }

    private String getOCSPNoCheckExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("tokenOcspNoCheck") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        return sb.toString();
    }

    private String getSubjectInfoAccessExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("tokenSIA") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenAccessDesc") + "\n");
        SubjectInfoAccessExtension aia = (SubjectInfoAccessExtension)this.mExt;
        for (int i = 0; i < aia.numberOfAccessDescription(); ++i) {
            AccessDescription ad = aia.getAccessDescription(i);
            ObjectIdentifier method = ad.getMethod();
            if (method.equals(SubjectInfoAccessExtension.METHOD_OCSP)) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + "Method #" + i + ": ocsp\n");
            } else {
                sb.append(this.pp.indent(this.mIndentSize + 8) + "Method #" + i + ": " + method.toString() + "\n");
            }
            sb.append(this.pp.indent(this.mIndentSize + 8) + "Location #" + i + ": " + ad.getLocation().toString() + "\n");
        }
        return sb.toString();
    }

    private String getAuthInfoAccessExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("tokenAIA") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenAccessDesc") + "\n");
        AuthInfoAccessExtension aia = (AuthInfoAccessExtension)this.mExt;
        for (int i = 0; i < aia.numberOfAccessDescription(); ++i) {
            AccessDescription ad = aia.getAccessDescription(i);
            ObjectIdentifier method = ad.getMethod();
            if (method.equals(AuthInfoAccessExtension.METHOD_OCSP)) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + "Method #" + i + ": ocsp\n");
            } else {
                sb.append(this.pp.indent(this.mIndentSize + 8) + "Method #" + i + ": " + method.toString() + "\n");
            }
            sb.append(this.pp.indent(this.mIndentSize + 8) + "Location #" + i + ": " + ad.getLocation().toString() + "\n");
        }
        return sb.toString();
    }

    private String getPresenceServerExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("tokenPresenceServer") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        PresenceServerExtension pse = (PresenceServerExtension)this.mExt;
        sb.append(this.pp.indent(this.mIndentSize + 4) + "Version : " + pse.getVersion() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + "Street Address : " + pse.getStreetAddress() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + "Telephone Number : " + pse.getTelephoneNumber() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + "RFC822 Name : " + pse.getRFC822() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + "ID : " + pse.getID() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + "Host Name : " + pse.getHostName() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + "Port Number : " + pse.getPortNumber() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + "Max Users : " + pse.getMaxUsers() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + "Service Level : " + pse.getServiceLevel() + "\n");
        return sb.toString();
    }

    private String getPrivateKeyUsageExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("tokenPrivateKeyUsage") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        PrivateKeyUsageExtension usage = (PrivateKeyUsageExtension)this.mExt;
        sb.append(this.pp.indent(this.mIndentSize + 4) + "Validity:\n");
        if (this.dateFormater == null) {
            this.dateFormater = DateFormat.getDateInstance(0);
        }
        String notBefore = this.dateFormater.format(usage.getNotBefore());
        String notAfter = this.dateFormater.format(usage.getNotAfter());
        sb.append(this.pp.indent(this.mIndentSize + 8) + "Not Before: " + notBefore + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 8) + "Not  After: " + notAfter + "\n");
        return sb.toString();
    }

    private String getExtendedKeyUsageExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("tokenExtendedKeyUsage") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenExtendedKeyUsage") + "\n");
        ExtendedKeyUsageExtension usage = (ExtendedKeyUsageExtension)this.mExt;
        Enumeration<ObjectIdentifier> e = usage.getOIDs();
        if (e != null) {
            while (e.hasMoreElements()) {
                ObjectIdentifier oid = e.nextElement();
                if (oid.equals(ExtendedKeyUsageExtension.OID_OCSP_SIGNING)) {
                    sb.append(this.pp.indent(this.mIndentSize + 8) + "OCSPSigning\n");
                    continue;
                }
                sb.append(this.pp.indent(this.mIndentSize + 8) + oid.toString() + "\n");
            }
        }
        return sb.toString();
    }

    private String getKeyUsage() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
            sb.append(this.mResource.getString("tokenKeyUsage") + "- " + this.mExt.getExtensionId().toString() + "\n");
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
            if (this.mExt.isCritical()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenKeyUsage") + "\n");
            KeyUsageExtension usage = (KeyUsageExtension)this.mExt;
            if (((Boolean)usage.get("digital_signature")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("digital_signature") + "\n");
            }
            if (((Boolean)usage.get("non_repudiation")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("non_repudiation") + "\n");
            }
            if (((Boolean)usage.get("key_encipherment")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("key_encipherment") + "\n");
            }
            if (((Boolean)usage.get("data_encipherment")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("data_encipherment") + "\n");
            }
            if (((Boolean)usage.get("key_agreement")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("key_agreement") + "\n");
            }
            if (((Boolean)usage.get("key_certsign")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("key_certsign") + "\n");
            }
            if (((Boolean)usage.get("crl_sign")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("crl_sign") + "\n");
            }
            if (((Boolean)usage.get("encipher_only")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("encipher_only") + "\n");
            }
            if (((Boolean)usage.get("decipher_only")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("decipher_only") + "\n");
            }
            return sb.toString();
        }
        catch (IOException e) {
            logger.debug("Problem getting key usage", (Throwable)e);
            return sb.toString();
        }
    }

    private String getCertType() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
            sb.append(this.mResource.getString("tokenCertType") + "- " + this.mExt.getExtensionId().toString() + "\n");
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
            if (this.mExt.isCritical()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCertUsage") + "\n");
            NSCertTypeExtension type = (NSCertTypeExtension)this.mExt;
            if (((Boolean)type.get("ssl_client")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("ssl_client") + "\n");
            }
            if (((Boolean)type.get("ssl_server")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("ssl_server") + "\n");
            }
            if (((Boolean)type.get("email")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("email") + "\n");
            }
            if (((Boolean)type.get("object_signing")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("object_signing") + "\n");
            }
            if (((Boolean)type.get("ssl_ca")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("ssl_ca") + "\n");
            }
            if (((Boolean)type.get("email_ca")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("email_ca") + "\n");
            }
            if (((Boolean)type.get("object_signing_ca")).booleanValue()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("object_signing_ca") + "\n");
            }
            return sb.toString();
        }
        catch (CertificateException e) {
            logger.debug("Problem getting certificate type", (Throwable)e);
            return "";
        }
    }

    private String getSubjectKeyIdentifier() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
            sb.append(this.mResource.getString("tokenSKI") + "- " + this.mExt.getExtensionId().toString() + "\n");
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
            if (this.mExt.isCritical()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            SubjectKeyIdentifierExtension id = (SubjectKeyIdentifierExtension)this.mExt;
            KeyIdentifier keyId = (KeyIdentifier)id.get("key_id");
            if (keyId != null) {
                sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenKeyId") + "\n");
                sb.append(this.pp.toHexString(keyId.getIdentifier(), 24, 16));
            }
            return sb.toString();
        }
        catch (IOException e) {
            logger.debug("Problem getting subject identifier", (Throwable)e);
            return "";
        }
    }

    private String getAuthorityKeyIdentifier() {
        StringBuffer sb = new StringBuffer();
        try {
            SerialNumber serial;
            GeneralNames authNames;
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
            sb.append(this.mResource.getString("tokenAKI") + "- " + this.mExt.getExtensionId().toString() + "\n");
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
            if (this.mExt.isCritical()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            AuthorityKeyIdentifierExtension id = (AuthorityKeyIdentifierExtension)this.mExt;
            KeyIdentifier keyId = (KeyIdentifier)id.get("key_id");
            if (keyId != null) {
                sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenKeyId") + "\n");
                sb.append(this.pp.toHexString(keyId.getIdentifier(), this.mIndentSize + 8, 16));
            }
            if ((authNames = (GeneralNames)id.get("auth_name")) != null) {
                for (int i = 0; i < authNames.size(); ++i) {
                    GeneralName authName = (GeneralName)authNames.elementAt(i);
                    if (authName == null) continue;
                    sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenAuthName") + authName.toString() + "\n");
                }
            }
            if ((serial = (SerialNumber)id.get("serial_number")) != null) {
                sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenSerial") + "0x" + serial.getNumber().toBigInteger().toString(16).toUpperCase() + "\n");
            }
            return sb.toString();
        }
        catch (IOException e) {
            logger.debug("Problem getting authority key identifier", (Throwable)e);
            return "";
        }
    }

    private String getCRLReasonExtension() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
            sb.append(this.mResource.getString("revocationReason") + "- " + this.mExt.getExtensionId().toString() + "\n");
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
            CRLReasonExtension ext = (CRLReasonExtension)this.mExt;
            if (this.mExt.isCritical()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("reason") + ext.getReason().toString() + "\n");
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private String getInhibitAnyPolicyExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("InhibitAnyPolicy") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        InhibitAnyPolicyExtension ext = (InhibitAnyPolicyExtension)this.mExt;
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("SkipCerts"));
        BigInt num = ext.getSkipCerts();
        sb.append(num.toInt() + "\n");
        return sb.toString();
    }

    private String getBasicConstraintsExtension() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
            sb.append(this.mResource.getString("basicConstraints") + "- " + this.mExt.getExtensionId().toString() + "\n");
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
            BasicConstraintsExtension ext = (BasicConstraintsExtension)this.mExt;
            if (this.mExt.isCritical()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("isCA"));
            boolean isCA = (Boolean)ext.get("is_ca");
            if (isCA) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            Integer pathLength = (Integer)ext.get("path_len");
            if (pathLength != null) {
                if (pathLength.longValue() >= 0L) {
                    sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("pathLen") + pathLength.toString() + "\n");
                } else if (pathLength.longValue() == -1L || pathLength.longValue() == -2L) {
                    sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("pathLen") + this.mResource.getString("pathLenUnlimited") + "\n");
                } else {
                    sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("pathLen") + this.mResource.getString("pathLenInvalid") + " (" + pathLength.toString() + ")\n");
                }
            }
            return sb.toString();
        }
        catch (IOException e) {
            logger.debug("Problem getting basic constraints", (Throwable)e);
            return "";
        }
    }

    private String getCRLNumberExtension() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
            sb.append(this.mResource.getString("CRLNumber") + "- " + this.mExt.getExtensionId().toString() + "\n");
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
            CRLNumberExtension ext = (CRLNumberExtension)this.mExt;
            if (this.mExt.isCritical()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            BigInteger crlNumber = (BigInteger)ext.get("value");
            if (crlNumber != null) {
                sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("Number") + crlNumber.toString() + "\n");
            }
            return sb.toString();
        }
        catch (IOException e) {
            logger.debug("Problem getting CRL number extensions", (Throwable)e);
            return "";
        }
    }

    private String getDeltaCRLIndicatorExtension() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
            sb.append(this.mResource.getString("DeltaCRLIndicator") + "- " + this.mExt.getExtensionId().toString() + "\n");
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
            DeltaCRLIndicatorExtension ext = (DeltaCRLIndicatorExtension)this.mExt;
            if (this.mExt.isCritical()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            BigInteger crlNumber = (BigInteger)ext.get("value");
            if (crlNumber != null) {
                sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("BaseCRLNumber") + crlNumber.toString() + "\n");
            }
            return sb.toString();
        }
        catch (IOException e) {
            logger.debug("Problem getting delta CRL extensions", (Throwable)e);
            return "";
        }
    }

    private String getIssuerAlternativeNameExtension() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
            sb.append(this.mResource.getString("IssuerAlternativeName") + "- " + this.mExt.getExtensionId().toString() + "\n");
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
            IssuerAlternativeNameExtension ext = (IssuerAlternativeNameExtension)this.mExt;
            if (this.mExt.isCritical()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            GeneralNames issuerNames = (GeneralNames)ext.get("issuer_name");
            if (issuerNames != null) {
                sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("IssuerNames") + "\n");
                for (int i = 0; i < issuerNames.size(); ++i) {
                    GeneralName issuerName = (GeneralName)issuerNames.elementAt(i);
                    if (issuerName == null) continue;
                    String nameType = "";
                    if (issuerName.getType() == 4) {
                        nameType = "DirectoryName: ";
                    }
                    sb.append(this.pp.indent(this.mIndentSize + 8) + nameType + issuerName.toString() + "\n");
                }
            }
            return sb.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    private String getSubjectAlternativeNameExtension() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
            sb.append(this.mResource.getString("SubjectAlternativeName") + "- " + this.mExt.getExtensionId().toString() + "\n");
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
            SubjectAlternativeNameExtension ext = (SubjectAlternativeNameExtension)this.mExt;
            if (this.mExt.isCritical()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            GeneralNames subjectNames = (GeneralNames)ext.get("subject_name");
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenValue") + "\n");
            for (int i = 0; i < subjectNames.size(); ++i) {
                GeneralName subjectName = (GeneralName)subjectNames.elementAt(i);
                if (subjectName == null) continue;
                String nameType = "";
                if (subjectName.getType() == 4) {
                    nameType = "DirectoryName: ";
                }
                sb.append(this.pp.indent(this.mIndentSize + 8) + nameType + subjectName.toString() + "\n");
            }
            return sb.toString();
        }
        catch (IOException e) {
            logger.debug("Problem getting subject alternative name", (Throwable)e);
            return "";
        }
    }

    private String getCertificateScopeOfUseExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("CertificateScopeOfUse") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        CertificateScopeOfUseExtension ext = (CertificateScopeOfUseExtension)this.mExt;
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        Vector<CertificateScopeEntry> entries = ext.getCertificateScopeEntries();
        if (entries != null) {
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("ScopeOfUse") + "\n");
            for (int i = 0; i < entries.size(); ++i) {
                BigInt port;
                CertificateScopeEntry se = entries.elementAt(i);
                GeneralName gn = se.getGeneralName();
                if (gn != null) {
                    String nameType = "";
                    if (gn.getType() == 4) {
                        nameType = "DirectoryName: ";
                    }
                    sb.append(this.pp.indent(this.mIndentSize + 8) + nameType + gn.toString() + "\n");
                }
                if ((port = se.getPort()) == null) continue;
                sb.append(this.pp.indent(this.mIndentSize + 8) + "Port" + port.toBigInteger().toString() + "\n");
            }
        }
        return sb.toString();
    }

    private String getFreshestCRLExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("FreshestCRL") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        FreshestCRLExtension ext = (FreshestCRLExtension)this.mExt;
        int numPoints = ext.getNumPoints();
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("CRLDP_NUMPOINTS") + numPoints + "\n");
        for (int i = 0; i < numPoints; ++i) {
            int idt = this.mIndentSize + 4;
            boolean isEmpty = true;
            sb.append(this.pp.indent(idt) + this.mResource.getString("CRLDP_POINTN") + i + "\n");
            CRLDistributionPoint pt = ext.getPointAt(i);
            idt += 4;
            if (pt.getFullName() != null) {
                isEmpty = false;
                sb.append(this.pp.indent(idt) + this.mResource.getString("CRLDP_DISTPOINT") + pt.getFullName() + "\n");
            }
            if (pt.getRelativeName() != null) {
                isEmpty = false;
                sb.append(this.pp.indent(idt) + this.mResource.getString("CRLDP_DISTPOINT") + pt.getRelativeName() + "\n");
            }
            if (pt.getReasons() != null) {
                isEmpty = false;
                byte[] reasonBits = pt.getReasons().toByteArray();
                String reasonList = ExtPrettyPrint.reasonBitsToReasonList(reasonBits);
                sb.append(this.pp.indent(idt) + this.mResource.getString("CRLDP_REASONS") + reasonList + "\n");
            }
            if (pt.getCRLIssuer() != null) {
                isEmpty = false;
                sb.append(this.pp.indent(idt) + this.mResource.getString("CRLDP_CRLISSUER") + pt.getCRLIssuer() + "\n");
            }
            if (!isEmpty) continue;
            sb.append(this.pp.indent(idt) + "<i>empty</i>\n");
        }
        return sb.toString();
    }

    private String getCRLDistributionPointsExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("CRLDistributionPoints") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        CRLDistributionPointsExtension ext = (CRLDistributionPointsExtension)this.mExt;
        int numPoints = ext.getNumPoints();
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("CRLDP_NUMPOINTS") + numPoints + "\n");
        for (int i = 0; i < numPoints; ++i) {
            int idt = this.mIndentSize + 4;
            boolean isEmpty = true;
            sb.append(this.pp.indent(idt) + this.mResource.getString("CRLDP_POINTN") + i + "\n");
            CRLDistributionPoint pt = ext.getPointAt(i);
            idt += 4;
            if (pt.getFullName() != null) {
                isEmpty = false;
                sb.append(this.pp.indent(idt) + this.mResource.getString("CRLDP_DISTPOINT") + pt.getFullName() + "\n");
            }
            if (pt.getRelativeName() != null) {
                isEmpty = false;
                sb.append(this.pp.indent(idt) + this.mResource.getString("CRLDP_DISTPOINT") + pt.getRelativeName() + "\n");
            }
            if (pt.getReasons() != null) {
                isEmpty = false;
                byte[] reasonBits = pt.getReasons().toByteArray();
                String reasonList = ExtPrettyPrint.reasonBitsToReasonList(reasonBits);
                sb.append(this.pp.indent(idt) + this.mResource.getString("CRLDP_REASONS") + reasonList + "\n");
            }
            if (pt.getCRLIssuer() != null) {
                isEmpty = false;
                sb.append(this.pp.indent(idt) + this.mResource.getString("CRLDP_CRLISSUER") + pt.getCRLIssuer() + "\n");
            }
            if (!isEmpty) continue;
            sb.append(this.pp.indent(idt) + "<i>empty</i>\n");
        }
        return sb.toString();
    }

    private static String reasonBitsToReasonList(byte[] reasonBits) {
        CRLDistributionPointsExtension.Reason[] reasons = CRLDistributionPointsExtension.Reason.bitArrayToReasonArray(reasonBits);
        if (reasons.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(reasons[0].getName());
        for (int i = 1; i < reasons.length; ++i) {
            buf.append(", ");
            buf.append(reasons[i].getName());
        }
        return buf.toString();
    }

    private String getIssuingDistributionPointExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("IssuingDistributionPoint") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        IssuingDistributionPointExtension ext = (IssuingDistributionPointExtension)this.mExt;
        IssuingDistributionPoint issuingDistributionPoint = ext.getIssuingDistributionPoint();
        if (issuingDistributionPoint != null) {
            GeneralNames fullNames = issuingDistributionPoint.getFullName();
            RDN relativeName = issuingDistributionPoint.getRelativeName();
            if (fullNames != null || relativeName != null) {
                sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("DistributionPointName") + "\n");
                if (fullNames != null) {
                    sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("FullName") + "\n");
                    for (int i = 0; i < fullNames.size(); ++i) {
                        GeneralName fullName = (GeneralName)fullNames.elementAt(i);
                        if (fullName == null) continue;
                        sb.append(this.pp.indent(this.mIndentSize + 12) + fullName.toString() + "\n");
                    }
                }
                if (relativeName != null) {
                    sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("NameRelativeToCRLIssuer") + relativeName.toString() + "\n");
                }
            }
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("OnlyContainsUserCerts"));
            if (issuingDistributionPoint.getOnlyContainsUserCerts()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("OnlyContainsCACerts"));
            if (issuingDistributionPoint.getOnlyContainsCACerts()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            BitArray onlySomeReasons = issuingDistributionPoint.getOnlySomeReasons();
            if (onlySomeReasons != null) {
                sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("OnlySomeReasons"));
                sb.append("0x" + this.pp.toHexString(onlySomeReasons.toByteArray()));
            }
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("IndirectCRL"));
            if (issuingDistributionPoint.getIndirectCRL()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
        }
        return sb.toString();
    }

    private String getInvalidityDateExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("invalidityDate") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        InvalidityDateExtension ext = (InvalidityDateExtension)this.mExt;
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("dateOfInvalidity") + ext.getInvalidityDate().toString() + "\n");
        return sb.toString();
    }

    private String getCertificateIssuerExtension() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
            sb.append(this.mResource.getString("CertificateIssuer") + "- " + this.mExt.getExtensionId().toString() + "\n");
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
            CertificateIssuerExtension ext = (CertificateIssuerExtension)this.mExt;
            if (this.mExt.isCritical()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            GeneralNames issuerNames = (GeneralNames)ext.get("value");
            if (issuerNames != null) {
                sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("IssuerNames") + "\n");
                for (int i = 0; i < issuerNames.size(); ++i) {
                    GeneralName issuerName = (GeneralName)issuerNames.elementAt(i);
                    if (issuerName == null) continue;
                    String nameType = "";
                    if (issuerName.getType() == 4) {
                        nameType = "DirectoryName: ";
                    }
                    sb.append(this.pp.indent(this.mIndentSize + 8) + nameType + issuerName.toString() + "\n");
                }
            }
            return sb.toString();
        }
        catch (IOException e) {
            logger.debug("Problem getting certificate issuer", (Throwable)e);
            return "";
        }
    }

    private String getHoldInstructionExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("HoldInstruction") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        HoldInstructionExtension ext = (HoldInstructionExtension)this.mExt;
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("HoldInstructionCode") + ext.getHoldInstructionCodeDescription() + "\n");
        return sb.toString();
    }

    private String getPolicyConstraintsExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("PolicyConstraints") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        PolicyConstraintsExtension ext = (PolicyConstraintsExtension)this.mExt;
        int require = ext.getRequireExplicitMapping();
        int inhibit = ext.getInhibitPolicyMapping();
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("requireExplicitPolicy") + (require == -1 ? this.mResource.getString("notSet") : String.valueOf(require)) + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("inhibitPolicyMapping") + (inhibit == -1 ? this.mResource.getString("notSet") : String.valueOf(inhibit)) + "\n");
        return sb.toString();
    }

    private String getPolicyMappingsExtension() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
        sb.append(this.mResource.getString("PolicyMappings") + "- " + this.mExt.getExtensionId().toString() + "\n");
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
        if (this.mExt.isCritical()) {
            sb.append(this.mResource.getString("tokenYes") + "\n");
        } else {
            sb.append(this.mResource.getString("tokenNo") + "\n");
        }
        PolicyMappingsExtension ext = (PolicyMappingsExtension)this.mExt;
        Enumeration<CertificatePolicyMap> maps = ext.getMappings();
        sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("mappings"));
        if (maps == null || !maps.hasMoreElements()) {
            sb.append(this.mResource.getString("none") + "\n");
        } else {
            sb.append("\n");
            int i = 0;
            while (maps.hasMoreElements()) {
                sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("map") + i + ":\n");
                CertificatePolicyMap m = maps.nextElement();
                sb.append(this.pp.indent(this.mIndentSize + 12) + this.mResource.getString("issuerDomainPolicy") + m.getIssuerIdentifier().getIdentifier().toString() + "\n");
                sb.append(this.pp.indent(this.mIndentSize + 12) + this.mResource.getString("subjectDomainPolicy") + m.getSubjectIdentifier().getIdentifier().toString() + "\n");
                ++i;
            }
        }
        return sb.toString();
    }

    private String getSubjectDirAttributesExtension() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
            sb.append(this.mResource.getString("SubjectDirectoryAttributes") + "- " + this.mExt.getExtensionId().toString() + "\n");
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
            if (this.mExt.isCritical()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            SubjectDirAttributesExtension ext = (SubjectDirAttributesExtension)this.mExt;
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("Attributes"));
            Enumeration<Attribute> attrs = ext.getAttributesList();
            if (attrs == null || !attrs.hasMoreElements()) {
                sb.append(this.mResource.getString("none") + "\n");
            } else {
                sb.append("\n");
                int j = 0;
                while (attrs.hasMoreElements()) {
                    Attribute attr = attrs.nextElement();
                    sb.append(this.pp.indent(this.mIndentSize + 8) + this.mResource.getString("Attribute") + j + ":\n");
                    sb.append(this.pp.indent(this.mIndentSize + 12) + this.mResource.getString("tokenIdentifier") + attr.getOid().toString() + "\n");
                    sb.append(this.pp.indent(this.mIndentSize + 12) + this.mResource.getString("Values"));
                    Enumeration<String> values = attr.getValues();
                    if (values == null || !values.hasMoreElements()) {
                        sb.append(this.mResource.getString("none") + "\n");
                    } else {
                        int k = 0;
                        while (values.hasMoreElements()) {
                            String v = values.nextElement();
                            if (k != 0) {
                                sb.append(",");
                            }
                            sb.append(v);
                            ++k;
                        }
                    }
                    sb.append("\n");
                    ++j;
                }
            }
            return sb.toString();
        }
        catch (Throwable e) {
            return "";
        }
    }

    private String getCertificatePoliciesExtension() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.pp.indent(this.mIndentSize) + this.mResource.getString("tokenIdentifier"));
            sb.append(this.mResource.getString("tokenCertPolicies") + "- " + this.mExt.getExtensionId().toString() + "\n");
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCritical"));
            if (this.mExt.isCritical()) {
                sb.append(this.mResource.getString("tokenYes") + "\n");
            } else {
                sb.append(this.mResource.getString("tokenNo") + "\n");
            }
            sb.append(this.pp.indent(this.mIndentSize + 4) + this.mResource.getString("tokenCertPolicies") + "\n");
            CertificatePoliciesExtension cp = (CertificatePoliciesExtension)this.mExt;
            Vector cpv = (Vector)cp.get("infos");
            Enumeration e = cpv.elements();
            if (e != null) {
                while (e.hasMoreElements()) {
                    CertificatePolicyInfo cpi = (CertificatePolicyInfo)e.nextElement();
                    sb.append(this.pp.indent(this.mIndentSize + 8) + "Policy Identifier: " + cpi.getPolicyIdentifier().getIdentifier().toString() + "\n");
                    PolicyQualifiers cpq = cpi.getPolicyQualifiers();
                    if (cpq == null) continue;
                    for (int i = 0; i < cpq.size(); ++i) {
                        PolicyQualifierInfo pq = cpq.getInfoAt(i);
                        Qualifier q = pq.getQualifier();
                        if (q instanceof CPSuri) {
                            sb.append(this.pp.indent(this.mIndentSize + 12) + "Policy Qualifier Identifier: CPS Pointer Qualifier - " + pq.getId() + "\n");
                            sb.append(this.pp.indent(this.mIndentSize + 12) + "Policy Qualifier Data: " + ((CPSuri)q).getURI() + "\n");
                            continue;
                        }
                        if (!(q instanceof UserNotice)) continue;
                        sb.append(this.pp.indent(this.mIndentSize + 12) + "Policy Qualifier Identifier: CPS User Notice Qualifier - " + pq.getId() + "\n");
                        NoticeReference nref = ((UserNotice)q).getNoticeReference();
                        DisplayText dt = ((UserNotice)q).getDisplayText();
                        sb.append(this.pp.indent(this.mIndentSize + 12) + "Policy Qualifier Data: \n");
                        if (nref != null) {
                            sb.append(this.pp.indent(this.mIndentSize + 16) + "Organization: " + nref.getOrganization().toString() + "\n");
                            sb.append(this.pp.indent(this.mIndentSize + 16) + "Notice Numbers: ");
                            int[] nums = nref.getNumbers();
                            for (int k = 0; k < nums.length; ++k) {
                                if (k != 0) {
                                    sb.append(",");
                                    sb.append(nums[k]);
                                    continue;
                                }
                                sb.append(nums[k]);
                            }
                            sb.append("\n");
                        }
                        if (dt == null) continue;
                        sb.append(this.pp.indent(this.mIndentSize + 16) + "Explicit Text: " + dt.toString() + "\n");
                    }
                }
            }
            return sb.toString();
        }
        catch (IOException e) {
            return sb.toString();
        }
    }
}

