/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.AttributesImpl;
import com.netscape.jndi.ldap.BindingEnum;
import com.netscape.jndi.ldap.EventService;
import com.netscape.jndi.ldap.LdapContextImpl;
import com.netscape.jndi.ldap.LdapReferralException;
import com.netscape.jndi.ldap.NameClassPairEnum;
import com.netscape.jndi.ldap.ObjectMapper;
import com.netscape.jndi.ldap.ProviderUtils;
import com.netscape.jndi.ldap.SearchResultEnum;
import com.netscape.jndi.ldap.common.Debug;
import com.netscape.jndi.ldap.common.ExceptionMapper;
import com.netscape.jndi.ldap.schema.SchemaRoot;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSSLSocketFactory;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.LDAPUrl;

class LdapService {
    public static final String DEFAULT_FILTER = "(objectclass=*)";
    public static final int DEFAULT_SCOPE = 2;
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 389;
    public static final int DEFAULT_SSL_PORT = 636;
    private LDAPConnection m_ld = new LDAPConnection();
    private EventService m_eventSvc;
    private int m_clientCount = 1;

    LDAPConnection getConnection() {
        return this.m_ld;
    }

    void connect(LdapContextImpl ctx) throws NamingException {
        if (this.m_ld.isConnected()) {
            return;
        }
        LDAPUrl url = ctx.m_ctxEnv.getDirectoryServerURL();
        String host = url != null ? url.getHost() : DEFAULT_HOST;
        int port = url != null ? url.getPort() : 389;
        String user = ctx.m_ctxEnv.getUserDN();
        String passwd = ctx.m_ctxEnv.getUserPassword();
        String socketFactory = ctx.m_ctxEnv.getSocketFactory();
        Object cipherSuite = ctx.m_ctxEnv.getCipherSuite();
        int ldapVersion = ctx.m_ctxEnv.getLdapVersion();
        boolean isSSLEnabled = ctx.m_ctxEnv.isSSLEnabled();
        String[] saslMechanisms = ctx.m_ctxEnv.getSaslMechanisms();
        LDAPControl[] ldCtrls = ctx.m_ctxEnv.getConnectControls();
        Object traceOut = ctx.m_ctxEnv.getProperty("com.netscape.ldap.trace");
        if (isSSLEnabled && url == null) {
            port = 636;
        }
        if (isSSLEnabled && socketFactory == null) {
            this.m_ld = new LDAPConnection((LDAPSocketFactory)new LDAPSSLSocketFactory());
        }
        if (socketFactory != null) {
            try {
                LDAPSSLSocketFactory sf = null;
                if (cipherSuite != null) {
                    Debug.println(1, "CIPHERS=" + cipherSuite);
                    sf = new LDAPSSLSocketFactory(socketFactory, cipherSuite);
                } else {
                    sf = new LDAPSSLSocketFactory(socketFactory);
                }
                this.m_ld = new LDAPConnection((LDAPSocketFactory)sf);
                Debug.println(1, "SSL CONNECTION");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal value for java.naming.ldap.factory.socket: " + e);
            }
        }
        if (traceOut != null) {
            this.setTraceOutput(traceOut);
        }
        try {
            if (ldCtrls != null) {
                this.m_ld.setOption(12, (Object)ldCtrls);
            }
            if (saslMechanisms != null) {
                this.m_ld.authenticate(ctx.m_ctxEnv.getSaslAuthId(), saslMechanisms, ctx.m_ctxEnv.getSaslProps(), ctx.m_ctxEnv.getSaslCallback());
            } else {
                this.m_ld.connect(ldapVersion, host, port, user, passwd);
            }
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 2 && ldapVersion == 3 && saslMechanisms == null && ctx.m_ctxEnv.getProperty("java.naming.ldap.version") == null) {
                try {
                    this.m_ld.connect(2, host, port, user, passwd);
                }
                catch (LDAPException e2) {
                    throw ExceptionMapper.getNamingException((Exception)((Object)e2));
                }
            }
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    protected void finalize() {
        try {
            this.m_ld.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean isConnected() {
        return this.m_ld.isConnected();
    }

    synchronized void disconnect() {
        try {
            if (this.m_clientCount > 0) {
                --this.m_clientCount;
            }
            if (this.m_clientCount == 0 && this.isConnected()) {
                this.m_ld.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void incrementClientCount() {
        ++this.m_clientCount;
    }

    NamingEnumeration<SearchResult> search(LdapContextImpl ctx, String name, String filter, String[] attrs, SearchControls jndiCtrls) throws NamingException {
        Debug.println(1, "SEARCH");
        Object base = ctx.getDN();
        int scope = 2;
        LDAPSearchConstraints cons = ctx.getSearchConstraints();
        boolean returnObjs = false;
        this.connect(ctx);
        if (name.length() > 0) {
            base = ((String)base).length() > 0 ? name + "," + (String)base : name;
        }
        if (jndiCtrls != null) {
            int maxResults = (int)jndiCtrls.getCountLimit();
            int timeLimitInMsec = jndiCtrls.getTimeLimit();
            int timeLimit = timeLimitInMsec / 1000;
            if (timeLimitInMsec > 0 && timeLimitInMsec < 1000) {
                timeLimit = 1;
            }
            if (cons.getServerTimeLimit() != timeLimit || cons.getMaxResults() != maxResults) {
                cons = (LDAPSearchConstraints)cons.clone();
                cons.setMaxResults(maxResults);
                cons.setServerTimeLimit(timeLimit);
            }
            if ((attrs = jndiCtrls.getReturningAttributes()) != null && attrs.length == 0) {
                attrs = new String[]{"1.1"};
            }
            scope = ProviderUtils.jndiSearchScopeToLdap(jndiCtrls.getSearchScope());
            returnObjs = jndiCtrls.getReturningObjFlag();
        }
        try {
            boolean attrsOnly = ctx.m_ctxEnv.getAttrsOnlyFlag();
            LDAPSearchResults res = this.m_ld.search((String)base, scope, filter, attrs, attrsOnly, cons);
            return new SearchResultEnum(res, returnObjs, ctx);
        }
        catch (LDAPReferralException e) {
            throw new LdapReferralException(ctx, e);
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    NamingEnumeration<NameClassPair> list(LdapContextImpl ctx, String name) throws NamingException {
        Debug.println(1, "LIST");
        Object base = ctx.getDN();
        this.connect(ctx);
        if (name.length() > 0) {
            base = ((String)base).length() > 0 ? name + "," + (String)base : name;
        }
        try {
            String[] attrs = new String[]{"javaclassname"};
            LDAPSearchConstraints cons = ctx.getSearchConstraints();
            LDAPSearchResults res = this.m_ld.search((String)base, 1, DEFAULT_FILTER, attrs, false, cons);
            return new NameClassPairEnum(res, ctx);
        }
        catch (LDAPReferralException e) {
            throw new LdapReferralException(ctx, e);
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    NamingEnumeration<Binding> listBindings(LdapContextImpl ctx, String name) throws NamingException {
        Debug.println(1, "LIST BINDINGS");
        Object base = ctx.getDN();
        this.connect(ctx);
        if (name.length() > 0) {
            base = ((String)base).length() > 0 ? name + "," + (String)base : name;
        }
        try {
            String[] attrs = null;
            LDAPSearchConstraints cons = ctx.getSearchConstraints();
            LDAPSearchResults res = this.m_ld.search((String)base, 1, DEFAULT_FILTER, attrs, false, cons);
            return new BindingEnum(res, ctx);
        }
        catch (LDAPReferralException e) {
            throw new LdapReferralException(ctx, e);
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    Object lookup(LdapContextImpl ctx, String name) throws NamingException {
        Debug.println(1, "LOOKUP");
        Object base = ctx.getDN();
        this.connect(ctx);
        if (name.length() > 0) {
            base = ((String)base).length() > 0 ? name + "," + (String)base : name;
        }
        try {
            String[] attrs = null;
            LDAPSearchConstraints cons = ctx.getSearchConstraints();
            LDAPSearchResults res = this.m_ld.search((String)base, 0, DEFAULT_FILTER, attrs, false, cons);
            if (res.hasMoreElements()) {
                LDAPEntry entry = res.next();
                return ObjectMapper.entryToObject(entry, ctx);
            }
            return null;
        }
        catch (LDAPReferralException e) {
            throw new LdapReferralException(ctx, e);
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    Attributes readAttrs(LdapContextImpl ctx, String name, String[] attrs) throws NamingException {
        Debug.println(1, "READ ATTRS");
        Object base = ctx.getDN();
        int scope = 0;
        this.connect(ctx);
        if (name.length() > 0) {
            base = ((String)base).length() > 0 ? name + "," + (String)base : name;
        }
        try {
            LDAPSearchConstraints cons = ctx.getSearchConstraints();
            LDAPSearchResults res = this.m_ld.search((String)base, scope, DEFAULT_FILTER, attrs, false, cons);
            if (res.hasMoreElements()) {
                LDAPEntry entry = res.next();
                return new AttributesImpl(entry.getAttributeSet(), ctx.m_ctxEnv.getUserDefBinaryAttrs());
            }
            return null;
        }
        catch (LDAPReferralException e) {
            throw new LdapReferralException(ctx, e);
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    void modifyEntry(LdapContextImpl ctx, String name, LDAPModificationSet mods) throws NamingException {
        Debug.println(1, "MODIFY");
        Object base = ctx.getDN();
        if (mods.size() == 0) {
            return;
        }
        this.connect(ctx);
        if (name.length() > 0) {
            base = ((String)base).length() > 0 ? name + "," + (String)base : name;
        }
        try {
            this.m_ld.modify((String)base, mods);
        }
        catch (LDAPReferralException e) {
            throw new LdapReferralException(ctx, e);
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    LdapContextImpl addEntry(LdapContextImpl ctx, String name, LDAPAttributeSet attrs) throws NamingException {
        Debug.println(1, "ADD");
        Object dn = ctx.getDN();
        this.connect(ctx);
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name can not be empty");
        }
        dn = ((String)dn).length() > 0 ? name + "," + (String)dn : name;
        try {
            this.m_ld.add(new LDAPEntry((String)dn, attrs));
            return new LdapContextImpl((String)dn, ctx);
        }
        catch (LDAPReferralException e) {
            throw new LdapReferralException(ctx, e);
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    void delEntry(LdapContextImpl ctx, String name) throws NamingException {
        Debug.println(1, "DELETE");
        Object dn = ctx.getDN();
        this.connect(ctx);
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name can not be empty");
        }
        dn = ((String)dn).length() > 0 ? name + "," + (String)dn : name;
        try {
            this.m_ld.delete((String)dn);
        }
        catch (LDAPReferralException e) {
            throw new LdapReferralException(ctx, e);
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    void changeRDN(LdapContextImpl ctx, String name, String newRDN) throws NamingException {
        Debug.println(1, "RENAME");
        Object dn = ctx.getDN();
        this.connect(ctx);
        if (name.length() == 0 || newRDN.length() == 0) {
            throw new IllegalArgumentException("Name can not be empty");
        }
        dn = ((String)dn).length() > 0 ? name + "," + (String)dn : name;
        try {
            this.m_ld.rename((String)dn, newRDN, ctx.m_ctxEnv.getDeleteOldRDNFlag());
        }
        catch (LDAPReferralException e) {
            throw new LdapReferralException(ctx, e);
        }
        catch (LDAPException e) {
            throw ExceptionMapper.getNamingException((Exception)((Object)e));
        }
    }

    DirContext getSchema(LdapContextImpl ctx, String name) throws NamingException {
        this.connect(ctx);
        return new SchemaRoot(this.m_ld);
    }

    EventService getEventService(LdapContextImpl ctx) throws NamingException {
        this.connect(ctx);
        if (this.m_eventSvc == null) {
            this.m_eventSvc = new EventService(this);
        }
        return this.m_eventSvc;
    }

    void setTraceOutput(Object out) throws NamingException {
        try {
            this.m_ld.setProperty("com.netscape.ldap.trace", out);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not open trace output " + e);
        }
    }
}

