/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestHeaderElement;
import org.apache.ivy.osgi.core.ManifestHeaderValue;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;

public final class ManifestHeaderValue$ManifestHeaderParser {
    private final String header;
    private int length;
    private StringBuffer buffer;
    private int pos;
    private char c;
    private ManifestHeaderElement elem;
    private boolean valuesParsed;
    private String paramName;
    private boolean isDirective;
    private final ManifestHeaderValue this$0;

    ManifestHeaderValue$ManifestHeaderParser(ManifestHeaderValue manifestHeaderValue, String string) {
        this.this$0 = manifestHeaderValue;
        this.buffer = new StringBuffer();
        this.pos = 0;
        this.elem = new ManifestHeaderElement();
        this.header = string;
        this.length = string.length();
    }

    final void parse() {
        do {
            this.elem = new ManifestHeaderElement();
            int n = this.pos;
            ManifestHeaderValue$ManifestHeaderParser manifestHeaderValue$ManifestHeaderParser = this;
            this.valuesParsed = false;
            block16: do {
                ManifestHeaderValue$ManifestHeaderParser manifestHeaderValue$ManifestHeaderParser2 = manifestHeaderValue$ManifestHeaderParser;
                boolean bl = false;
                boolean bl2 = false;
                block17: do {
                    switch (manifestHeaderValue$ManifestHeaderParser2.readNext()) {
                        case '\u0000': {
                            break;
                        }
                        case ',': 
                        case ';': {
                            manifestHeaderValue$ManifestHeaderParser2.endValue();
                            continue block16;
                        }
                        case ':': 
                        case '=': {
                            ManifestHeaderValue$ManifestHeaderParser manifestHeaderValue$ManifestHeaderParser3 = manifestHeaderValue$ManifestHeaderParser2;
                            if (manifestHeaderValue$ManifestHeaderParser3.buffer.length() == 0) {
                                manifestHeaderValue$ManifestHeaderParser3.error("Empty parameter name");
                                manifestHeaderValue$ManifestHeaderParser3.paramName = null;
                            }
                            manifestHeaderValue$ManifestHeaderParser3.paramName = manifestHeaderValue$ManifestHeaderParser3.buffer.toString();
                            manifestHeaderValue$ManifestHeaderParser3.buffer.setLength(0);
                            manifestHeaderValue$ManifestHeaderParser3 = manifestHeaderValue$ManifestHeaderParser2;
                            if (manifestHeaderValue$ManifestHeaderParser3.c == '=') {
                                manifestHeaderValue$ManifestHeaderParser3.isDirective = false;
                            } else {
                                if (manifestHeaderValue$ManifestHeaderParser3.readNext() != '=') {
                                    manifestHeaderValue$ManifestHeaderParser3.error("Expecting '='");
                                    --manifestHeaderValue$ManifestHeaderParser3.pos;
                                    manifestHeaderValue$ManifestHeaderParser3.paramName = null;
                                }
                                manifestHeaderValue$ManifestHeaderParser3.isDirective = true;
                            }
                            manifestHeaderValue$ManifestHeaderParser3 = manifestHeaderValue$ManifestHeaderParser2;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            block18: do {
                                switch (manifestHeaderValue$ManifestHeaderParser3.readNext()) {
                                    case '\u0000': {
                                        break;
                                    }
                                    case ',': 
                                    case ';': {
                                        manifestHeaderValue$ManifestHeaderParser3.endParameterValue();
                                        continue block16;
                                    }
                                    case ':': 
                                    case '=': {
                                        manifestHeaderValue$ManifestHeaderParser3.error("Illegal character '" + manifestHeaderValue$ManifestHeaderParser3.c + "' in parameter value of " + manifestHeaderValue$ManifestHeaderParser3.paramName);
                                        manifestHeaderValue$ManifestHeaderParser3.paramName = null;
                                        break;
                                    }
                                    case '\"': {
                                        bl5 = true;
                                    }
                                    case '\'': {
                                        if (bl4 && manifestHeaderValue$ManifestHeaderParser3.paramName != null) {
                                            manifestHeaderValue$ManifestHeaderParser3.error("Expecting the end of a parameter value");
                                            manifestHeaderValue$ManifestHeaderParser3.paramName = null;
                                        }
                                        if (bl3) {
                                            manifestHeaderValue$ManifestHeaderParser3.buffer.append(manifestHeaderValue$ManifestHeaderParser3.c);
                                            break;
                                        }
                                        bl3 = true;
                                        manifestHeaderValue$ManifestHeaderParser3.appendQuoted(bl5);
                                        bl4 = true;
                                        break;
                                    }
                                    case '\\': {
                                        if (bl4 && manifestHeaderValue$ManifestHeaderParser3.paramName != null) {
                                            manifestHeaderValue$ManifestHeaderParser3.error("Expecting the end of a parameter value");
                                            manifestHeaderValue$ManifestHeaderParser3.paramName = null;
                                        }
                                        bl3 = true;
                                        ManifestHeaderValue$ManifestHeaderParser manifestHeaderValue$ManifestHeaderParser4 = manifestHeaderValue$ManifestHeaderParser3;
                                        if (manifestHeaderValue$ManifestHeaderParser4.pos < manifestHeaderValue$ManifestHeaderParser4.length) {
                                            manifestHeaderValue$ManifestHeaderParser4.buffer.append(manifestHeaderValue$ManifestHeaderParser4.readNext());
                                            break;
                                        }
                                        manifestHeaderValue$ManifestHeaderParser4.buffer.append(manifestHeaderValue$ManifestHeaderParser4.c);
                                        break;
                                    }
                                    case '\t': 
                                    case '\n': 
                                    case '\r': 
                                    case ' ': {
                                        if (!bl3) continue block18;
                                        bl4 = true;
                                        break;
                                    }
                                    default: {
                                        if (bl4 && manifestHeaderValue$ManifestHeaderParser3.paramName != null) {
                                            manifestHeaderValue$ManifestHeaderParser3.error("Expecting the end of a parameter value");
                                            manifestHeaderValue$ManifestHeaderParser3.paramName = null;
                                        }
                                        bl3 = true;
                                        manifestHeaderValue$ManifestHeaderParser3.buffer.append(manifestHeaderValue$ManifestHeaderParser3.c);
                                    }
                                }
                            } while (manifestHeaderValue$ManifestHeaderParser3.pos < manifestHeaderValue$ManifestHeaderParser3.length);
                            manifestHeaderValue$ManifestHeaderParser3.endParameterValue();
                            continue block16;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (!bl) continue block17;
                            bl2 = true;
                            break;
                        }
                        default: {
                            if (bl2) {
                                manifestHeaderValue$ManifestHeaderParser2.error("Expecting the end of a value or of an parameter name");
                                bl2 = false;
                            }
                            bl = true;
                            manifestHeaderValue$ManifestHeaderParser2.buffer.append(manifestHeaderValue$ManifestHeaderParser2.c);
                        }
                    }
                } while (manifestHeaderValue$ManifestHeaderParser2.pos < manifestHeaderValue$ManifestHeaderParser2.length);
                manifestHeaderValue$ManifestHeaderParser2.endValue();
            } while (manifestHeaderValue$ManifestHeaderParser.c == ';' && manifestHeaderValue$ManifestHeaderParser.pos < manifestHeaderValue$ManifestHeaderParser.length);
            if (this.elem.getValues().isEmpty()) {
                ManifestHeaderValue$ManifestHeaderParser.error("No defined value", n);
                continue;
            }
            this.this$0.addElement(this.elem);
        } while (this.pos < this.length);
    }

    private char readNext() {
        this.c = this.pos == this.length ? (char)'\u0000' : this.header.charAt(this.pos++);
        return this.c;
    }

    private void error(String string) {
        ManifestHeaderValue$ManifestHeaderParser.error(string, this.pos - 1);
    }

    private static void error(String string, int n) {
        throw new ParseException(string, n);
    }

    private void endValue() {
        if (this.valuesParsed) {
            this.error("Early end of a parameter");
            this.buffer.setLength(0);
            return;
        }
        if (this.buffer.length() == 0) {
            this.error("Empty value");
        }
        this.elem.addValue(this.buffer.toString());
        this.buffer.setLength(0);
    }

    private void endParameterValue() {
        if (this.paramName == null) {
            return;
        }
        if (this.buffer.length() == 0) {
            this.error("Empty parameter value");
            return;
        }
        String string = this.buffer.toString();
        if (this.isDirective) {
            this.elem.addDirective(this.paramName, string);
        } else {
            this.elem.addAttribute(this.paramName, string);
        }
        this.valuesParsed = true;
        this.buffer.setLength(0);
    }

    private void appendQuoted(boolean bl) {
        do {
            switch (this.readNext()) {
                case '\u0000': {
                    break;
                }
                case '\"': {
                    if (bl) {
                        return;
                    }
                    this.buffer.append(this.c);
                    break;
                }
                case '\'': {
                    if (!bl) {
                        return;
                    }
                    this.buffer.append(this.c);
                    break;
                }
                case '\\': {
                    break;
                }
                default: {
                    this.buffer.append(this.c);
                }
            }
        } while (this.pos < this.length);
    }

    public ManifestHeaderValue$ManifestHeaderParser() {
    }

    public static BundleInfo parseManifest(Manifest manifest) {
        Version version;
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.getValue("Bundle-ManifestVersion") == null) {
            throw new ParseException("No Bundle-ManifestVersion in the manifest", 0);
        }
        String string = new ManifestHeaderValue(attributes.getValue("Bundle-SymbolicName")).getSingleValue();
        if (string == null) {
            throw new ParseException("No Bundle-SymbolicName in the manifest", 0);
        }
        if (new ManifestHeaderValue(attributes.getValue("Bundle-Description")).getSingleValue() == null) {
            new ManifestHeaderValue(attributes.getValue("Bundle-Description")).getSingleValue();
        }
        String string2 = new ManifestHeaderValue(attributes.getValue("Bundle-Version")).getSingleValue();
        try {
            version = ManifestHeaderValue$ManifestHeaderParser.versionOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("The Bundle-Version has an incorrect version: " + string2 + " (" + numberFormatException.getMessage() + ")", 0);
        }
        BundleInfo bundleInfo = new BundleInfo(string, version);
        List list = new ManifestHeaderValue(attributes.getValue("Bundle-RequiredExecutionEnvironment")).getValues();
        bundleInfo.setExecutionEnvironments(list);
        ManifestHeaderValue$ManifestHeaderParser.parseRequirement(bundleInfo, attributes, "Require-Bundle", "bundle", "bundle-version");
        ManifestHeaderValue$ManifestHeaderParser.parseRequirement(bundleInfo, attributes, "Import-Package", "package", "version");
        ManifestHeaderValue$ManifestHeaderParser.parseRequirement(bundleInfo, attributes, "Import-Service", "service", "version");
        Iterator iterator = new ManifestHeaderValue(attributes.getValue("Export-Package")).getElements().iterator();
        while (iterator.hasNext()) {
            Version version2;
            ManifestHeaderElement manifestHeaderElement = (ManifestHeaderElement)iterator.next();
            String string3 = (String)manifestHeaderElement.getAttributes().get("version");
            try {
                version2 = ManifestHeaderValue$ManifestHeaderParser.versionOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("The Export-Package has an incorrect version: " + string3 + " (" + numberFormatException.getMessage() + ")", 0);
            }
            Iterator iterator2 = manifestHeaderElement.getValues().iterator();
            while (iterator2.hasNext()) {
                String string4 = (String)iterator2.next();
                ExportPackage exportPackage = new ExportPackage(string4, version2);
                String string5 = (String)manifestHeaderElement.getDirectives().get("use");
                if (string5 != null) {
                    String[] stringArray = string5.trim().split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        exportPackage.addUse(stringArray[i].trim());
                    }
                }
                bundleInfo.addCapability(exportPackage);
            }
        }
        ManifestHeaderValue$ManifestHeaderParser.parseCapability(bundleInfo, attributes, "Export-Service", "service");
        return bundleInfo;
    }

    private static void parseRequirement(BundleInfo bundleInfo, Attributes attributes, String string, String string2, String string3) {
        Iterator iterator = new ManifestHeaderValue(attributes.getValue(string)).getElements().iterator();
        while (iterator.hasNext()) {
            VersionRange versionRange;
            ManifestHeaderElement manifestHeaderElement = (ManifestHeaderElement)iterator.next();
            String string4 = (String)manifestHeaderElement.getDirectives().get("resolution");
            String string5 = (String)manifestHeaderElement.getAttributes().get(string3);
            try {
                String string6 = string5;
                versionRange = string6 == null ? null : new VersionRange(string6);
            }
            catch (ParseException parseException) {
                throw new ParseException("The " + string + " has an incorrect version: " + string5 + " (" + parseException.getMessage() + ")", 0);
            }
            Iterator iterator2 = manifestHeaderElement.getValues().iterator();
            while (iterator2.hasNext()) {
                String string7 = (String)iterator2.next();
                bundleInfo.addRequirement(new BundleRequirement(string2, string7, versionRange, string4));
            }
        }
    }

    private static void parseCapability(BundleInfo bundleInfo, Attributes attributes, String string, String string2) {
        Iterator iterator = new ManifestHeaderValue(attributes.getValue(string)).getElements().iterator();
        while (iterator.hasNext()) {
            Version version;
            ManifestHeaderElement manifestHeaderElement = (ManifestHeaderElement)iterator.next();
            String string3 = (String)manifestHeaderElement.getAttributes().get("version");
            try {
                version = ManifestHeaderValue$ManifestHeaderParser.versionOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("The " + string + " has an incorrect version: " + string3 + " (" + numberFormatException.getMessage() + ")", 0);
            }
            Iterator iterator2 = manifestHeaderElement.getValues().iterator();
            while (iterator2.hasNext()) {
                String string4 = (String)iterator2.next();
                BundleCapability bundleCapability = new BundleCapability(string2, string4, version);
                bundleInfo.addCapability(bundleCapability);
            }
        }
    }

    private static Version versionOf(String string) {
        if (string == null) {
            return null;
        }
        return new Version(string);
    }
}

