/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs12;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.pkcs12.PKCS12CertCLI;
import java.io.BufferedReader;
import java.io.FileReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.pkcs.PKCS12;
import org.mozilla.jss.netscape.security.pkcs.PKCS12Util;
import org.mozilla.jss.util.Password;

public class PKCS12CertRemoveCLI
extends CommandCLI {
    public PKCS12CertCLI certCLI;

    public PKCS12CertRemoveCLI(PKCS12CertCLI certCLI) {
        super("del", "Remove certificate from PKCS #12 file", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <nickname> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "pkcs12-file", true, "PKCS #12 file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-password", true, "PKCS #12 password");
        option.setArgName("password");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-password-file", true, "PKCS #12 password file");
        option.setArgName("path");
        this.options.addOption(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        String passwordFile;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length == 0) {
            throw new Exception("Missing certificate nickname.");
        }
        String nickname = cmdArgs[0];
        String filename = cmd.getOptionValue("pkcs12-file");
        if (filename == null) {
            throw new Exception("Missing PKCS #12 file.");
        }
        String passwordString = cmd.getOptionValue("pkcs12-password");
        if (passwordString == null && (passwordFile = cmd.getOptionValue("pkcs12-password-file")) != null) {
            try (BufferedReader in = new BufferedReader(new FileReader(passwordFile));){
                passwordString = in.readLine();
            }
        }
        if (passwordString == null) {
            throw new Exception("Missing PKCS #12 password.");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        Password password = new Password(passwordString.toCharArray());
        try {
            PKCS12Util util = new PKCS12Util();
            PKCS12 pkcs12 = util.loadFromFile(filename, password);
            pkcs12.removeCertInfoByFriendlyName(nickname);
            util.storeIntoFile(pkcs12, filename, password);
        }
        finally {
            password.clear();
        }
        MainCLI.printMessage("Deleted certificate \"" + nickname + "\"");
    }
}

