/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cms.profile.def.KeyUsageExtDefault;
import com.netscape.cms.profile.def.NoDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.profile.def.UserExtensionDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

public class KeyUsageExtConstraint
extends EnrollConstraint {
    public static final String CONFIG_CRITICAL = "keyUsageCritical";
    public static final String CONFIG_DIGITAL_SIGNATURE = "keyUsageDigitalSignature";
    public static final String CONFIG_NON_REPUDIATION = "keyUsageNonRepudiation";
    public static final String CONFIG_KEY_ENCIPHERMENT = "keyUsageKeyEncipherment";
    public static final String CONFIG_DATA_ENCIPHERMENT = "keyUsageDataEncipherment";
    public static final String CONFIG_KEY_AGREEMENT = "keyUsageKeyAgreement";
    public static final String CONFIG_KEY_CERTSIGN = "keyUsageKeyCertSign";
    public static final String CONFIG_CRL_SIGN = "keyUsageCrlSign";
    public static final String CONFIG_ENCIPHER_ONLY = "keyUsageEncipherOnly";
    public static final String CONFIG_DECIPHER_ONLY = "keyUsageDecipherOnly";

    public KeyUsageExtConstraint() {
        this.addConfigName(CONFIG_CRITICAL);
        this.addConfigName(CONFIG_DIGITAL_SIGNATURE);
        this.addConfigName(CONFIG_NON_REPUDIATION);
        this.addConfigName(CONFIG_KEY_ENCIPHERMENT);
        this.addConfigName(CONFIG_DATA_ENCIPHERMENT);
        this.addConfigName(CONFIG_KEY_AGREEMENT);
        this.addConfigName(CONFIG_KEY_CERTSIGN);
        this.addConfigName(CONFIG_CRL_SIGN);
        this.addConfigName(CONFIG_ENCIPHER_ONLY);
        this.addConfigName(CONFIG_DECIPHER_ONLY);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_CRITICAL)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(CONFIG_DIGITAL_SIGNATURE)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DIGITAL_SIGNATURE", (String[])new String[0]));
        }
        if (name.equals(CONFIG_NON_REPUDIATION)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NON_REPUDIATION", (String[])new String[0]));
        }
        if (name.equals(CONFIG_KEY_ENCIPHERMENT)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_ENCIPHERMENT", (String[])new String[0]));
        }
        if (name.equals(CONFIG_DATA_ENCIPHERMENT)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DATA_ENCIPHERMENT", (String[])new String[0]));
        }
        if (name.equals(CONFIG_KEY_AGREEMENT)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_AGREEMENT", (String[])new String[0]));
        }
        if (name.equals(CONFIG_KEY_CERTSIGN)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_CERTSIGN", (String[])new String[0]));
        }
        if (name.equals(CONFIG_CRL_SIGN)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRL_SIGN", (String[])new String[0]));
        }
        if (name.equals(CONFIG_ENCIPHER_ONLY)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ENCIPHER_ONLY", (String[])new String[0]));
        }
        if (name.equals(CONFIG_DECIPHER_ONLY)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DECIPHER_ONLY", (String[])new String[0]));
        }
        return null;
    }

    public boolean isSet(boolean[] bits, int position) {
        if (bits.length <= position) {
            return false;
        }
        return bits[position];
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        boolean bit;
        boolean critical;
        KeyUsageExtension ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
        if (ext == null) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_EXTENSION_NOT_FOUND", (String[])new String[]{PKIXExtensions.KeyUsage_Id.toString()}));
        }
        boolean[] bits = ext.getBits();
        String value = this.getConfig(CONFIG_CRITICAL);
        if (!this.isOptional(value) && (critical = this.getBoolean(value)) != ext.isCritical()) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_CRITICAL_NOT_MATCHED", (String[])new String[0]));
        }
        value = this.getConfig(CONFIG_DIGITAL_SIGNATURE);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != this.isSet(bits, 0)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_DIGITAL_SIGNATURE_NOT_MATCHED", (String[])new String[]{value}));
        }
        value = this.getConfig(CONFIG_NON_REPUDIATION);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != this.isSet(bits, 1)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_NON_REPUDIATION_NOT_MATCHED", (String[])new String[]{value}));
        }
        value = this.getConfig(CONFIG_KEY_ENCIPHERMENT);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != this.isSet(bits, 2)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_KEY_ENCIPHERMENT_NOT_MATCHED", (String[])new String[]{value}));
        }
        value = this.getConfig(CONFIG_DATA_ENCIPHERMENT);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != this.isSet(bits, 3)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_DATA_ENCIPHERMENT_NOT_MATCHED", (String[])new String[]{value}));
        }
        value = this.getConfig(CONFIG_KEY_AGREEMENT);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != this.isSet(bits, 4)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_KEY_AGREEMENT_NOT_MATCHED", (String[])new String[]{value}));
        }
        value = this.getConfig(CONFIG_KEY_CERTSIGN);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != this.isSet(bits, 5)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_KEY_CERTSIGN_NOT_MATCHED", (String[])new String[]{value}));
        }
        value = this.getConfig(CONFIG_CRL_SIGN);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != this.isSet(bits, 6)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_CRL_SIGN_NOT_MATCHED", (String[])new String[]{value}));
        }
        value = this.getConfig(CONFIG_ENCIPHER_ONLY);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != this.isSet(bits, 7)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_ENCIPHER_ONLY_NOT_MATCHED", (String[])new String[]{value}));
        }
        value = this.getConfig(CONFIG_DECIPHER_ONLY);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != this.isSet(bits, 8)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_DECIPHER_ONLY_NOT_MATCHED", (String[])new String[]{value}));
        }
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig(CONFIG_CRITICAL), this.getConfig(CONFIG_DIGITAL_SIGNATURE), this.getConfig(CONFIG_NON_REPUDIATION), this.getConfig(CONFIG_KEY_ENCIPHERMENT), this.getConfig(CONFIG_DATA_ENCIPHERMENT), this.getConfig(CONFIG_KEY_AGREEMENT), this.getConfig(CONFIG_KEY_CERTSIGN), this.getConfig(CONFIG_CRL_SIGN), this.getConfig(CONFIG_ENCIPHER_ONLY), this.getConfig(CONFIG_DECIPHER_ONLY)};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_KEY_USAGE_EXT_TEXT", (String[])params);
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        if (def instanceof NoDefault) {
            return true;
        }
        if (def instanceof KeyUsageExtDefault) {
            return true;
        }
        return def instanceof UserExtensionDefault;
    }
}

