/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cms.profile.def.NoDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.profile.def.SubjectNameDefault;
import com.netscape.cms.profile.def.UserSubjectNameDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectNameConstraint
extends EnrollConstraint {
    public static Logger logger = LoggerFactory.getLogger(SubjectNameConstraint.class);
    public static final String CONFIG_PATTERN = "pattern";
    private static final int COMMON_NAME_MAX = 64;
    private static final int LOCALITY_NAME_MAX = 128;
    private static final int STATE_NAME_MAX = 128;
    private static final int ORG_NAME_MAX = 64;
    private static final int ORG_UNIT_NAME_MAX = 64;
    private static final int EMAIL_NAME_MAX = 255;
    private static final int COUNTRY_NAME_MAX = 3;
    private static final int UID_NAME_MAX = 64;

    public SubjectNameConstraint() {
        this.addConfigName(CONFIG_PATTERN);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_PATTERN)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME_PATTERN", (String[])new String[0]));
        }
        return null;
    }

    public String getDefaultConfig(String name) {
        return null;
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        logger.debug("SubjectNameConstraint: validate start");
        CertificateSubjectName sn = null;
        try {
            sn = (CertificateSubjectName)info.get("subject");
            logger.debug("SubjectNameConstraint: validate cert subject =" + sn.toString());
        }
        catch (Exception e) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SUBJECT_NAME_NOT_FOUND", (String[])new String[0]));
        }
        X500Name sn500 = null;
        try {
            sn500 = (X500Name)sn.get("dname");
        }
        catch (IOException e) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SUBJECT_NAME_NOT_FOUND", (String[])new String[0]));
        }
        if (sn500 == null) {
            logger.error("SubjectNameConstraint: validate() - sn500 is null");
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SUBJECT_NAME_NOT_FOUND", (String[])new String[0]));
        }
        logger.debug("SubjectNameConstraint: validate() - sn500 dname = " + sn500.toString());
        if (!sn500.toString().matches(this.getConfig(CONFIG_PATTERN))) {
            logger.error("SubjectNameConstraint: validate() - sn500 not matching pattern " + this.getConfig(CONFIG_PATTERN));
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SUBJECT_NAME_NOT_MATCHED", (String[])new String[]{sn500.toString()}));
        }
        Object incorrectFields = " [ Invalid fields: ";
        String country = null;
        boolean fieldError = false;
        String commonName = null;
        try {
            commonName = sn500.getCommonName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (commonName != null && commonName.length() > 64) {
            fieldError = true;
            incorrectFields = (String)incorrectFields + " Common Name ";
        }
        try {
            country = sn500.getCountry();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (country != null && country.length() > 3) {
            fieldError = true;
            incorrectFields = (String)incorrectFields + " , Country ";
        }
        String ou = null;
        try {
            ou = sn500.getOrganizationalUnit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ou != null && ou.length() > 64) {
            fieldError = true;
            incorrectFields = (String)incorrectFields + " , Org Unit ";
        }
        String o = null;
        try {
            o = sn500.getOrganization();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (o != null && o.length() > 64) {
            fieldError = true;
            incorrectFields = (String)incorrectFields + " , Org ";
        }
        String locality = null;
        try {
            locality = sn500.getLocality();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (locality != null && locality.length() > 128) {
            fieldError = true;
            incorrectFields = (String)incorrectFields + " , Locality ";
        }
        String state = null;
        try {
            state = sn500.getState();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (state != null && state.length() > 128) {
            fieldError = true;
            incorrectFields = (String)incorrectFields + " , State ";
        }
        String email = null;
        try {
            email = sn500.getEmail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (email != null && email.length() > 255) {
            fieldError = true;
            incorrectFields = (String)incorrectFields + " , Email ";
        }
        String UID = null;
        try {
            UID = sn500.getUserID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (UID != null && UID.length() > 64) {
            fieldError = true;
            incorrectFields = (String)incorrectFields + " , UID";
        }
        if (fieldError) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_INVALID_SUBJECT_NAME", (String[])new String[]{sn500.toString() + (String)incorrectFields + " ] "}));
        }
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_SUBJECT_NAME_TEXT", (String[])new String[]{this.getConfig(CONFIG_PATTERN)});
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        if (def instanceof NoDefault) {
            return true;
        }
        if (def instanceof SubjectNameDefault) {
            return true;
        }
        return def instanceof UserSubjectNameDefault;
    }
}

