/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidityDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(ValidityDefault.class);
    public static final String CONFIG_RANGE = "range";
    public static final String CONFIG_RANGE_UNIT = "rangeUnit";
    public static final String CONFIG_START_TIME = "startTime";
    public static final String VAL_NOT_BEFORE = "notBefore";
    public static final String VAL_NOT_AFTER = "notAfter";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public ValidityDefault() {
        this.addConfigName(CONFIG_RANGE);
        this.addConfigName(CONFIG_RANGE_UNIT);
        this.addConfigName(CONFIG_START_TIME);
        this.addValueName(VAL_NOT_BEFORE);
        this.addValueName(VAL_NOT_AFTER);
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        if (name.equals(CONFIG_RANGE)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_RANGE}));
            }
        }
        if (name.equals(CONFIG_START_TIME)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_START_TIME}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_RANGE)) {
            return new Descriptor("string", null, "7305", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_RANGE", (String[])new String[0]));
        }
        if (name.equals(CONFIG_RANGE_UNIT)) {
            return new Descriptor("string", null, "day", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_RANGE_UNIT", (String[])new String[0]));
        }
        if (name.equals(CONFIG_START_TIME)) {
            return new Descriptor("string", null, "60", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_START_TIME", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_NOT_BEFORE)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_BEFORE", (String[])new String[0]));
        }
        if (name.equals(VAL_NOT_AFTER)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_AFTER", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (value == null || value.equals("")) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_NOT_BEFORE)) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            ParsePosition pos = new ParsePosition(0);
            Date date = formatter.parse(value, pos);
            CertificateValidity validity = null;
            try {
                validity = (CertificateValidity)info.get("validity");
                validity.set(VAL_NOT_BEFORE, (Object)date);
            }
            catch (Exception e) {
                logger.error("ValidityDefault: setValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        } else if (name.equals(VAL_NOT_AFTER)) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            ParsePosition pos = new ParsePosition(0);
            Date date = formatter.parse(value, pos);
            CertificateValidity validity = null;
            try {
                validity = (CertificateValidity)info.get("validity");
                validity.set(VAL_NOT_AFTER, (Object)date);
            }
            catch (Exception e) {
                logger.error("ValidityDefault: setValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        } else {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_NOT_BEFORE)) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            CertificateValidity validity = null;
            try {
                validity = (CertificateValidity)info.get("validity");
                return formatter.format((Date)validity.get(VAL_NOT_BEFORE));
            }
            catch (Exception e) {
                logger.error("ValidityDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException("Invalid value");
            }
        }
        if (name.equals(VAL_NOT_AFTER)) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            CertificateValidity validity = null;
            try {
                validity = (CertificateValidity)info.get("validity");
                return formatter.format((Date)validity.get(VAL_NOT_AFTER));
            }
            catch (Exception e) {
                logger.error("ValidityDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_VALIDITY", (String[])new String[]{this.getConfig(CONFIG_RANGE)});
    }

    public int convertRangeUnit(String unit) throws Exception {
        if (unit.equals("year")) {
            return 1;
        }
        if (unit.equals("month")) {
            return 2;
        }
        if (unit.equals("day") || unit.equals("")) {
            return 6;
        }
        if (unit.equals("hour")) {
            return 11;
        }
        if (unit.equals("minute")) {
            return 12;
        }
        throw new Exception("Invalid range unit: " + unit);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        int rangeUnit;
        int range;
        CAEngine engine = CAEngine.getInstance();
        String startTimeStr = this.getConfig(CONFIG_START_TIME);
        logger.debug("ValidityDefault: start time: " + startTimeStr);
        try {
            startTimeStr = this.mapPattern(request, startTimeStr);
        }
        catch (IOException e) {
            logger.warn("ValidityDefault: populate " + e.getMessage(), (Throwable)e);
        }
        if (startTimeStr == null || startTimeStr.equals("")) {
            startTimeStr = "60";
        }
        long startTime = Long.parseLong(startTimeStr);
        Date notBefore = new Date(new Date().getTime() + 1000L * startTime);
        logger.debug("ValidityDefault: not before: " + notBefore);
        String rangeStr = this.getConfig(CONFIG_RANGE, "7305");
        logger.debug("ValidityDefault: range: " + rangeStr);
        try {
            rangeStr = this.mapPattern(request, rangeStr);
            range = Integer.parseInt(rangeStr);
        }
        catch (IOException e) {
            logger.error("ValidityDefault: " + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_RANGE}));
        }
        String rangeUnitStr = this.getConfig(CONFIG_RANGE_UNIT, "day");
        logger.debug("ValidityDefault: range unit: " + rangeUnitStr);
        try {
            rangeUnit = this.convertRangeUnit(rangeUnitStr);
        }
        catch (Exception e) {
            logger.error("ValidityDefault: " + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_RANGE_UNIT}));
        }
        Calendar date = Calendar.getInstance();
        date.setTime(notBefore);
        date.add(rangeUnit, range);
        Date notAfter = date.getTime();
        logger.debug("ValidityDefault: not after: " + notAfter);
        boolean adjustValidity = request.getExtDataInBoolean("installAdjustValidity", false);
        if (adjustValidity) {
            logger.debug("ValidityDefault: populate: adjustValidity is true");
            CertificateAuthority ca = engine.getCA();
            try {
                X509CertImpl caCert = ca.getCACert();
                Date caNotAfter = caCert.getNotAfter();
                if (notAfter.after(caNotAfter)) {
                    notAfter = caNotAfter;
                    logger.debug("ValidityDefault: populate: resetting notAfter to caNotAfter");
                }
            }
            catch (Exception e) {
                throw new EProfileException("Unable to get ca certificate: " + e.getMessage(), (Throwable)e);
            }
        }
        CertificateValidity validity = new CertificateValidity(notBefore, notAfter);
        try {
            info.set("validity", (Object)validity);
        }
        catch (Exception e) {
            logger.error("ValidityDefault: populate " + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_INVALID_PROPERTY", (String[])new String[]{"validity"}));
        }
    }
}

