/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.selftests;

import com.netscape.certsrv.logging.LogEventListener;
import com.netscape.certsrv.selftests.EDuplicateSelfTestException;
import com.netscape.certsrv.selftests.EInvalidSelfTestException;
import com.netscape.certsrv.selftests.EMissingSelfTestException;
import com.netscape.certsrv.selftests.ESelfTestException;
import com.netscape.cms.selftests.SelfTestPluginConfig;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.selftests.SelfTestSubsystem;
import java.util.Locale;

public abstract class SelfTest {
    public static final String PROP_PLUGIN = "plugin";
    private static final String SELF_TEST_NAME = "SelfTest";
    protected CMSEngine engine;
    protected SelfTestSubsystem mSelfTestSubsystem;
    protected String mInstanceName = null;
    protected SelfTestPluginConfig mConfig;
    protected String mPrefix = null;

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public void initSelfTest(SelfTestSubsystem subsystem, String instanceName, ConfigStore parameters) throws EDuplicateSelfTestException, EInvalidSelfTestException, EMissingSelfTestException {
        this.mSelfTestSubsystem = subsystem;
        if (instanceName == null) {
            this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage("SELFTESTS_PARAMETER_WAS_NULL", SELF_TEST_NAME));
            throw new EMissingSelfTestException();
        }
        instanceName = instanceName.trim();
        this.mInstanceName = instanceName;
        String pluginPath = "plugin." + instanceName;
        this.mConfig = parameters.getSubStore(pluginPath, SelfTestPluginConfig.class);
        if (this.mConfig == null || this.mConfig.getName() == null || this.mConfig.getName() == "") {
            this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage("SELFTESTS_PARAMETER_WAS_NULL", SELF_TEST_NAME));
            throw new EMissingSelfTestException();
        }
        this.mPrefix = this.mConfig.getName().trim();
    }

    public abstract void startupSelfTest() throws ESelfTestException;

    public abstract void shutdownSelfTest();

    public String getSelfTestName() {
        return this.mInstanceName;
    }

    public ConfigStore getSelfTestConfigStore() {
        return this.mConfig;
    }

    public abstract String getSelfTestDescription(Locale var1);

    public abstract void runSelfTest(LogEventListener var1) throws Exception;
}

