/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFContent;
import netscape.ldap.util.LDIFModifyContent;
import netscape.ldap.util.LDIFRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPConfigurator {
    public static final Logger logger = LoggerFactory.getLogger(LDAPConfigurator.class);
    LDAPConnection connection;
    LDAPConfig config;
    String instanceID;
    Map<String, String> params = new HashMap<String, String>();

    public LDAPConfigurator(LDAPConnection connection, LDAPConfig config) throws Exception {
        this.connection = connection;
        this.config = config;
        String baseDN = config.getBaseDN();
        this.params.put("rootSuffix", baseDN);
        String database = config.getDatabase();
        this.params.put("database", database);
    }

    public LDAPConfigurator(LDAPConnection connection, LDAPConfig config, String instanceID) throws Exception {
        this(connection, config);
        this.instanceID = instanceID;
        this.params.put("instanceId", instanceID);
    }

    public LDAPConnection getConnection() {
        return this.connection;
    }

    public Map<String, String> getParams() throws Exception {
        return this.params;
    }

    public void initDatabase() throws Exception {
        logger.info("Initialize database");
        this.importLDIF("/usr/share/pki/server/database/ds/config.ldif", true);
    }

    public void setupSchema() throws Exception {
        logger.info("Setting up PKI schema");
        this.importSchemaFile("/usr/share/pki/server/database/ds/schema.ldif");
    }

    public void createContainers(String subsystem) throws Exception {
        logger.info("Creating container entries");
        this.importLDIF("/usr/share/pki/" + subsystem + "/database/ds/create.ldif", true);
    }

    public void setupACL(String subsystem) throws Exception {
        logger.info("Setting up ACL");
        this.importLDIF("/usr/share/pki/" + subsystem + "/database/ds/acl.ldif", true);
    }

    public void createIndexes(String subsystem) throws Exception {
        logger.info("Creating indexes");
        this.importLDIF("/usr/share/pki/" + subsystem + "/database/ds/index.ldif", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildIndexes(String subsystem) throws Exception {
        logger.info("Rebuilding indexes");
        File file = new File("/usr/share/pki/" + subsystem + "/database/ds/indextasks.ldif");
        File tmpFile = File.createTempFile("pki-" + subsystem + "-reindex-", ".ldif");
        try {
            this.customizeFile(file, tmpFile, this.params);
            LDIF ldif = new LDIF(tmpFile.getAbsolutePath());
            LDIFRecord record = ldif.nextRecord();
            if (record == null) {
                return;
            }
            this.importLDIFRecord(record, false);
            String dn = record.getDN();
            this.waitForTask(dn);
        }
        finally {
            tmpFile.delete();
        }
    }

    public void grantDatabaseAccess(String dn) throws Exception {
        logger.info("Granting database access to " + dn);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dbuser", dn);
        this.importLDIF("/usr/share/pki/server/database/ds/db-access-grant.ldif", true, params);
    }

    public void revokeDatbaseAccess(String dn) throws Exception {
        logger.info("Revoking database access from " + dn);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dbuser", dn);
        this.importLDIF("/usr/share/pki/server/database/ds/db-access-revoke.ldif", true, params);
    }

    public List<LDAPEntry> findVLVs() throws Exception {
        String database = this.config.getDatabase();
        String baseDN = "cn=" + database + ",cn=ldbm database,cn=plugins,cn=config";
        logger.info("Searching " + baseDN);
        LDAPSearchResults results = this.connection.search(baseDN, 2, "(|(objectClass=vlvSearch)(objectClass=vlvIndex))", null, false);
        ArrayList<LDAPEntry> entries = new ArrayList<LDAPEntry>();
        while (results.hasMoreElements()) {
            LDAPEntry entry = results.next();
            entries.add(entry);
        }
        return entries;
    }

    public void addVLVs(String subsystem) throws Exception {
        logger.info("Add VLVs");
        this.importLDIF("/usr/share/pki/" + subsystem + "/database/ds/vlv.ldif", true);
    }

    public void deleteVLVs() throws Exception {
        List<LDAPEntry> entries = this.findVLVs();
        Collections.reverse(entries);
        logger.info("Delete VLVs");
        for (LDAPEntry entry : entries) {
            String dn = entry.getDN();
            logger.info("Deleting " + dn);
            this.connection.delete(dn);
        }
    }

    public void reindexVLVs(String subsystem) throws Exception {
        logger.info("Reindex VLVs");
        Collection<LDIFRecord> records = this.importLDIF("/usr/share/pki/" + subsystem + "/database/ds/vlvtasks.ldif", false);
        for (LDIFRecord record : records) {
            String dn = record.getDN();
            this.waitForTask(dn);
        }
    }

    public LDAPEntry getEntry(String dn) throws Exception {
        logger.info("Getting " + dn);
        try {
            return this.connection.read(dn);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 32) {
                logger.info("Entry not found: " + dn);
                return null;
            }
            String message = "Unable to get " + dn + ": " + e;
            logger.error(message);
            throw new Exception(message, e);
        }
    }

    public void validateDatabaseOwnership(String database, String baseDN) throws Exception {
        logger.info("Validating database " + database + " is owned by " + baseDN);
        LDAPSearchResults res = this.connection.search("cn=mapping tree, cn=config", 1, "(nsslapd-backend=" + LDAPUtil.escapeFilter((Object)database) + ")", null, false, (LDAPSearchConstraints)null);
        while (res.hasMoreElements()) {
            LDAPEntry entry = res.next();
            LDAPAttribute cn = entry.getAttribute("cn");
            String dn = cn.getStringValueArray()[0];
            if (LDAPDN.equals((String)dn, (String)baseDN)) continue;
            String message = "Database " + database + " is owned by " + dn;
            logger.error(message);
            throw new Exception(message);
        }
    }

    public void deleteEntry(String dn) throws Exception {
        try {
            LDAPSearchResults results = this.connection.search(dn, 1, "(objectClass=*)", null, true, (LDAPSearchConstraints)null);
            while (results.hasMoreElements()) {
                LDAPEntry entry = results.next();
                this.deleteEntry(entry.getDN());
            }
            logger.info("Deleting " + dn);
            this.connection.delete(dn);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 32) {
                logger.info("Entry not found: " + dn);
            }
            String message = "Unable to delete " + dn + ": " + e;
            logger.error(message);
            throw new Exception(message, e);
        }
    }

    public void waitForTask(String dn) throws Exception {
        String returnCode = null;
        int count = 0;
        int maxCount = 0;
        while (maxCount <= 0 || count < maxCount) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            logger.info("Waiting for task " + dn + " (" + ++count + "s)");
            try {
                LDAPAttribute attr;
                LDAPEntry task = this.getEntry(dn);
                if (task == null || (attr = task.getAttribute("nsTaskExitCode")) == null) continue;
                returnCode = (String)attr.getStringValues().nextElement();
                break;
            }
            catch (Exception e) {
                logger.warn("Unable to read task " + dn + ": " + e);
            }
        }
        if (returnCode == null || !"0".equals(returnCode)) {
            String message = "Task " + dn + " failed: nsTaskExitCode=" + returnCode;
            logger.error(message);
            throw new Exception(message);
        }
        logger.info("Task " + dn + " complete");
    }

    public void createDatabaseEntry(String databaseDN, String database, String baseDN) throws Exception {
        logger.info("Adding " + databaseDN);
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        attrs.add(new LDAPAttribute("objectClass", new String[]{"top", "extensibleObject", "nsBackendInstance"}));
        attrs.add(new LDAPAttribute("cn", database));
        attrs.add(new LDAPAttribute("nsslapd-suffix", baseDN));
        LDAPEntry entry = new LDAPEntry(databaseDN, attrs);
        this.connection.add(entry);
    }

    public void createMappingEntry(String mappingDN, String database, String baseDN) throws Exception {
        logger.info("Adding " + mappingDN);
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        attrs.add(new LDAPAttribute("objectClass", new String[]{"top", "extensibleObject", "nsMappingTree"}));
        attrs.add(new LDAPAttribute("cn", baseDN));
        attrs.add(new LDAPAttribute("nsslapd-backend", database));
        attrs.add(new LDAPAttribute("nsslapd-state", "Backend"));
        LDAPEntry entry = new LDAPEntry(mappingDN, attrs);
        this.connection.add(entry);
    }

    public void createBaseEntry(String baseDN) throws Exception {
        logger.info("Adding " + baseDN);
        String[] rdns = LDAPDN.explodeDN((String)baseDN, (boolean)false);
        StringTokenizer st = new StringTokenizer(rdns[0], "=");
        String name = st.nextToken();
        String value = st.nextToken();
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        String[] oc = new String[]{"top", "domain"};
        if (name.equals("o")) {
            oc[1] = "organization";
        } else if (name.equals("ou")) {
            oc[1] = "organizationalUnit";
        }
        attrs.add(new LDAPAttribute("objectClass", oc));
        attrs.add(new LDAPAttribute(name, value));
        LDAPEntry entry = new LDAPEntry(baseDN, attrs);
        this.connection.add(entry);
    }

    public void customizeFile(File file, File tmpFile, Map<String, String> params) throws Exception {
        logger.info("Creating " + tmpFile);
        try (BufferedReader in = new BufferedReader(new FileReader(file));
             PrintWriter out = new PrintWriter(new FileWriter(tmpFile));){
            String line;
            while ((line = in.readLine()) != null) {
                int start = line.indexOf("{");
                if (start == -1) {
                    out.println(line);
                    continue;
                }
                boolean eol = false;
                while (start != -1) {
                    out.print(line.substring(0, start));
                    int end = line.indexOf("}");
                    String name = line.substring(start + 1, end);
                    String value = params.get(name);
                    out.print(value);
                    if (line.length() + 1 == end) {
                        eol = true;
                        break;
                    }
                    line = line.substring(end + 1);
                    start = line.indexOf("{");
                }
                if (eol) continue;
                out.println(line);
            }
        }
    }

    public Collection<LDIFRecord> importLDIF(String filename, boolean ignoreErrors) throws Exception {
        return this.importLDIF(filename, ignoreErrors, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LDIFRecord> importLDIF(String filename, boolean ignoreErrors, Map<String, String> inputParams) throws Exception {
        logger.info("Importing " + filename);
        HashMap<String, String> params = new HashMap<String, String>(this.params);
        if (inputParams != null) {
            params.putAll(inputParams);
        }
        for (String name : params.keySet()) {
            logger.debug("- " + name + ": " + (String)params.get(name));
        }
        File file = new File(filename);
        File tmpFile = File.createTempFile("pki-import-", ".ldif");
        ArrayList<LDIFRecord> records = new ArrayList<LDIFRecord>();
        try {
            LDIFRecord record;
            this.customizeFile(file, tmpFile, params);
            LDIF ldif = new LDIF(tmpFile.getAbsolutePath());
            while ((record = ldif.nextRecord()) != null) {
                records.add(record);
                this.importLDIFRecord(record, ignoreErrors);
            }
        }
        finally {
            tmpFile.delete();
        }
        return records;
    }

    public void importLDIFRecord(LDIFRecord record, boolean ignoreErrors) throws Exception {
        String dn = record.getDN();
        LDIFContent content = record.getContent();
        int type = content.getType();
        if (type == 0) {
            logger.info("Adding " + dn);
            LDIFAttributeContent c = (LDIFAttributeContent)content;
            LDAPAttributeSet attrs = new LDAPAttributeSet();
            for (LDAPAttribute attr : c.getAttributes()) {
                attrs.add(attr);
            }
            LDAPEntry entry = new LDAPEntry(dn, attrs);
            try {
                this.connection.add(entry);
            }
            catch (LDAPException e) {
                String message = "Unable to add " + dn + ": " + e;
                if (e.getLDAPResultCode() == 68 && ignoreErrors) {
                    logger.info(message);
                }
                logger.error(message);
                throw new Exception(message, e);
            }
        } else if (type == 3) {
            LDAPModification[] mods;
            LDIFModifyContent c = (LDIFModifyContent)content;
            block10: for (LDAPModification mod : mods = c.getModifications()) {
                int operation = mod.getOp();
                LDAPAttribute attr = mod.getAttribute();
                String name = attr.getName();
                String[] values = attr.getStringValueArray();
                switch (operation) {
                    case 0: {
                        logger.info("Adding " + name + " into " + dn);
                        continue block10;
                    }
                    case 2: {
                        logger.info("Replacing " + name + " in " + dn);
                        continue block10;
                    }
                    case 1: {
                        logger.info("Deleting " + name + " from " + dn);
                    }
                }
            }
            try {
                this.connection.modify(dn, mods);
            }
            catch (LDAPException e) {
                String message = "Unable to modify " + dn + ": " + e;
                if (e.getLDAPResultCode() == 32 && ignoreErrors) {
                    logger.info(message);
                }
                if (e.getLDAPResultCode() == 16 && ignoreErrors) {
                    logger.info(message);
                }
                if (e.getLDAPResultCode() == 20 && ignoreErrors) {
                    logger.info(message);
                }
                logger.error(message);
                throw new Exception(message, e);
            }
        }
    }

    public void importSchemaFile(String filename) throws Exception {
        LDIFRecord record;
        logger.info("Importing " + filename);
        LDIF ldif = new LDIF(filename);
        while ((record = ldif.nextRecord()) != null) {
            this.importSchemaRecord(record);
        }
    }

    public void importSchemaRecord(LDIFRecord record) throws Exception {
        LDAPModification[] mods;
        String dn = record.getDN();
        LDIFContent content = record.getContent();
        if (!(content instanceof LDIFModifyContent)) {
            throw new Exception("Invalid record type: " + content.getClass().getSimpleName());
        }
        LDIFModifyContent c = (LDIFModifyContent)content;
        block7: for (LDAPModification mod : mods = c.getModifications()) {
            int operation = mod.getOp();
            LDAPAttribute attr = mod.getAttribute();
            String name = attr.getName();
            String[] values = attr.getStringValueArray();
            switch (operation) {
                case 0: {
                    for (String value : values) {
                        logger.info("Adding " + name + ": " + value);
                    }
                    continue block7;
                }
                case 2: {
                    for (String value : values) {
                        logger.info("Replacing " + name + ": " + value);
                    }
                    continue block7;
                }
                case 1: {
                    if (values == null) {
                        logger.info("Deleting " + name);
                        continue block7;
                    }
                    for (String value : values) {
                        logger.info("Deleting " + name + ": " + value);
                    }
                    continue block7;
                }
            }
        }
        try {
            this.connection.modify(dn, mods);
        }
        catch (LDAPException e) {
            String message = "Unable to update " + dn + ": " + e.getMessage();
            logger.error(message);
            throw new Exception(message, e);
        }
    }

    public void deleteDatabase(String database, String baseDN) throws Exception {
        String databaseDN = "cn=" + LDAPUtil.escapeRDNValue((Object)database) + ",cn=ldbm database, cn=plugins, cn=config";
        String mappingDN = "cn=\"" + baseDN + "\",cn=mapping tree, cn=config";
        logger.info("Validating database ownership");
        this.validateDatabaseOwnership(database, baseDN);
        logger.info("Deleting mapping entry " + mappingDN);
        this.deleteEntry(mappingDN);
        logger.info("Deleting database entry " + databaseDN);
        this.deleteEntry(databaseDN);
    }

    public void createSystemContainer() throws Exception {
        String dn = "ou=csusers,cn=config";
        logger.info("Adding " + dn);
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        attrs.add(new LDAPAttribute("objectclass", "top"));
        attrs.add(new LDAPAttribute("objectclass", "organizationalUnit"));
        attrs.add(new LDAPAttribute("ou", "csusers"));
        LDAPEntry entry = new LDAPEntry(dn, attrs);
        try {
            this.connection.add(entry);
        }
        catch (LDAPException e) {
            String message = "Unable to add " + dn + ": " + e.getMessage();
            if (e.getLDAPResultCode() == 68) {
                logger.info(message);
            }
            logger.error(message, (Throwable)e);
            throw e;
        }
    }

    public void createReplicationManager(String bindUser, String pwd) throws Exception {
        String dn = "cn=" + LDAPUtil.escapeRDNValue((Object)bindUser) + ",ou=csusers,cn=config";
        logger.info("Adding " + dn);
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        attrs.add(new LDAPAttribute("objectclass", "top"));
        attrs.add(new LDAPAttribute("objectclass", "person"));
        attrs.add(new LDAPAttribute("userpassword", pwd));
        attrs.add(new LDAPAttribute("cn", bindUser));
        attrs.add(new LDAPAttribute("sn", "manager"));
        LDAPEntry entry = new LDAPEntry(dn, attrs);
        try {
            this.connection.add(entry);
            return;
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() != 68) {
                logger.error("Unable to add " + dn + ": " + e.getMessage(), (Throwable)e);
                throw e;
            }
            logger.warn("Replication manager already exists: " + dn);
            logger.warn("Deleting existing replication manager: " + dn);
            try {
                this.connection.delete(dn);
            }
            catch (LDAPException e2) {
                logger.error("Unable to delete " + dn + ": " + e2.getMessage());
                throw e2;
            }
            logger.warn("Adding new replication manager: " + dn);
            try {
                this.connection.add(entry);
            }
            catch (LDAPException e3) {
                logger.error("Unable to add " + dn + ": " + e3.getMessage());
                throw e3;
            }
            return;
        }
    }

    public String getInstanceDir() throws Exception {
        String baseDN = "cn=config,cn=ldbm database,cn=plugins,cn=config";
        logger.info("Searching for nsslapd-directory in " + baseDN);
        String filter = "(objectclass=*)";
        String[] attrNames = new String[]{"nsslapd-directory"};
        LDAPSearchResults results = this.connection.search(baseDN, 2, filter, attrNames, false);
        while (results.hasMoreElements()) {
            LDAPEntry entry = results.next();
            String dn = entry.getDN();
            logger.debug("Checking " + dn);
            LDAPAttributeSet attrSet = entry.getAttributeSet();
            Enumeration attrs = attrSet.getAttributes();
            while (attrs.hasMoreElements()) {
                LDAPAttribute attr = (LDAPAttribute)attrs.nextElement();
                String name = attr.getName();
                Enumeration values = attr.getStringValues();
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    logger.debug("- " + name + ": " + value);
                    if (!name.equalsIgnoreCase("nsslapd-directory")) continue;
                    return value.substring(0, value.lastIndexOf("/db"));
                }
            }
        }
        return "";
    }

    public void createChangeLog() throws Exception {
        Object dn = "cn=changelog5,cn=config";
        logger.info("Adding " + (String)dn);
        String dir = this.getInstanceDir() + "/changelogs";
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        attrs.add(new LDAPAttribute("objectClass", "top"));
        attrs.add(new LDAPAttribute("objectClass", "extensibleObject"));
        attrs.add(new LDAPAttribute("cn", "changelog5"));
        attrs.add(new LDAPAttribute("nsslapd-changelogdir", dir));
        LDAPEntry entry = new LDAPEntry((String)dn, attrs);
        try {
            this.connection.add(entry);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 68) {
                logger.warn("Changelog already exists: " + (String)dn);
            }
            if (e.getLDAPResultCode() == 53) {
                dn = "cn=changelog,cn=" + this.config.getDatabase() + ",cn=ldbm database,cn=plugins,cn=config";
                logger.warn("Changelog has moved to " + (String)dn);
            }
            logger.error("Unable to add " + (String)dn + ": " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean createReplicaObject(String bindUser, int id) throws Exception {
        String baseDN = this.config.getBaseDN();
        String replicaDN = "cn=replica,cn=\"" + baseDN + "\",cn=mapping tree,cn=config";
        String bindDN = "cn=" + LDAPUtil.escapeRDNValue((Object)bindUser) + ",ou=csusers,cn=config";
        logger.info("Adding " + replicaDN);
        logger.debug("- nsDS5ReplicaRoot: " + baseDN);
        logger.debug("- nsDS5ReplicaBindDN: " + bindDN);
        logger.debug("- nsDS5ReplicaId: " + id);
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        attrs.add(new LDAPAttribute("objectclass", "top"));
        attrs.add(new LDAPAttribute("objectclass", "nsDS5Replica"));
        attrs.add(new LDAPAttribute("objectclass", "extensibleobject"));
        attrs.add(new LDAPAttribute("cn", "replica"));
        attrs.add(new LDAPAttribute("nsDS5ReplicaRoot", baseDN));
        attrs.add(new LDAPAttribute("nsDS5ReplicaType", "3"));
        attrs.add(new LDAPAttribute("nsDS5ReplicaBindDN", bindDN));
        attrs.add(new LDAPAttribute("nsDS5ReplicaId", Integer.toString(id)));
        attrs.add(new LDAPAttribute("nsds5flags", "1"));
        LDAPEntry entry = new LDAPEntry(replicaDN, attrs);
        try {
            this.connection.add(entry);
            return true;
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() != 68) {
                logger.error("Unable to add " + replicaDN + ": " + e.getMessage(), (Throwable)e);
                throw e;
            }
            logger.warn("Replica object already exists: " + replicaDN);
            logger.info("Adding replica bind DN");
            entry = this.connection.read(replicaDN);
            LDAPAttribute attr = entry.getAttribute("nsDS5ReplicaBindDN");
            attr.addValue(bindDN);
            LDAPModification mod = new LDAPModification(2, attr);
            try {
                this.connection.modify(replicaDN, mod);
            }
            catch (LDAPException e2) {
                if (e2.getLDAPResultCode() != 20) {
                    logger.error("Unable to add " + bindDN + ": " + e2.getMessage(), (Throwable)e2);
                    throw e2;
                }
                logger.warn("Replica bind DN already exists: " + bindDN);
            }
            return false;
        }
    }

    public void createReplicationAgreement(String name, String replicaHostname, int replicaPort, String bindUser, String replicaPassword, String replicationSecurity) throws Exception {
        String baseDN = this.config.getBaseDN();
        String replicaDN = "cn=replica,cn=\"" + baseDN + "\",cn=mapping tree,cn=config";
        String dn = "cn=" + LDAPUtil.escapeRDNValue((Object)name) + "," + replicaDN;
        String bindDN = "cn=" + LDAPUtil.escapeRDNValue((Object)bindUser) + ",ou=csusers,cn=config";
        logger.info("Adding " + dn);
        logger.debug("- description: " + name);
        logger.debug("- nsDS5ReplicaRoot: " + baseDN);
        logger.debug("- nsDS5ReplicaHost: " + replicaHostname);
        logger.debug("- nsDS5ReplicaPort: " + replicaPort);
        logger.debug("- nsDS5ReplicaBindDN: " + bindDN);
        logger.debug("- nsDS5ReplicaTransportInfo: " + replicationSecurity);
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        attrs.add(new LDAPAttribute("objectclass", "top"));
        attrs.add(new LDAPAttribute("objectclass", "nsds5replicationagreement"));
        attrs.add(new LDAPAttribute("cn", name));
        attrs.add(new LDAPAttribute("description", name));
        attrs.add(new LDAPAttribute("nsDS5ReplicaRoot", baseDN));
        attrs.add(new LDAPAttribute("nsDS5ReplicaHost", replicaHostname));
        attrs.add(new LDAPAttribute("nsDS5ReplicaPort", "" + replicaPort));
        attrs.add(new LDAPAttribute("nsDS5ReplicaBindDN", bindDN));
        attrs.add(new LDAPAttribute("nsDS5ReplicaBindMethod", "Simple"));
        attrs.add(new LDAPAttribute("nsds5replicacredentials", replicaPassword));
        if (replicationSecurity != null && !replicationSecurity.equalsIgnoreCase("None")) {
            attrs.add(new LDAPAttribute("nsDS5ReplicaTransportInfo", replicationSecurity));
        }
        LDAPEntry entry = new LDAPEntry(dn, attrs);
        try {
            this.connection.add(entry);
            return;
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() != 68) {
                logger.error("Unable to add " + dn + ": " + e.getMessage(), (Throwable)e);
                throw e;
            }
            logger.warn("Replication agreement already exists: " + dn);
            logger.warn("Removing existing replication agreement: " + dn);
            try {
                this.connection.delete(dn);
            }
            catch (LDAPException e2) {
                logger.error("Unable to delete " + dn + ": " + e2.getMessage(), (Throwable)e2);
                throw e2;
            }
            logger.warn("Adding new replication agreement: " + dn);
            try {
                this.connection.add(entry);
            }
            catch (LDAPException e3) {
                logger.error("Unable to add " + dn + ": " + e3.getMessage(), (Throwable)e3);
                throw e3;
            }
            return;
        }
    }

    public boolean setupReplicationAgreement(String agreementName, String bindUser, String bindPassword, String peerHostname, int peerPort, String peerBindUser, String peerBindPassword, String security, int replicaID) throws Exception {
        this.createSystemContainer();
        this.createReplicationManager(bindUser, bindPassword);
        this.createChangeLog();
        boolean created = this.createReplicaObject(bindUser, replicaID);
        this.createReplicationAgreement(agreementName, peerHostname, peerPort, peerBindUser, peerBindPassword, security);
        return created;
    }

    public void initializeConsumer(String agreementName) throws Exception {
        String baseDN = this.config.getBaseDN();
        String replicaDN = "cn=replica,cn=\"" + baseDN + "\",cn=mapping tree,cn=config";
        String dn = "cn=" + LDAPUtil.escapeRDNValue((Object)agreementName) + "," + replicaDN;
        logger.info("Initializing consumer " + dn);
        LDAPAttribute attr = new LDAPAttribute("nsds5beginreplicarefresh", "start");
        LDAPModification mod = new LDAPModification(2, attr);
        this.connection.modify(dn, mod);
        while (!this.isReplicationDone(replicaDN, agreementName)) {
            Thread.sleep(1000L);
        }
        String status = this.getReplicationStatus(replicaDN, agreementName);
        if (!status.startsWith("Error (0) ") && !status.startsWith("0 ")) {
            String message = "Replication consumer initialization failed (against " + this.connection.getHost() + ":" + this.connection.getPort() + "): " + status;
            logger.error(message);
            throw new Exception(message);
        }
    }

    public boolean isReplicationDone(String replicaDN, String agreementName) throws Exception {
        String dn = "cn=" + LDAPUtil.escapeRDNValue((Object)agreementName) + "," + replicaDN;
        logger.info("Checking " + dn);
        String filter = "(objectclass=*)";
        String[] attrs = new String[]{"nsds5beginreplicarefresh"};
        LDAPSearchResults results = this.connection.search(dn, 0, filter, attrs, true);
        int count = results.getCount();
        if (count < 1) {
            throw new Exception("Entry not found: " + dn);
        }
        LDAPEntry entry = results.next();
        LDAPAttribute refresh = entry.getAttribute("nsds5beginreplicarefresh");
        if (refresh != null) {
            String name = refresh.getName();
            for (String value : refresh.getStringValueArray()) {
                logger.debug("- " + name + ": " + value);
            }
            return false;
        }
        return true;
    }

    public String getReplicationStatus(String replicaDN, String agreementName) throws Exception {
        String dn = "cn=" + LDAPUtil.escapeRDNValue((Object)agreementName) + "," + replicaDN;
        logger.info("Checking " + dn);
        String filter = "(objectclass=*)";
        String[] attrNames = new String[]{"nsds5replicalastinitstatus"};
        LDAPSearchResults results = this.connection.search(dn, 0, filter, attrNames, false);
        int count = results.getCount();
        if (count < 1) {
            throw new Exception("Entry not found: " + dn);
        }
        LDAPEntry entry = results.next();
        LDAPAttribute attr = entry.getAttribute("nsds5replicalastinitstatus");
        if (attr == null) {
            throw new Exception("Attribute not found: nsDS5ReplicaLastInitStatus");
        }
        Enumeration attrs = attr.getStringValues();
        if (!attrs.hasMoreElements()) {
            throw new Exception("Attribute value not found: nsds5replicalastinitstatus");
        }
        String status = (String)attrs.nextElement();
        logger.debug("- nsds5replicalastinitstatus: " + status);
        return status;
    }
}

