/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.EDBException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X500NameMapper
extends DBAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(X500NameMapper.class);
    private String mLdapName = null;
    private Vector<String> v = new Vector();

    public X500NameMapper(String ldapName) {
        this.mLdapName = ldapName;
        this.v.addElement(this.mLdapName);
    }

    @Override
    public Enumeration<String> getSupportedLDAPAttributeNames() {
        return this.v.elements();
    }

    @Override
    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        if (obj == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_DBS_SERIALIZE_FAILED", name));
        }
        logger.debug("X500NameMapper: Mapping " + name + " to " + this.mLdapName);
        attrs.add(new LDAPAttribute(this.mLdapName, obj.toString()));
    }

    @Override
    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        LDAPAttribute attr = attrs.getAttribute(this.mLdapName);
        if (attr == null) {
            return;
        }
        try {
            parent.set(name, new X500Name((String)attr.getStringValues().nextElement()));
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSCORE_DBS_X500NAME_MAPPER_ERROR", e.toString()), (Throwable)e);
            throw new EDBException(CMS.getUserMessage("CMS_DBS_DESERIALIZE_FAILED", name), (Throwable)e);
        }
    }

    @Override
    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        return this.mLdapName + op + value;
    }
}

