"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeAPI = void 0;
var exceptions_1 = require("./exceptions");
var logs_1 = require("./logs");
var measurements_1 = require("./measurements");
var initialize_1 = require("./meta/initialize");
var traces_1 = require("./traces");
function initializeAPI(config, transports, metas) {
    var tracesApi = (0, traces_1.initializeTracesAPI)(transports, metas);
    return __assign(__assign(__assign(__assign(__assign({}, tracesApi), (0, exceptions_1.initializeExceptionsAPI)(config, transports, metas, tracesApi)), (0, initialize_1.initializeMetaAPI)(transports, metas)), (0, logs_1.initializeLogsAPI)(transports, metas, tracesApi)), (0, measurements_1.initializeMeasurementsAPI)(transports, metas, tracesApi));
}
exports.initializeAPI = initializeAPI;
//# sourceMappingURL=initialize.js.map