"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const loaders_1 = require("./loaders");
describe('Loaders', () => {
    describe('stylesheet helpers', () => {
        beforeEach(() => {
            jest.spyOn(console, 'log').mockImplementation();
        });
        afterEach(() => {
            jest.restoreAllMocks();
        });
        describe('getStylesheetEntries', () => {
            it('returns entries for dark and light theme', () => {
                const result = (0, loaders_1.getStylesheetEntries)(`${__dirname}/../mocks/stylesheetsSupport/ok`);
                expect(Object.keys(result)).toHaveLength(2);
            });
            it('throws on theme files duplicates', () => {
                const result = () => {
                    (0, loaders_1.getStylesheetEntries)(`${__dirname}/../mocks/stylesheetsSupport/duplicates`);
                };
                expect(result).toThrow();
            });
        });
    });
});
//# sourceMappingURL=loaders.test.js.map