/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.PolicyQualifierInfo;

public class PolicyQualifiers
implements Serializable {
    private static final long serialVersionUID = 6932694408774694516L;
    private Vector<PolicyQualifierInfo> mInfo = new Vector();

    public PolicyQualifiers() {
    }

    public PolicyQualifiers(DerValue val) throws IOException {
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for PolicyQualifiers.");
        }
        while (val.data.available() != 0) {
            DerValue pq = val.data.getDerValue();
            PolicyQualifierInfo info = new PolicyQualifierInfo(pq);
            this.add(info);
        }
    }

    public void add(PolicyQualifierInfo info) {
        this.mInfo.addElement(info);
    }

    public int size() {
        return this.mInfo.size();
    }

    public PolicyQualifierInfo getInfoAt(int i) {
        return this.mInfo.elementAt(i);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("PolicyQualifiers: [");
        for (int i = 0; i < this.mInfo.size(); ++i) {
            PolicyQualifierInfo pq = this.mInfo.elementAt(i);
            s.append(pq.toString());
        }
        s.append("]\n");
        return s.toString();
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        for (int i = 0; i < this.mInfo.size(); ++i) {
            PolicyQualifierInfo pq = this.mInfo.elementAt(i);
            pq.encode(tmp);
        }
        out.write((byte)48, tmp);
    }
}

