"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerOnunhandledrejection = void 0;
var agent_core_1 = require("@grafana/agent-core");
var const_1 = require("./const");
var getErrorDetails_1 = require("./getErrorDetails");
function registerOnunhandledrejection(agent) {
    window.addEventListener('unhandledrejection', function (event) {
        var _a;
        var _b, _c;
        var error = event;
        if (error.reason) {
            error = event.reason;
        }
        else if ((_b = event.detail) === null || _b === void 0 ? void 0 : _b.reason) {
            error = (_c = event.detail) === null || _c === void 0 ? void 0 : _c.reason;
        }
        var value;
        var type;
        if ((0, agent_core_1.isPrimitive)(error)) {
            value = "".concat(const_1.primitiveUnhandledValue, " ").concat(String(error));
            type = const_1.primitiveUnhandledType;
        }
        else {
            _a = (0, getErrorDetails_1.getErrorDetails)(error), value = _a[0], type = _a[1];
        }
        if (value) {
            agent.api.pushError(new Error(value), { type: type });
        }
    });
}
exports.registerOnunhandledrejection = registerOnunhandledrejection;
//# sourceMappingURL=registerOnunhandledrejection.js.map