var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import * as monaco from "monaco-editor/esm/vs/editor/editor.api";
import * as PropTypes from "prop-types";
import * as React from "react";
import { noop, processSize } from "./utils";
var MonacoDiffEditor = /** @class */ (function (_super) {
    __extends(MonacoDiffEditor, _super);
    function MonacoDiffEditor(props) {
        var _this = _super.call(this, props) || this;
        _this.assignRef = function (component) {
            _this.containerElement = component;
        };
        _this.containerElement = undefined;
        return _this;
    }
    MonacoDiffEditor.prototype.componentDidMount = function () {
        this.initMonaco();
    };
    MonacoDiffEditor.prototype.componentDidUpdate = function (prevProps) {
        var _a = this.props, language = _a.language, theme = _a.theme, height = _a.height, options = _a.options, width = _a.width, className = _a.className;
        var _b = this.editor.getModel(), original = _b.original, modified = _b.modified;
        if (this.props.original !== original.getValue()) {
            original.setValue(this.props.original);
        }
        if (this.props.value != null && this.props.value !== modified.getValue()) {
            this.__prevent_trigger_change_event = true;
            // modifiedEditor is not in the public API for diff editors
            this.editor.getModifiedEditor().pushUndoStop();
            // pushEditOperations says it expects a cursorComputer, but doesn't seem to need one.
            // @ts-expect-error
            modified.pushEditOperations([], [
                {
                    range: modified.getFullModelRange(),
                    text: this.props.value,
                },
            ]);
            // modifiedEditor is not in the public API for diff editors
            this.editor.getModifiedEditor().pushUndoStop();
            this.__prevent_trigger_change_event = false;
        }
        if (prevProps.language !== language) {
            monaco.editor.setModelLanguage(original, language);
            monaco.editor.setModelLanguage(modified, language);
        }
        if (prevProps.theme !== theme) {
            monaco.editor.setTheme(theme);
        }
        if (this.editor &&
            (width !== prevProps.width || height !== prevProps.height)) {
            this.editor.layout();
        }
        if (prevProps.options !== options) {
            this.editor.updateOptions(__assign(__assign({}, (className ? { extraEditorClassName: className } : {})), options));
        }
    };
    MonacoDiffEditor.prototype.componentWillUnmount = function () {
        this.destroyMonaco();
    };
    MonacoDiffEditor.prototype.editorWillMount = function () {
        var editorWillMount = this.props.editorWillMount;
        var options = editorWillMount(monaco);
        return options || {};
    };
    MonacoDiffEditor.prototype.editorDidMount = function (editor) {
        var _this = this;
        this.props.editorDidMount(editor, monaco);
        var modified = editor.getModel().modified;
        this._subscription = modified.onDidChangeContent(function (event) {
            if (!_this.__prevent_trigger_change_event) {
                _this.props.onChange(modified.getValue(), event);
            }
        });
    };
    MonacoDiffEditor.prototype.editorWillUnmount = function (editor) {
        var editorWillUnmount = this.props.editorWillUnmount;
        editorWillUnmount(editor, monaco);
    };
    MonacoDiffEditor.prototype.initModels = function (value, original) {
        var language = this.props.language;
        var originalModel = monaco.editor.createModel(original, language);
        var modifiedModel = monaco.editor.createModel(value, language);
        this.editor.setModel({
            original: originalModel,
            modified: modifiedModel,
        });
    };
    MonacoDiffEditor.prototype.initMonaco = function () {
        var value = this.props.value != null ? this.props.value : this.props.defaultValue;
        var _a = this.props, original = _a.original, theme = _a.theme, options = _a.options, overrideServices = _a.overrideServices, className = _a.className;
        if (this.containerElement) {
            // Before initializing monaco editor
            this.editorWillMount();
            this.editor = monaco.editor.createDiffEditor(this.containerElement, __assign(__assign(__assign({}, (className ? { extraEditorClassName: className } : {})), options), (theme ? { theme: theme } : {})), overrideServices);
            // After initializing monaco editor
            this.initModels(value, original);
            this.editorDidMount(this.editor);
        }
    };
    MonacoDiffEditor.prototype.destroyMonaco = function () {
        if (this.editor) {
            this.editorWillUnmount(this.editor);
            this.editor.dispose();
            var _a = this.editor.getModel(), original = _a.original, modified = _a.modified;
            if (original) {
                original.dispose();
            }
            if (modified) {
                modified.dispose();
            }
        }
        if (this._subscription) {
            this._subscription.dispose();
        }
    };
    MonacoDiffEditor.prototype.render = function () {
        var _a = this.props, width = _a.width, height = _a.height;
        var fixedWidth = processSize(width);
        var fixedHeight = processSize(height);
        var style = {
            width: fixedWidth,
            height: fixedHeight,
        };
        return (React.createElement("div", { ref: this.assignRef, style: style, className: "react-monaco-editor-container" }));
    };
    MonacoDiffEditor.propTypes = {
        width: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
        height: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
        original: PropTypes.string,
        value: PropTypes.string,
        defaultValue: PropTypes.string,
        language: PropTypes.string,
        theme: PropTypes.string,
        options: PropTypes.object,
        overrideServices: PropTypes.object,
        editorWillMount: PropTypes.func,
        editorDidMount: PropTypes.func,
        editorWillUnmount: PropTypes.func,
        onChange: PropTypes.func,
        className: PropTypes.string,
    };
    MonacoDiffEditor.defaultProps = {
        width: "100%",
        height: "100%",
        original: null,
        value: null,
        defaultValue: "",
        language: "javascript",
        theme: null,
        options: {},
        overrideServices: {},
        editorWillMount: noop,
        editorDidMount: noop,
        editorWillUnmount: noop,
        onChange: noop,
        className: null,
    };
    return MonacoDiffEditor;
}(React.Component));
export default MonacoDiffEditor;
//# sourceMappingURL=diff.js.map