/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.extensions;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;

public class KerberosName {
    public static final int[] OID = new int[]{1, 3, 6, 1, 5, 2, 2};
    public static final ObjectIdentifier KRB5_PRINCIPAL_NAME = new ObjectIdentifier(OID);
    private String m_realm = null;
    private int m_name_type = 0;
    private Vector<String> m_name_strings = null;

    public KerberosName(String realm, int name_type, Vector<String> name_strings) {
        this.m_realm = realm;
        this.m_name_type = name_type;
        this.m_name_strings = name_strings;
    }

    public void encode(OutputStream out) throws IOException {
        try (DerOutputStream seq = new DerOutputStream();){
            DerOutputStream tmp = new DerOutputStream();
            DerOutputStream realm = new DerOutputStream();
            realm.putGeneralString(this.m_realm);
            tmp.write(DerValue.createTag((byte)-128, true, (byte)0), realm);
            DerOutputStream seq1 = new DerOutputStream();
            DerOutputStream tmp1 = new DerOutputStream();
            DerOutputStream name_type = new DerOutputStream();
            name_type.putInteger(new BigInt(this.m_name_type));
            tmp1.write(DerValue.createTag((byte)-128, true, (byte)0), name_type);
            DerOutputStream name_strings = new DerOutputStream();
            DerOutputStream name_string = new DerOutputStream();
            for (int i = 0; i < this.m_name_strings.size(); ++i) {
                name_string.putGeneralString(this.m_name_strings.elementAt(i));
            }
            name_strings.write((byte)48, name_string);
            tmp1.write(DerValue.createTag((byte)-128, true, (byte)1), name_strings);
            seq1.write((byte)48, tmp1);
            tmp.write(DerValue.createTag((byte)-128, true, (byte)1), seq1);
            seq.write((byte)48, tmp);
            out.write(seq.toByteArray());
        }
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.encode(bos);
        return bos.toByteArray();
    }

    public String toString() {
        Object strings = null;
        for (int i = 0; i < this.m_name_strings.size(); ++i) {
            if (strings == null) {
                strings = this.m_name_strings.elementAt(i);
                continue;
            }
            strings = strings + ",";
            strings = (String)strings + this.m_name_strings.elementAt(i);
        }
        return "Realm: " + this.m_realm + " Name Type: " + this.m_name_type + " Name String(s):" + (String)strings;
    }

    public static void main(String[] argv) {
        Vector<String> strings = new Vector<String>();
        strings.addElement("name");
        KerberosName k = new KerberosName("realm", 0, strings);
        System.out.println(k.toString());
        try {
            FileOutputStream os = new FileOutputStream("/tmp/out.der");
            k.encode(os);
            os.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

