; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-none-linux-gnu -mattr=+neon,+sve | FileCheck %s

define <2 x i64> @shr64x2(<2 x i64> %a, i64 %b) {
; CHECK-LABEL: shr64x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.2d, x0
; CHECK-NEXT:    sshl v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i64 0, %b
  %splat.splatinsert = insertelement <2 x i64> poison, i64 %sub, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> poison, <2 x i32> zeroinitializer
  %shr = ashr <2 x i64> %a, %splat.splat
  ret <2 x i64> %shr
}

define <4 x i32> @shr32x4(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: shr32x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.4s, w0
; CHECK-NEXT:    sshl v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i32 0, %b
  %splat.splatinsert = insertelement <4 x i32> poison, i32 %sub, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> poison, <4 x i32> zeroinitializer
  %shr = ashr <4 x i32> %a, %splat.splat
  ret <4 x i32> %shr
}

define <4 x i32> @shr32x4undef(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: shr32x4undef:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.4s, w0
; CHECK-NEXT:    sshl v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i32 0, %b
  %splat.splatinsert = insertelement <4 x i32> poison, i32 %sub, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> poison, <4 x i32> <i32 undef, i32 0, i32 0, i32 0>
  %shr = ashr <4 x i32> %a, %splat.splat
  ret <4 x i32> %shr
}

define <8 x i16> @shr16x8(<8 x i16> %a, i16 %b) {
; CHECK-LABEL: shr16x8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.8h, w0
; CHECK-NEXT:    sshl v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
entry:
  %sub = sub i16 0, %b
  %0 = insertelement <8 x i16> undef, i16 %sub, i32 0
  %sh_prom = shufflevector <8 x i16> %0, <8 x i16> undef, <8 x i32> zeroinitializer
  %shr = ashr <8 x i16> %a, %sh_prom
  ret <8 x i16> %shr
}

define <16 x i8> @shr8x16(<16 x i8> %a, i8 %b) {
; CHECK-LABEL: shr8x16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.16b, w0
; CHECK-NEXT:    sshl v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %sub = sub i8 0, %b
  %0 = insertelement <16 x i8> undef, i8 %sub, i32 0
  %sh_prom = shufflevector <16 x i8> %0, <16 x i8> undef, <16 x i32> zeroinitializer
  %shr = ashr <16 x i8> %a, %sh_prom
  ret <16 x i8> %shr
}

define <1 x i64> @shr64x1(<1 x i64> %a, i64 %b) {
; CHECK-LABEL: shr64x1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov d1, x0
; CHECK-NEXT:    sshl d0, d0, d1
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i64 0, %b
  %splat.splatinsert = insertelement <1 x i64> poison, i64 %sub, i32 0
  %shr = ashr <1 x i64> %a, %splat.splatinsert
  ret <1 x i64> %shr
}

define <2 x i32> @shr32x2(<2 x i32> %a, i32 %b) {
; CHECK-LABEL: shr32x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.2s, w0
; CHECK-NEXT:    sshl v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i32 0, %b
  %splat.splatinsert = insertelement <2 x i32> poison, i32 %sub, i32 0
  %splat.splat = shufflevector <2 x i32> %splat.splatinsert, <2 x i32> poison, <2 x i32> zeroinitializer
  %shr = ashr <2 x i32> %a, %splat.splat
  ret <2 x i32> %shr
}

define <4 x i16> @shr16x4(<4 x i16> %a, i16 %b) {
; CHECK-LABEL: shr16x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.4h, w0
; CHECK-NEXT:    sshl v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
entry:
  %sub = sub i16 0, %b
  %0 = insertelement <4 x i16> undef, i16 %sub, i32 0
  %sh_prom = shufflevector <4 x i16> %0, <4 x i16> undef, <4 x i32> zeroinitializer
  %shr = ashr <4 x i16> %a, %sh_prom
  ret <4 x i16> %shr
}

define <8 x i8> @shr8x8(<8 x i8> %a, i8 %b) {
; CHECK-LABEL: shr8x8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.8b, w0
; CHECK-NEXT:    sshl v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %sub = sub i8 0, %b
  %0 = insertelement <8 x i8> undef, i8 %sub, i32 0
  %sh_prom = shufflevector <8 x i8> %0, <8 x i8> undef, <8 x i32> zeroinitializer
  %shr = ashr <8 x i8> %a, %sh_prom
  ret <8 x i8> %shr
}

define <2 x i64> @lshr64x2(<2 x i64> %a, i64 %b) {
; CHECK-LABEL: lshr64x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.2d, x0
; CHECK-NEXT:    ushl v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i64 0, %b
  %splat.splatinsert = insertelement <2 x i64> poison, i64 %sub, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> poison, <2 x i32> zeroinitializer
  %shr = lshr <2 x i64> %a, %splat.splat
  ret <2 x i64> %shr
}

define <4 x i32> @lshr32x4(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: lshr32x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.4s, w0
; CHECK-NEXT:    ushl v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i32 0, %b
  %splat.splatinsert = insertelement <4 x i32> poison, i32 %sub, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> poison, <4 x i32> zeroinitializer
  %shr = lshr <4 x i32> %a, %splat.splat
  ret <4 x i32> %shr
}

define <4 x i32> @lshr32x4undef(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: lshr32x4undef:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.4s, w0
; CHECK-NEXT:    ushl v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i32 0, %b
  %splat.splatinsert = insertelement <4 x i32> poison, i32 %sub, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> poison, <4 x i32> <i32 undef, i32 0, i32 0, i32 0>
  %shr = lshr <4 x i32> %a, %splat.splat
  ret <4 x i32> %shr
}

define <8 x i16> @lshr16x8(<8 x i16> %a, i16 %b) {
; CHECK-LABEL: lshr16x8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.8h, w0
; CHECK-NEXT:    ushl v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
entry:
  %sub = sub i16 0, %b
  %0 = insertelement <8 x i16> undef, i16 %sub, i32 0
  %sh_prom = shufflevector <8 x i16> %0, <8 x i16> undef, <8 x i32> zeroinitializer
  %shr = lshr <8 x i16> %a, %sh_prom
  ret <8 x i16> %shr
}

define <16 x i8> @lshr8x16(<16 x i8> %a, i8 %b) {
; CHECK-LABEL: lshr8x16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.16b, w0
; CHECK-NEXT:    ushl v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %sub = sub i8 0, %b
  %0 = insertelement <16 x i8> undef, i8 %sub, i32 0
  %sh_prom = shufflevector <16 x i8> %0, <16 x i8> undef, <16 x i32> zeroinitializer
  %shr = lshr <16 x i8> %a, %sh_prom
  ret <16 x i8> %shr
}

define <1 x i64> @lshr64x1(<1 x i64> %a, i64 %b) {
; CHECK-LABEL: lshr64x1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov d1, x0
; CHECK-NEXT:    ushl d0, d0, d1
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i64 0, %b
  %splat.splatinsert = insertelement <1 x i64> poison, i64 %sub, i32 0
  %shr = lshr <1 x i64> %a, %splat.splatinsert
  ret <1 x i64> %shr
}

define <2 x i32> @lshr32x2(<2 x i32> %a, i32 %b) {
; CHECK-LABEL: lshr32x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.2s, w0
; CHECK-NEXT:    ushl v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i32 0, %b
  %splat.splatinsert = insertelement <2 x i32> poison, i32 %sub, i32 0
  %splat.splat = shufflevector <2 x i32> %splat.splatinsert, <2 x i32> poison, <2 x i32> zeroinitializer
  %shr = lshr <2 x i32> %a, %splat.splat
  ret <2 x i32> %shr
}

define <4 x i16> @lshr16x4(<4 x i16> %a, i16 %b) {
; CHECK-LABEL: lshr16x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.4h, w0
; CHECK-NEXT:    ushl v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
entry:
  %sub = sub i16 0, %b
  %0 = insertelement <4 x i16> undef, i16 %sub, i32 0
  %sh_prom = shufflevector <4 x i16> %0, <4 x i16> undef, <4 x i32> zeroinitializer
  %shr = lshr <4 x i16> %a, %sh_prom
  ret <4 x i16> %shr
}

define <8 x i8> @lshr8x8(<8 x i8> %a, i8 %b) {
; CHECK-LABEL: lshr8x8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dup v1.8b, w0
; CHECK-NEXT:    ushl v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %sub = sub i8 0, %b
  %0 = insertelement <8 x i8> undef, i8 %sub, i32 0
  %sh_prom = shufflevector <8 x i8> %0, <8 x i8> undef, <8 x i32> zeroinitializer
  %shr = lshr <8 x i8> %a, %sh_prom
  ret <8 x i8> %shr
}

define <2 x i64> @shl64x2(<2 x i64> %a, i64 %b) {
; CHECK-LABEL: shl64x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    neg x8, x0
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    ushl v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i64 0, %b
  %splat.splatinsert = insertelement <2 x i64> poison, i64 %sub, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> poison, <2 x i32> zeroinitializer
  %shl = shl <2 x i64> %a, %splat.splat
  ret <2 x i64> %shl
}

define <4 x i32> @shl32x4(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: shl32x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    ushl v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i32 0, %b
  %splat.splatinsert = insertelement <4 x i32> poison, i32 %sub, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> poison, <4 x i32> zeroinitializer
  %shl = shl <4 x i32> %a, %splat.splat
  ret <4 x i32> %shl
}

define <8 x i16> @shl16x8(<8 x i16> %a, i16 %b) {
; CHECK-LABEL: shl16x8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    ushl v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
entry:
  %sub = sub i16 0, %b
  %0 = insertelement <8 x i16> undef, i16 %sub, i32 0
  %sh_prom = shufflevector <8 x i16> %0, <8 x i16> undef, <8 x i32> zeroinitializer
  %shl = shl <8 x i16> %a, %sh_prom
  ret <8 x i16> %shl
}

define <16 x i8> @shl8x16(<16 x i8> %a, i8 %b) {
; CHECK-LABEL: shl8x16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    dup v1.16b, w8
; CHECK-NEXT:    ushl v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %sub = sub i8 0, %b
  %0 = insertelement <16 x i8> undef, i8 %sub, i32 0
  %sh_prom = shufflevector <16 x i8> %0, <16 x i8> undef, <16 x i32> zeroinitializer
  %shl = shl <16 x i8> %a, %sh_prom
  ret <16 x i8> %shl
}

define <1 x i64> @shl64x1(<1 x i64> %a, i64 %b) {
; CHECK-LABEL: shl64x1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    neg x8, x0
; CHECK-NEXT:    fmov d1, x8
; CHECK-NEXT:    ushl d0, d0, d1
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i64 0, %b
  %splat.splatinsert = insertelement <1 x i64> poison, i64 %sub, i32 0
  %shl = shl <1 x i64> %a, %splat.splatinsert
  ret <1 x i64> %shl
}

define <2 x i32> @shl32x2(<2 x i32> %a, i32 %b) {
; CHECK-LABEL: shl32x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    dup v1.2s, w8
; CHECK-NEXT:    ushl v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i32 0, %b
  %splat.splatinsert = insertelement <2 x i32> poison, i32 %sub, i32 0
  %splat.splat = shufflevector <2 x i32> %splat.splatinsert, <2 x i32> poison, <2 x i32> zeroinitializer
  %shl = shl <2 x i32> %a, %splat.splat
  ret <2 x i32> %shl
}

define <4 x i16> @shl16x4(<4 x i16> %a, i16 %b) {
; CHECK-LABEL: shl16x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    dup v1.4h, w8
; CHECK-NEXT:    ushl v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
entry:
  %sub = sub i16 0, %b
  %0 = insertelement <4 x i16> undef, i16 %sub, i32 0
  %sh_prom = shufflevector <4 x i16> %0, <4 x i16> undef, <4 x i32> zeroinitializer
  %shl = shl <4 x i16> %a, %sh_prom
  ret <4 x i16> %shl
}

define <8 x i8> @shl8x8(<8 x i8> %a, i8 %b) {
; CHECK-LABEL: shl8x8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    dup v1.8b, w8
; CHECK-NEXT:    ushl v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %sub = sub i8 0, %b
  %0 = insertelement <8 x i8> undef, i8 %sub, i32 0
  %sh_prom = shufflevector <8 x i8> %0, <8 x i8> undef, <8 x i32> zeroinitializer
  %shl = shl <8 x i8> %a, %sh_prom
  ret <8 x i8> %shl
}



define <vscale x 2 x i64> @shrn64x2(<vscale x 2 x i64> %a, i64 %b) {
; CHECK-LABEL: shrn64x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    neg x8, x0
; CHECK-NEXT:    mov z1.d, x8
; CHECK-NEXT:    asr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i64 0, %b
  %splat.splatinsert = insertelement <vscale x 2 x i64> poison, i64 %sub, i32 0
  %splat.splat = shufflevector <vscale x 2 x i64> %splat.splatinsert, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %shr = ashr <vscale x 2 x i64> %a, %splat.splat
  ret <vscale x 2 x i64> %shr
}

define <vscale x 4 x i32> @shrn32x4(<vscale x 4 x i32> %a, i32 %b) {
; CHECK-LABEL: shrn32x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    mov z1.s, w8
; CHECK-NEXT:    asr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i32 0, %b
  %splat.splatinsert = insertelement <vscale x 4 x i32> poison, i32 %sub, i32 0
  %splat.splat = shufflevector <vscale x 4 x i32> %splat.splatinsert, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %shr = ashr <vscale x 4 x i32> %a, %splat.splat
  ret <vscale x 4 x i32> %shr
}

define <vscale x 8 x i16> @shrn16x8(<vscale x 8 x i16> %a, i16 %b) {
; CHECK-LABEL: shrn16x8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    mov z1.h, w8
; CHECK-NEXT:    asr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %sub = sub i16 0, %b
  %0 = insertelement <vscale x 8 x i16> undef, i16 %sub, i32 0
  %sh_prom = shufflevector <vscale x 8 x i16> %0, <vscale x 8 x i16> undef, <vscale x 8 x i32> zeroinitializer
  %shr = ashr <vscale x 8 x i16> %a, %sh_prom
  ret <vscale x 8 x i16> %shr
}

define <vscale x 16 x i8> @shrn8x16(<vscale x 16 x i8> %a, i8 %b) {
; CHECK-LABEL: shrn8x16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    mov z1.b, w8
; CHECK-NEXT:    asr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %sub = sub i8 0, %b
  %0 = insertelement <vscale x 16 x i8> undef, i8 %sub, i32 0
  %sh_prom = shufflevector <vscale x 16 x i8> %0, <vscale x 16 x i8> undef, <vscale x 16 x i32> zeroinitializer
  %shr = ashr <vscale x 16 x i8> %a, %sh_prom
  ret <vscale x 16 x i8> %shr
}

define <vscale x 2 x i64> @lshrn64x2(<vscale x 2 x i64> %a, i64 %b) {
; CHECK-LABEL: lshrn64x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    neg x8, x0
; CHECK-NEXT:    mov z1.d, x8
; CHECK-NEXT:    lsr z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i64 0, %b
  %splat.splatinsert = insertelement <vscale x 2 x i64> poison, i64 %sub, i32 0
  %splat.splat = shufflevector <vscale x 2 x i64> %splat.splatinsert, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %shr = lshr <vscale x 2 x i64> %a, %splat.splat
  ret <vscale x 2 x i64> %shr
}

define <vscale x 4 x i32> @lshrn32x4(<vscale x 4 x i32> %a, i32 %b) {
; CHECK-LABEL: lshrn32x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    mov z1.s, w8
; CHECK-NEXT:    lsr z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i32 0, %b
  %splat.splatinsert = insertelement <vscale x 4 x i32> poison, i32 %sub, i32 0
  %splat.splat = shufflevector <vscale x 4 x i32> %splat.splatinsert, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %shr = lshr <vscale x 4 x i32> %a, %splat.splat
  ret <vscale x 4 x i32> %shr
}

define <vscale x 8 x i16> @lshrn16x8(<vscale x 8 x i16> %a, i16 %b) {
; CHECK-LABEL: lshrn16x8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    mov z1.h, w8
; CHECK-NEXT:    lsr z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %sub = sub i16 0, %b
  %0 = insertelement <vscale x 8 x i16> undef, i16 %sub, i32 0
  %sh_prom = shufflevector <vscale x 8 x i16> %0, <vscale x 8 x i16> undef, <vscale x 8 x i32> zeroinitializer
  %shr = lshr <vscale x 8 x i16> %a, %sh_prom
  ret <vscale x 8 x i16> %shr
}

define <vscale x 16 x i8> @lshrn8x16(<vscale x 16 x i8> %a, i8 %b) {
; CHECK-LABEL: lshrn8x16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    mov z1.b, w8
; CHECK-NEXT:    lsr z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %sub = sub i8 0, %b
  %0 = insertelement <vscale x 16 x i8> undef, i8 %sub, i32 0
  %sh_prom = shufflevector <vscale x 16 x i8> %0, <vscale x 16 x i8> undef, <vscale x 16 x i32> zeroinitializer
  %shr = lshr <vscale x 16 x i8> %a, %sh_prom
  ret <vscale x 16 x i8> %shr
}

define <vscale x 2 x i64> @shln64x2(<vscale x 2 x i64> %a, i64 %b) {
; CHECK-LABEL: shln64x2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    neg x8, x0
; CHECK-NEXT:    mov z1.d, x8
; CHECK-NEXT:    lsl z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i64 0, %b
  %splat.splatinsert = insertelement <vscale x 2 x i64> poison, i64 %sub, i32 0
  %splat.splat = shufflevector <vscale x 2 x i64> %splat.splatinsert, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %shl = shl <vscale x 2 x i64> %a, %splat.splat
  ret <vscale x 2 x i64> %shl
}

define <vscale x 4 x i32> @shln32x4(<vscale x 4 x i32> %a, i32 %b) {
; CHECK-LABEL: shln32x4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    mov z1.s, w8
; CHECK-NEXT:    lsl z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i32 0, %b
  %splat.splatinsert = insertelement <vscale x 4 x i32> poison, i32 %sub, i32 0
  %splat.splat = shufflevector <vscale x 4 x i32> %splat.splatinsert, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %shl = shl <vscale x 4 x i32> %a, %splat.splat
  ret <vscale x 4 x i32> %shl
}

define <vscale x 8 x i16> @shln16x8(<vscale x 8 x i16> %a, i16 %b) {
; CHECK-LABEL: shln16x8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    mov z1.h, w8
; CHECK-NEXT:    lsl z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %sub = sub i16 0, %b
  %0 = insertelement <vscale x 8 x i16> undef, i16 %sub, i32 0
  %sh_prom = shufflevector <vscale x 8 x i16> %0, <vscale x 8 x i16> undef, <vscale x 8 x i32> zeroinitializer
  %shl = shl <vscale x 8 x i16> %a, %sh_prom
  ret <vscale x 8 x i16> %shl
}

define <vscale x 16 x i8> @shln8x16(<vscale x 16 x i8> %a, i8 %b) {
; CHECK-LABEL: shln8x16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    neg w8, w0
; CHECK-NEXT:    mov z1.b, w8
; CHECK-NEXT:    lsl z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %sub = sub i8 0, %b
  %0 = insertelement <vscale x 16 x i8> undef, i8 %sub, i32 0
  %sh_prom = shufflevector <vscale x 16 x i8> %0, <vscale x 16 x i8> undef, <vscale x 16 x i32> zeroinitializer
  %shl = shl <vscale x 16 x i8> %a, %sh_prom
  ret <vscale x 16 x i8> %shl
}

define <vscale x 16 x i8> @subsub(<vscale x 16 x i8> %a, i8 %b) {
; CHECK-LABEL: subsub:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.b, w0
; CHECK-NEXT:    ret
entry:
  %sub = sub i8 0, %b
  %0 = insertelement <vscale x 16 x i8> undef, i8 %sub, i32 0
  %sh_prom = shufflevector <vscale x 16 x i8> %0, <vscale x 16 x i8> undef, <vscale x 16 x i32> zeroinitializer
  %sub2 = sub <vscale x 16 x i8> zeroinitializer, %sh_prom
  ret <vscale x 16 x i8> %sub2
}
