; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc --mtriple=loongarch64 --mattr=+lsx < %s | FileCheck %s

define void @ashr_v16i8(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: ashr_v16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vsra.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <16 x i8>, ptr %a0
  %v1 = load <16 x i8>, ptr %a1
  %v2 = ashr <16 x i8> %v0, %v1
  store <16 x i8> %v2, ptr %res
  ret void
}

define void @ashr_v8i16(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: ashr_v8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vsra.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <8 x i16>, ptr %a0
  %v1 = load <8 x i16>, ptr %a1
  %v2 = ashr <8 x i16> %v0, %v1
  store <8 x i16> %v2, ptr %res
  ret void
}

define void @ashr_v4i32(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: ashr_v4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vsra.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x i32>, ptr %a0
  %v1 = load <4 x i32>, ptr %a1
  %v2 = ashr <4 x i32> %v0, %v1
  store <4 x i32> %v2, ptr %res
  ret void
}

define void @ashr_v2i64(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: ashr_v2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vsra.d $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <2 x i64>, ptr %a0
  %v1 = load <2 x i64>, ptr %a1
  %v2 = ashr <2 x i64> %v0, %v1
  store <2 x i64> %v2, ptr %res
  ret void
}

define void @ashr_v16i8_1(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: ashr_v16i8_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vsrai.b $vr0, $vr0, 1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <16 x i8>, ptr %a0
  %v1 = ashr <16 x i8> %v0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  store <16 x i8> %v1, ptr %res
  ret void
}

define void @ashr_v16i8_7(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: ashr_v16i8_7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vsrai.b $vr0, $vr0, 7
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <16 x i8>, ptr %a0
  %v1 = ashr <16 x i8> %v0, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  store <16 x i8> %v1, ptr %res
  ret void
}

define void @ashr_v8i16_1(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: ashr_v8i16_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vsrai.h $vr0, $vr0, 1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <8 x i16>, ptr %a0
  %v1 = ashr <8 x i16> %v0, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  store <8 x i16> %v1, ptr %res
  ret void
}

define void @ashr_v8i16_15(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: ashr_v8i16_15:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vsrai.h $vr0, $vr0, 15
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <8 x i16>, ptr %a0
  %v1 = ashr <8 x i16> %v0, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  store <8 x i16> %v1, ptr %res
  ret void
}

define void @ashr_v4i32_1(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: ashr_v4i32_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vsrai.w $vr0, $vr0, 1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x i32>, ptr %a0
  %v1 = ashr <4 x i32> %v0, <i32 1, i32 1, i32 1, i32 1>
  store <4 x i32> %v1, ptr %res
  ret void
}

define void @ashr_v4i32_31(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: ashr_v4i32_31:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vsrai.w $vr0, $vr0, 31
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x i32>, ptr %a0
  %v1 = ashr <4 x i32> %v0, <i32 31, i32 31, i32 31, i32 31>
  store <4 x i32> %v1, ptr %res
  ret void
}

define void @ashr_v2i64_1(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: ashr_v2i64_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vsrai.d $vr0, $vr0, 1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <2 x i64>, ptr %a0
  %v1 = ashr <2 x i64> %v0, <i64 1, i64 1>
  store <2 x i64> %v1, ptr %res
  ret void
}

define void @ashr_v2i64_63(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: ashr_v2i64_63:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vsrai.d $vr0, $vr0, 63
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <2 x i64>, ptr %a0
  %v1 = ashr <2 x i64> %v0, <i64 63, i64 63>
  store <2 x i64> %v1, ptr %res
  ret void
}
