/*
 * GFS2 ftrace based trace-point metrics.
 *
 * Copyright (c) 2013 - 2014 Red Hat.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#ifndef FTRACE_H
#define FTRACE_H

#define INITIAL_GLOBAL_MAX_GLOCK_THROUGHPUT 750000

enum {
    GLOCK_STATE_CHANGE = 0,
    GLOCK_PUT,
    DEMOTE_RQ,
    PROMOTE,
    GLOCK_QUEUE,
    GLOCK_LOCK_TIME,
    PIN,
    LOG_FLUSH,
    LOG_BLOCKS,
    AIL_FLUSH,
    BLOCK_ALLOC,
    BMAP,
    RS,    
    NUM_FTRACE_TRACEPOINTS
};

enum {
    FTRACE_GLOCKSTATE_TOTAL = 0,
    FTRACE_GLOCKSTATE_NULLLOCK,
    FTRACE_GLOCKSTATE_CONCURRENTREAD,
    FTRACE_GLOCKSTATE_CONCURRENTWRITE,
    FTRACE_GLOCKSTATE_PROTECTEDREAD,
    FTRACE_GLOCKSTATE_PROTECTEDWRITE,
    FTRACE_GLOCKSTATE_EXCLUSIVE,
    FTRACE_GLOCKSTATE_GLOCK_CHANGEDTARGET,
    FTRACE_GLOCKSTATE_GLOCK_MISSEDTARGET,
    FTRACE_GLOCKPUT_TOTAL,
    FTRACE_GLOCKPUT_NULLLOCK,
    FTRACE_GLOCKPUT_CONCURRENTREAD,
    FTRACE_GLOCKPUT_CONCURRENTWRITE,
    FTRACE_GLOCKPUT_PROTECTEDREAD,
    FTRACE_GLOCKPUT_PROTECTEDWRITE,
    FTRACE_GLOCKPUT_EXCLUSIVE,
    FTRACE_DEMOTERQ_TOTAL,
    FTRACE_DEMOTERQ_NULLLOCK,
    FTRACE_DEMOTERQ_CONCURRENTREAD,
    FTRACE_DEMOTERQ_CONCURRENTWRITE,
    FTRACE_DEMOTERQ_PROTECTEDREAD,
    FTRACE_DEMOTERQ_PROTECTEDWRITE,
    FTRACE_DEMOTERQ_EXCLUSIVE,
    FTRACE_DEMOTERQ_REQUESTED_REMOTE,
    FTRACE_DEMOTERQ_REQUESTED_LOCAL,
    FTRACE_PROMOTE_TOTAL,
    FTRACE_PROMOTE_FIRST_NULLLOCK,
    FTRACE_PROMOTE_FIRST_CONCURRENTREAD,
    FTRACE_PROMOTE_FIRST_CONCURRENTWRITE,
    FTRACE_PROMOTE_FIRST_PROTECTEDREAD,
    FTRACE_PROMOTE_FIRST_PROTECTEDWRITE,
    FTRACE_PROMOTE_FIRST_EXCLUSIVE,
    FTRACE_PROMOTE_OTHER_NULLLOCK,
    FTRACE_PROMOTE_OTHER_CONCURRENTREAD,
    FTRACE_PROMOTE_OTHER_CONCURRENTWRITE,
    FTRACE_PROMOTE_OTHER_PROTECTEDREAD,
    FTRACE_PROMOTE_OTHER_PROTECTEDWRITE,
    FTRACE_PROMOTE_OTHER_EXCLUSIVE,
    FTRACE_GLOCKQUEUE_TOTAL,
    FTRACE_GLOCKQUEUE_QUEUE_TOTAL,
    FTRACE_GLOCKQUEUE_QUEUE_NULLLOCK,
    FTRACE_GLOCKQUEUE_QUEUE_CONCURRENTREAD,
    FTRACE_GLOCKQUEUE_QUEUE_CONCURRENTWRITE,
    FTRACE_GLOCKQUEUE_QUEUE_PROTECTEDREAD,
    FTRACE_GLOCKQUEUE_QUEUE_PROTECTEDWRITE,
    FTRACE_GLOCKQUEUE_QUEUE_EXCLUSIVE,
    FTRACE_GLOCKQUEUE_DEQUEUE_TOTAL,
    FTRACE_GLOCKQUEUE_DEQUEUE_NULLLOCK,
    FTRACE_GLOCKQUEUE_DEQUEUE_CONCURRENTREAD,
    FTRACE_GLOCKQUEUE_DEQUEUE_CONCURRENTWRITE,
    FTRACE_GLOCKQUEUE_DEQUEUE_PROTECTEDREAD,
    FTRACE_GLOCKQUEUE_DEQUEUE_PROTECTEDWRITE,
    FTRACE_GLOCKQUEUE_DEQUEUE_EXCLUSIVE,
    FTRACE_GLOCKLOCKTIME_TOTAL,
    FTRACE_GLOCKLOCKTIME_TRANS,
    FTRACE_GLOCKLOCKTIME_INDOE,
    FTRACE_GLOCKLOCKTIME_RGRP,
    FTRACE_GLOCKLOCKTIME_META,
    FTRACE_GLOCKLOCKTIME_IOPEN,
    FTRACE_GLOCKLOCKTIME_FLOCK,
    FTRACE_GLOCKLOCKTIME_QUOTA,
    FTRACE_GLOCKLOCKTIME_JOURNAL,
    FTRACE_PIN_TOTAL,
    FTRACE_PIN_PINTOTAL,
    FTRACE_PIN_UNPINTOTAL,
    FTRACE_PIN_LONGESTPINNED,
    FTRACE_LOGFLUSH_TOTAL,
    FTRACE_LOGBLOCKS_TOTAL,
    FTRACE_AILFLUSH_TOTAL,
    FTRACE_BLOCKALLOC_TOTAL,
    FTRACE_BLOCKALLOC_FREE,
    FTRACE_BLOCKALLOC_USED,
    FTRACE_BLOCKALLOC_DINODE,
    FTRACE_BLOCKALLOC_UNLINKED,
    FTRACE_BMAP_TOTAL,
    FTRACE_BMAP_CREATE,
    FTRACE_BMAP_NOCREATE,
    FTRACE_RS_TOTAL,
    FTRACE_RS_DEL,
    FTRACE_RS_TDEL,
    FTRACE_RS_INS,
    FTRACE_RS_CLM,
    NUM_TRACEPOINT_STATS
};

struct ftrace {
    uint64_t values[NUM_TRACEPOINT_STATS];
};

struct ftrace_data {
    dev_t dev_id;
    int   tracepoint;
    char  data[512];
};

extern void ftrace_increase_num_accepted_entries();
extern int gfs2_ftrace_fetch(int, struct ftrace *, pmAtomValue *);
extern int gfs2_refresh_ftrace_stats(pmInDom);

extern int ftrace_get_threshold();
extern int ftrace_set_threshold(pmValueSet *vsp);

#endif	/*FTRACE_H*/
