# The Backup Cycle - Full Backups

## Creating a backup

To create a backup, run `xtrabackup` with the `xtrabackup --backup option`. You also need to specify a `xtrabackup --target-dir` option, which is where the backup will be stored, if the *InnoDB* data or log files aren’t stored in the same directory, you might need to specify the
location of those, too. If the target directory does not exist, xtrabackup
creates it. If the directory does exist and is empty, xtrabackup will
succeed. xtrabackup will not overwrite existing files, it will fail with
operating system error 17, `file exists`.

To start the backup process run:

```bash
$ xtrabackup --backup --target-dir=/data/backups/
```

This will store the backup at `/data/backups/`. If you specify a relative
path, the target directory will be relative to the current directory.

During the backup process, you should see a lot of output showing the data files
being copied, as well as the log file thread repeatedly scanning the log files
and copying from it. Here is an example that shows the log thread scanning the
log in the background, and a file copying thread working on the ibdata1
file:

```text
160906 10:19:17 Finished backing up non-InnoDB tables and files
160906 10:19:17 Executing FLUSH NO_WRITE_TO_BINLOG ENGINE LOGS...
xtrabackup: The latest check point (for incremental): '62988944'
xtrabackup: Stopping log copying thread.
.160906 10:19:18 >> log scanned up to (137343534)
160906 10:19:18 Executing UNLOCK TABLES
160906 10:19:18 All tables unlocked
160906 10:19:18 Backup created in directory '/data/backups/'
160906 10:19:18 [00] Writing backup-my.cnf
160906 10:19:18 [00]        ...done
160906 10:19:18 [00] Writing xtrabackup_info
160906 10:19:18 [00]        ...done
xtrabackup: Transaction log of lsn (26970807) to (137343534) was copied.
160906 10:19:18 completed OK!
```

The last thing you should see is something like the following, where the value
of the `<LSN>` will be a number that depends on your system:

```text
xtrabackup: Transaction log of lsn (<SLN>) to (<LSN>) was copied.
```

!!! note

    Log copying thread checks the transactional log every second to see if there were any new log records written that need to be copied, but there is a chance that the log copying thread might not be able to keep up with the amount of writes that go to the transactional logs, and will hit an error when the log records are overwritten before they could be read.

After the backup is finished, the target directory will contain files such as
the following, assuming you have a single InnoDB table `test.tbl1` and
you are using MySQL’s `innodb_file_per_table` option:

```bash
$ ls -lh /data/backups/
total 182M
drwx------  7 root root 4.0K Sep  6 10:19 .
drwxrwxrwt 11 root root 4.0K Sep  6 11:05 ..
-rw-r-----  1 root root  387 Sep  6 10:19 backup-my.cnf
-rw-r-----  1 root root  76M Sep  6 10:19 ibdata1
drwx------  2 root root 4.0K Sep  6 10:19 mysql
drwx------  2 root root 4.0K Sep  6 10:19 performance_schema
drwx------  2 root root 4.0K Sep  6 10:19 sbtest
drwx------  2 root root 4.0K Sep  6 10:19 test
drwx------  2 root root 4.0K Sep  6 10:19 world2
-rw-r-----  1 root root  116 Sep  6 10:19 xtrabackup_checkpoints
-rw-r-----  1 root root  433 Sep  6 10:19 xtrabackup_info
-rw-r-----  1 root root 106M Sep  6 10:19 xtrabackup_logfile
```

The backup can take a long time, depending on how large the database is. It is
safe to cancel at any time, because it does not modify the database.

The next step is getting your backup ready to be restored.

## Preparing a backup

After you made a backup with the `xtrabackup --backup` option, you’ll
first need to prepare it in order to restore it. Data files are not
point-in-time consistent until they’ve been prepared, because they were copied
at different times as the program ran, and they might have been changed while
this was happening. If you try to start InnoDB with these data files, it will
detect corruption and crash itself to prevent you from running on damaged data.
The `xtrabackup --prepare` step makes the files perfectly consistent at
a single instant in time, so you can run *InnoDB* on them.

You can run the prepare operation on any machine; it does not need to be on the originating server or the server to which you intend to restore. You can copy the backup to a utility server and prepare it there.

!!! note

    You can prepare a backup created with older *Percona XtraBackup* version with a newer one, but not vice versa. Preparing a backup on an unsupported server version should be done with the latest *Percona XtraBackup* release which supports that server version. For example, if one has a backup of MySQL 5.0 created with *Percona XtraBackup* 1.6, then preparing the backup with *Percona XtraBackup* 2.3 is not supported, because support for MySQL 5.0 was removed in *Percona XtraBackup* 2.1. Instead, the latest release in the 2.0 series should be used.

During the `prepare` operation, xtrabackup boots up a kind of modified
InnoDB that’s embedded inside it (the libraries it was linked against). The
modifications are necessary to disable InnoDB’s standard safety checks, such as complaining that the log file isn’t the right size, which aren’t appropriate for working with backups. These modifications are only for the xtrabackup binary; you don’t need a modified *InnoDB* to use xtrabackup for your backups.

The prepare step uses this *embedded InnoDB* to perform crash recovery on the
copied data files, using the copied log file. The `prepare` step is very
simple to use: you simply run `xtrabackup --prepare` option and tell it
which directory to prepare, for example, to prepare the previously taken backup run:

```bash
$ xtrabackup --prepare --target-dir=/data/backups/
```

When this finishes, you should see an `InnoDB shutdown` with a message such as
the following, where again the value of `LSN` will depend on your system:

```text
InnoDB: Shutdown completed; log sequence number 137345046
160906 11:21:01 completed OK!
```

All following prepares will not change the already prepared data files, you’ll
see that output says:

```console
xtrabackup: This target seems to be already prepared.
xtrabackup: notice: xtrabackup_logfile was already used to '--prepare'.
```

It is not recommended to interrupt xtrabackup process while preparing backup
because it may cause data files corruption and backup will become unusable.
Backup validity is not guaranteed if prepare process was interrupted.

!!! note

    If you intend the backup to be the basis for further incremental backups, you should use the `xtrabackup --apply-log-only` option when preparing the backup, or you will not be able to apply incremental backups to it. See the documentation on preparing [incremental backup] (incremental_backup.md#incremental-backup) for more details.

## Restoring a Backup

!!! warning

    Backup needs to be prepared before it can be restored.

```bash
$ xtrabackup --copy-back --target-dir=/data/backups/
```

If you don’t want to save your backup, you can use the `xtrabackup --move-back` option which will move the backed up data to the `datadir`.

If you don’t want to use any of the above options, you can additionally use
`rsync` or `cp` to restore the files.

!!! note

    The `datadir` must be empty before restoring the backup. Also it’s important to note that MySQL server needs to be shut down before restore is performed. You can’t restore to a `datadir` of a running mysqld instance (except when importing a partial backup).

Example of the `rsync` command that can be used to restore the backup
can look like this:

```bash
$ rsync -avrP /data/backup/ /var/lib/mysql/
```

You should check that the restored files have the correct ownership and
permissions.

As files’ attributes will be preserved, in most cases you will need to change
the files’ ownership to `mysql` before starting the database server, as they
will be owned by the user who created the backup:

```bash
$ chown -R mysql:mysql /var/lib/mysql
```

Data is now restored and you can start the server.

!!! note

    When `relay-log-info-repository=TABLE` is enabled, the instance recovered from the backup has errors in the error log, like the following:

    ```bash
    2019-08-09 12:40:02 69297 [ERROR] Failed to open the relay log '/data/mysql-relay-bin.004349' (relay_log_pos 5534092)
    ```

    To avoid these types of issues, enable `relay_log_recovery` or execute `RESET SLAVE` prior to `CHANGE MASTER TO`.

    The relay log information was backed up, but a new relay log has been created, which creates a mismatch during the restore.


