# *Percona XtraBackup* 2.4.8

Percona is glad to announce the release of *Percona XtraBackup* 2.4.8 on
July 24th 2017. Downloads are available from our [download site](http://www.percona.com/downloads/XtraBackup/Percona-XtraBackup-2.4.8/) and
from [apt](../../installation/apt_repo.md#apt-repo) and [yum](../../installation/yum_repo.md#yum-repo) repositories.

This release is the current GA (Generally Available) stable release in the 2.4
series.

## New Features

* To avoid issues with *MySQL* 5.7 skipping redo log for DDL *Percona XtraBackup* has implemented three new options
(`xtrabackup --lock-ddl`,
`xtrabackup --lock-ddl-timeout`,
`xtrabackup --lock-ddl-per-table`) that can be used to place MDL locks
on tables while they are copied.

* New `xtrabackup --check-privileges` option has been implemented that
can be used to check if *Percona XtraBackup* has all
[required privileges](../../using_xtrabackup/privileges.md#privileges) to perform the backup.

## Bugs fixed

* *xtrabackup* would hang with `Waiting for master thread to be
suspended` message when backup was being prepared. Bug fixed [PXB-499](https://jira.percona.com/browse/PXB-499).

* *xtrabackup* would fail to prepare the backup with `6th page is not
initialized` message in case server didn’t properly initialize the page. Bug
fixed [PXB-500](https://jira.percona.com/browse/PXB-500).

* xbstream could run out of file descriptors while extracting the backup
which contains many tables. Bug fixed [PXB-503](https://jira.percona.com/browse/PXB-503)

* When a table was created with the `DATA DIRECTORY` option *xtrabackup* would
back up the `.frm` and `.isl` files, but not the `.ibd` file. Due to the
missing `.ibd` files backup then could not be restored. Bug fixed
[PXB-504](https://jira.percona.com/browse/PXB-504).

* *Percona XtraBackup* incorrectly determined use of `master_auto_postion`
on a slave, and thus generated invalid xtrabackup_slave_info file.
Bug fixed [PXB-505](https://jira.percona.com/browse/PXB-505).

* *Percona XtraBackup* will now print a warning if it encounters unsupported
storage engine. Bug fixed [PXB-713](https://jira.percona.com/browse/PXB-713).

* *Percona XtraBackup* would crash while backing up MariaDB 10.2.x with
`--ftwrl-\*` options. Bug fixed [PXB-790](https://jira.percona.com/browse/PXB-790).

* `xtrabackup --slave-info` didn’t write the correct information into
`xtrabackup_slave_info` file when multi-source replication was used.
Bug fixed [PXB-1022](https://jira.percona.com/browse/PXB-1022).

* Along with xtrabackup_checkpints file, *xtrabackup* now copies
`xtrabackup_info` file into directory specified by
`xtrabackup --extra-lsndir` option. Bug fixed [PXB-1026](https://jira.percona.com/browse/PXB-1026).

* GTID position was not recorded when xtrabackup –binlog-info option
was set to `AUTO`. Bug fixed [PXB-1030](https://jira.percona.com/browse/PXB-1030).
