# Scripting Backups With xtrabackup

The `xtrabackup` tool has several features to enable scripts to control
it while they perform related tasks. The [innobackupex script](../innobackupex/innobackupex_script.md) is one example, but `xtrabackup`
is easy to control with your own command-line scripts too.

## Suspending After Copying

In backup mode, `xtrabackup` normally copies the log files in a
background thread, copies the data files in a foreground thread, and then stops
the log copying thread and finishes. As long as that file exists, xtrabackup
will continue to watch the log files and copy them into the
`xtrabackup_logfile` in the target directory. When the file is removed,
`xtrabackup` will finish copying the log file and exit.

This functionality is useful for coordinating the InnoDB data backups with other
actions. Perhaps the most obvious is copying the table definitions (the
`.frm` files) so that the backup can be restored. You can start
`xtrabackup` in the background, wait for the
`xtrabackup_suspended` file to be created, and then copy any other files
you need to complete the backup. This is exactly what the [innobackupex](../innobackupex/innobackupex_script.md) tool does (it also copies MyISAM data and
other files).

## Generating Meta-Data

It is a good idea for the backup to include all the information you need to
restore the backup. The `xtrabackup` tool can print out the contents of
a `my.cnf` file that are needed to restore the data and log files.
`xtrabackup --print-param` prints out something like the following:

```default
# This MySQL options file was generated by XtraBackup.
[mysqld]
datadir = /data/mysql/
innodb_data_home_dir = /data/innodb/
innodb_data_file_path = ibdata1:10M:autoextend
innodb_log_group_home_dir = /data/innodb-logs/
```

You can redirect this output into a file in the target directory of the backup.

## Agreeing on the Source Directory

It’s possible that the presence of a defaults file or other factors could cause
`xtrabackup` to back up data from a different location than you
expected. To prevent this, you can use `xtrabackup --print-param` to ask
it where it will be copying data from. You can use the output to ensure that
`xtrabackup` and your script are working on the same dataset.
