/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.selftests.ocsp;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.LogEventListener;
import com.netscape.certsrv.security.SigningUnit;
import com.netscape.certsrv.selftests.EDuplicateSelfTestException;
import com.netscape.certsrv.selftests.EInvalidSelfTestException;
import com.netscape.certsrv.selftests.EMissingSelfTestException;
import com.netscape.certsrv.selftests.ESelfTestException;
import com.netscape.cms.selftests.SelfTest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.selftests.SelfTestSubsystem;
import com.netscape.ocsp.OCSPAuthority;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Locale;
import org.dogtagpki.server.ocsp.OCSPEngine;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class OCSPValidity
extends SelfTest {
    public static final String PROP_OCSP_SUB_ID = "OcspSubId";
    private String mOcspSubId = null;

    public void initSelfTest(SelfTestSubsystem subsystem, String instanceName, ConfigStore parameters) throws EDuplicateSelfTestException, EInvalidSelfTestException, EMissingSelfTestException {
        super.initSelfTest(subsystem, instanceName, parameters);
        try {
            this.mOcspSubId = this.mConfig.getString(PROP_OCSP_SUB_ID);
            if (this.mOcspSubId == null) {
                this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_VALUES", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".OcspSubId"}));
                throw new EMissingSelfTestException(PROP_OCSP_SUB_ID);
            }
            this.mOcspSubId = this.mOcspSubId.trim();
        }
        catch (EBaseException e) {
            this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_NAME", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".OcspSubId"}));
            throw new EMissingSelfTestException(this.mPrefix, PROP_OCSP_SUB_ID, null);
        }
    }

    public void startupSelfTest() throws ESelfTestException {
    }

    public void shutdownSelfTest() {
    }

    public String getSelfTestName() {
        return super.getSelfTestName();
    }

    public ConfigStore getSelfTestConfigStore() {
        return super.getSelfTestConfigStore();
    }

    public String getSelfTestDescription(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_SELFTESTS_OCSP_VALIDITY_DESCRIPTION", (String[])new String[0]);
    }

    public void runSelfTest(LogEventListener logger) throws Exception {
        String logMessage = null;
        OCSPEngine engine = OCSPEngine.getInstance();
        OCSPAuthority ocsp = (OCSPAuthority)engine.getSubsystem(this.mOcspSubId);
        if (ocsp == null) {
            logMessage = CMS.getLogMessage((String)"SELFTESTS_OCSP_IS_NOT_PRESENT", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw new Exception(logMessage);
        }
        SigningUnit ocspSigningUnit = ocsp.getSigningUnit();
        if (ocspSigningUnit == null) {
            logMessage = CMS.getLogMessage((String)"SELFTESTS_OCSP_IS_NOT_INITIALIZED", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw new Exception(logMessage);
        }
        X509CertImpl ocspCert = ocspSigningUnit.getCertImpl();
        if (ocspCert == null) {
            logMessage = CMS.getLogMessage((String)"SELFTESTS_OCSP_IS_NOT_INITIALIZED", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw new Exception(logMessage);
        }
        try {
            ocspCert.checkValidity();
        }
        catch (CertificateNotYetValidException e) {
            logMessage = CMS.getLogMessage((String)"SELFTESTS_OCSP_IS_NOT_YET_VALID", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw e;
        }
        catch (CertificateExpiredException e) {
            logMessage = CMS.getLogMessage((String)"SELFTESTS_OCSP_IS_EXPIRED", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw e;
        }
        logMessage = CMS.getLogMessage((String)"SELFTESTS_OCSP_IS_VALID", (Object[])new Object[]{this.getSelfTestName()});
        this.mSelfTestSubsystem.log(logger, logMessage);
    }
}

