/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserExtensionDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(UserExtensionDefault.class);
    public static final String CONFIG_CRITICAL = "userExtCritical";
    public static final String CONFIG_OID = "userExtOID";
    public static final String VAL_CRITICAL = "userExtCritical";
    public static final String VAL_OID = "userExtOID";

    public UserExtensionDefault() {
        this.addValueName("userExtOID");
        this.addConfigName("userExtOID");
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("userExtOID")) {
            return new Descriptor("string", null, "Comment Here...", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OID", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("userExtOID")) {
            return new Descriptor("string", "readonly", null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OID", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals("userExtOID")) {
            Extension ext = this.getExtension(this.getConfig("userExtOID"), info);
            if (ext == null) {
                return "";
            }
            return ext.getExtensionId().toString();
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_USER_EXT", (String[])new String[]{this.getConfig("userExtOID")});
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        CertificateExtensions inExts = null;
        String oid = this.getConfig("userExtOID");
        inExts = request.getExtDataInCertExts("req_extensions");
        if (inExts == null) {
            return;
        }
        Extension ext = this.getExtension(this.getConfig("userExtOID"), inExts);
        if (ext == null) {
            logger.warn("UserExtensionDefault: no user ext supplied for " + oid);
            return;
        }
        try {
            this.deleteExtension(oid, info);
        }
        catch (Exception e) {
            throw new EProfileException((Throwable)e);
        }
        logger.debug("UserExtensionDefault: using user supplied ext for " + oid);
        this.addExtension(oid, ext, info);
    }
}

