/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.common.CAEnrollProfile;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileInput;
import com.netscape.cms.profile.common.ProfileOutput;
import com.netscape.cms.profile.common.ProfilePolicy;
import com.netscape.cms.profile.constraint.PolicyConstraint;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.servlet.admin.AdminServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.registry.PluginInfo;
import com.netscape.cmscore.registry.PluginRegistry;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caprofile", urlPatterns={"/caprofile"}, initParams={@WebInitParam(name="ID", value="caprofile"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca")})
public class ProfileAdminServlet
extends AdminServlet {
    public static Logger logger = LoggerFactory.getLogger(ProfileAdminServlet.class);
    private static final long serialVersionUID = 4828203666899891742L;
    public static final String PROP_AUTHORITY = "authority";
    private static final String INFO = "ProfileAdminServlet";
    public static final String PROP_PREDICATE = "predicate";
    private PluginRegistry registry;
    private ProfileSubsystem mProfileSub;
    public static String INVALID_POLICY_SCOPE = "Invalid policy administration scope";
    public static String INVALID_POLICY_IMPL_OP = "Invalid operation for policy implementation management";
    public static String NYI = "Not Yet Implemented";
    public static String INVALID_POLICY_IMPL_CONFIG = "Invalid policy implementation configuration";
    public static String INVALID_POLICY_INSTANCE_CONFIG = "Invalid policy instance configuration";
    public static String MISSING_POLICY_IMPL_ID = "Missing policy impl id in request";
    public static String MISSING_POLICY_IMPL_CLASS = "Missing policy impl class in request";
    public static String INVALID_POLICY_IMPL_ID = "Invalid policy impl id in request";
    public static String MISSING_POLICY_INST_ID = "Missing policy id in request";
    public static String POLICY_INST_ID_ALREADY_USED = "policy id already used";
    public static String INVALID_POLICY_INST_ID = "Invalid policy id in request";
    public static String COMMA = ",";
    public static String MISSING_POLICY_ORDERING = "Missing policy ordering";
    public static String BAD_CONFIGURATION_VAL = "Invalid configuration value.";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        CAEngine engine = CAEngine.getInstance();
        this.registry = engine.getPluginRegistry();
        this.mProfileSub = engine.getProfileSubsystem();
    }

    public String getServletInfo() {
        return INFO;
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
        super.authenticate(req);
        AUTHZ_RES_NAME = "certServer.profile.configuration";
        String scope = req.getParameter("OP_SCOPE");
        logger.debug("ProfileAdminServlet: scope: " + scope);
        try {
            if (scope.equals("rules")) {
                this.processProfileRuleMgmt(req, resp);
            } else if (scope.equals("policies")) {
                this.processProfilePolicy(req, resp);
            } else if (scope.equals("defaultPolicy")) {
                this.processPolicyDefaultConfig(req, resp);
            } else if (scope.equals("constraintPolicy")) {
                this.processPolicyConstraintConfig(req, resp);
            } else if (scope.equals("impls")) {
                this.processPolicyImplMgmt(req, resp);
            } else if (scope.equals("profileInput")) {
                this.processProfileInput(req, resp);
            } else if (scope.equals("profileOutput")) {
                this.processProfileOutput(req, resp);
            } else if (scope.equals("profileInputConfig")) {
                this.processProfileInputConfig(req, resp);
            } else if (scope.equals("profileOutputConfig")) {
                this.processProfileOutputConfig(req, resp);
            } else {
                this.sendResponse(ERROR, INVALID_POLICY_SCOPE, null, resp);
            }
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private boolean readAuthorize(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.mOp = "read";
        this.mToken = super.authorize(req);
        if (this.mToken == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
            return false;
        }
        return true;
    }

    private boolean modifyAuthorize(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.mOp = "modify";
        this.mToken = super.authorize(req);
        if (this.mToken == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
            return false;
        }
        return true;
    }

    public void processProfilePolicy(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String op = req.getParameter("OP_TYPE");
        if (op.equals("OP_READ")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.getProfilePolicy(req, resp);
        } else if (op.equals("OP_ADD")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.addProfilePolicy(req, resp);
        } else if (op.equals("OP_DELETE")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.deleteProfilePolicy(req, resp);
        }
    }

    public void processProfileInput(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String op = req.getParameter("OP_TYPE");
        if (op.equals("OP_READ")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.getProfileInput(req, resp);
        } else if (op.equals("OP_ADD")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.addProfileInput(req, resp);
        } else if (op.equals("OP_DELETE")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.deleteProfileInput(req, resp);
        }
    }

    public void processProfileOutput(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String op = req.getParameter("OP_TYPE");
        if (op.equals("OP_READ")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.getProfileOutput(req, resp);
        } else if (op.equals("OP_ADD")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.addProfileOutput(req, resp);
        } else if (op.equals("OP_DELETE")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.deleteProfileOutput(req, resp);
        }
    }

    public void processProfileInputConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String op = req.getParameter("OP_TYPE");
        if (op.equals("OP_READ")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.getInputConfig(req, resp);
        } else if (op.equals("OP_MODIFY")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.modifyInputConfig(req, resp);
        }
    }

    public void processProfileOutputConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String op = req.getParameter("OP_TYPE");
        if (op.equals("OP_READ")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.getOutputConfig(req, resp);
        } else if (op.equals("OP_MODIFY")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.modifyOutputConfig(req, resp);
        }
    }

    public void processPolicyDefaultConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String op = req.getParameter("OP_TYPE");
        if (op.equals("OP_READ")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.getPolicyDefaultConfig(req, resp);
        } else if (op.equals("OP_ADD")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.addPolicyDefaultConfig(req, resp);
        } else if (op.equals("OP_MODIFY")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.modifyPolicyDefaultConfig(req, resp);
        }
    }

    public void processPolicyConstraintConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String op = req.getParameter("OP_TYPE");
        logger.debug("ProfileAdminServlet: processPolicyConstraintConfig op " + op);
        if (op.equals("OP_READ")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.getPolicyConstraintConfig(req, resp);
        } else if (op.equals("OP_ADD")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.addPolicyConstraintConfig(req, resp);
        } else if (op.equals("OP_MODIFY")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.modifyPolicyConstraintConfig(req, resp);
        }
    }

    public void processPolicyImplMgmt(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String op = req.getParameter("OP_TYPE");
        if (op.equals("OP_SEARCH")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.listProfileImpls(req, resp);
        } else {
            this.sendResponse(ERROR, INVALID_POLICY_IMPL_OP, null, resp);
        }
    }

    public void processProfileRuleMgmt(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String op = req.getParameter("OP_TYPE");
        if (op.equals("OP_SEARCH")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.listProfileInstances(req, resp);
        } else if (op.equals("OP_DELETE")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.deleteProfileInstance(req, resp);
        } else if (op.equals("OP_READ")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.getProfileInstanceConfig(req, resp);
        } else if (op.equals("OP_ADD")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.addProfileInstance(req, resp);
        } else if (op.equals("OP_MODIFY")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.modifyProfileInstance(req, resp);
        } else {
            this.sendResponse(ERROR, INVALID_POLICY_IMPL_OP, null, resp);
        }
    }

    public void listProfileImpls(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Enumeration impls = this.registry.getIds("profile");
        NameValuePairs nvp = new NameValuePairs();
        while (impls.hasMoreElements()) {
            String id = (String)impls.nextElement();
            PluginInfo info = this.registry.getPluginInfo("profile", id);
            nvp.put((Object)id, (Object)(info.getClassName() + "," + info.getDescription(this.getLocale(req))));
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void addProfilePolicy(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        logger.debug("ProfileAdminServlet: in addProfilePolicy");
        try {
            String id = req.getParameter("RS_ID");
            StringTokenizer st = new StringTokenizer(id, ";");
            String profileId = st.nextToken();
            String policyId = st.nextToken();
            String defImpl = st.nextToken();
            String conImpl = st.nextToken();
            Profile profile = null;
            try {
                profile = this.mProfileSub.getProfile(profileId);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            if (this.mProfileSub.isProfileEnable(profileId)) {
                this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_PROFILE_CREATE_POLICY_FAILED", (String[])new String[]{"Profile is currently enabled"}), null, resp);
                return;
            }
            StringTokenizer ss = new StringTokenizer(policyId, ":");
            String setId = ss.nextToken();
            String pId = ss.nextToken();
            try {
                if (!this.isValidId(setId)) {
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_PROFILE_CREATE_POLICY_FAILED", (String[])new String[]{"Invalid set id " + setId}), null, resp);
                    return;
                }
                if (!this.isValidId(pId)) {
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_PROFILE_CREATE_POLICY_FAILED", (String[])new String[]{"Invalid policy id " + pId}), null, resp);
                    return;
                }
                profile.createProfilePolicy(setId, pId, defImpl, conImpl);
            }
            catch (EBaseException e1) {
                logger.error("ProfileAdminServlet: addProfilePolicy " + e1.getMessage(), (Throwable)e1);
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_PROFILE_CREATE_POLICY_FAILED", (String[])new String[]{e1.toString()}), null, resp);
                return;
            }
            NameValuePairs nvp = new NameValuePairs();
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, nvp, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void addProfileInput(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            StringTokenizer st = new StringTokenizer(id, ";");
            String profileId = st.nextToken();
            String inputId = st.nextToken();
            String inputImpl = st.nextToken();
            Profile profile = null;
            try {
                profile = this.mProfileSub.getProfile(profileId);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            Enumeration names = req.getParameterNames();
            NameValuePairs nvps = new NameValuePairs();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equals("OP_SCOPE") || name.equals("OP_TYPE") || name.equals("RS_ID")) continue;
                nvps.put((Object)name, (Object)req.getParameter(name));
            }
            try {
                profile.createProfileInput(inputId, inputImpl, nvps);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_PROFILE_CREATE_INPUT_FAILED", (String[])new String[]{e1.toString()}), null, resp);
                return;
            }
            NameValuePairs nvp = new NameValuePairs();
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, nvp, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void addProfileOutput(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            StringTokenizer st = new StringTokenizer(id, ";");
            String profileId = st.nextToken();
            String outputId = st.nextToken();
            String outputImpl = st.nextToken();
            Profile profile = null;
            try {
                profile = this.mProfileSub.getProfile(profileId);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            Enumeration names = req.getParameterNames();
            NameValuePairs nvps = new NameValuePairs();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equals("OP_SCOPE") || name.equals("OP_TYPE") || name.equals("RS_ID")) continue;
                nvps.put((Object)name, (Object)req.getParameter(name));
            }
            try {
                profile.createProfileOutput(outputId, outputImpl, nvps);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_PROFILE_CREATE_OUTPUT_FAILED", (String[])new String[]{e1.toString()}), null, resp);
                return;
            }
            NameValuePairs nvp = new NameValuePairs();
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, nvp, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void deleteProfilePolicy(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String profileId = "";
            String policyId = "";
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equals("OP_SCOPE") || name.equals("OP_TYPE")) continue;
                if (name.equals("RS_ID")) {
                    profileId = req.getParameter(name);
                }
                if (!name.equals("POLICYID")) continue;
                policyId = req.getParameter(name);
            }
            Profile profile = null;
            try {
                profile = this.mProfileSub.getProfile(profileId);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            StringTokenizer ss = new StringTokenizer(policyId, ":");
            String setId = ss.nextToken();
            String pId = ss.nextToken();
            try {
                profile.deleteProfilePolicy(setId, pId);
            }
            catch (EBaseException e1) {
                logger.error("ProfileAdminServlet: " + e1.getMessage(), (Throwable)e1);
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            NameValuePairs nvp = new NameValuePairs();
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, nvp, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void deleteProfileInput(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String profileId = "";
            String inputId = "";
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equals("OP_SCOPE") || name.equals("OP_TYPE")) continue;
                if (name.equals("RS_ID")) {
                    profileId = req.getParameter(name);
                }
                if (!name.equals("INPUTID")) continue;
                inputId = req.getParameter(name);
            }
            logger.debug("ProfileAdminServlet: deleteProfileInput profileId -> " + profileId);
            logger.debug("ProfileAdminServlet: deleteProfileInput inputId -> " + inputId);
            Profile profile = null;
            try {
                profile = this.mProfileSub.getProfile(profileId);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            logger.debug("deleteProfileInput profile -> " + profile);
            try {
                profile.deleteProfileInput(inputId);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            NameValuePairs nvp = new NameValuePairs();
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, nvp, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void deleteProfileOutput(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String profileId = "";
            String outputId = "";
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equals("OP_SCOPE") || name.equals("OP_TYPE")) continue;
                if (name.equals("RS_ID")) {
                    profileId = req.getParameter(name);
                }
                if (!name.equals("OUTPUTID")) continue;
                outputId = req.getParameter(name);
            }
            logger.debug("ProfileAdminServlet: deleteProfileOutput profileId -> " + profileId);
            logger.debug("ProfileAdminServlet: deleteProfileOutput outputId -> " + outputId);
            Profile profile = null;
            try {
                profile = this.mProfileSub.getProfile(profileId);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            logger.debug("ProfileAdminServlet: deleteProfileOutput profile -> " + profile);
            try {
                profile.deleteProfileOutput(outputId);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            NameValuePairs nvp = new NameValuePairs();
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, nvp, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void addPolicyDefaultConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            StringTokenizer st = new StringTokenizer(id, ";");
            String profileId = st.nextToken();
            String policyId = st.nextToken();
            Profile profile = null;
            try {
                profile = this.mProfileSub.getProfile(profileId);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            StringTokenizer ss = new StringTokenizer(policyId, ":");
            String setId = ss.nextToken();
            String pId = ss.nextToken();
            ProfilePolicy policy = profile.getProfilePolicy(setId, pId);
            PolicyDefault def = policy.getDefault();
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equals("OP_SCOPE") || name.equals("OP_TYPE") || name.equals("RS_ID")) continue;
                try {
                    def.setConfig(name, req.getParameter(name));
                }
                catch (EPropertyException e) {
                    logger.error("ProfileAdminServlet: modifyPolicyDefConfig setConfig exception: " + e.getMessage(), (Throwable)e);
                    try {
                        profile.deleteProfilePolicy(setId, pId);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.sendResponse(ERROR, BAD_CONFIGURATION_VAL, null, resp);
                    return;
                }
            }
            try {
                profile.getConfigStore().commit(false);
            }
            catch (Exception e) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            NameValuePairs nvp = new NameValuePairs();
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, nvp, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void addPolicyConstraintConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.info("ProfileAdminServlet: Adding policy constraints");
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            StringTokenizer st = new StringTokenizer(id, ";");
            String profileId = st.nextToken();
            String policyId = st.nextToken();
            Profile profile = null;
            try {
                profile = this.mProfileSub.getProfile(profileId);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            StringTokenizer ss = new StringTokenizer(policyId, ":");
            String setId = ss.nextToken();
            String pId = ss.nextToken();
            ProfilePolicy policy = profile.getProfilePolicy(setId, pId);
            PolicyConstraint con = policy.getConstraint();
            Enumeration names = req.getParameterNames();
            logger.info("ProfileAdminServlet: Parameters:");
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equals("OP_SCOPE") || name.equals("OP_TYPE") || name.equals("RS_ID")) continue;
                String value = req.getParameter(name);
                logger.info("ProfileAdminServlet: - " + name + ": " + value);
                try {
                    con.setConfig(name, value);
                }
                catch (EPropertyException e) {
                    logger.error("ProfileAdminServlet: addPolicyConstraintsConfig setConfig exception: " + e.getMessage(), (Throwable)e);
                    try {
                        profile.deleteProfilePolicy(setId, pId);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.sendResponse(ERROR, BAD_CONFIGURATION_VAL, null, resp);
                    return;
                }
            }
            try {
                profile.getConfigStore().commit(false);
            }
            catch (Exception e) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            NameValuePairs nvp = new NameValuePairs();
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, nvp, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void modifyPolicyDefaultConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            StringTokenizer st = new StringTokenizer(id, ";");
            String profileId = st.nextToken();
            String policyId = st.nextToken();
            Profile profile = null;
            try {
                profile = this.mProfileSub.getProfile(profileId);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            StringTokenizer ss = new StringTokenizer(policyId, ":");
            String setId = ss.nextToken();
            String pId = ss.nextToken();
            ProfilePolicy policy = profile.getProfilePolicy(setId, pId);
            PolicyDefault def = policy.getDefault();
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equals("OP_SCOPE") || name.equals("OP_TYPE") || name.equals("RS_ID")) continue;
                try {
                    def.setConfig(name, req.getParameter(name));
                }
                catch (EPropertyException e) {
                    logger.error("ProfileAdminServlet: modifyPolicyDefConfig setConfig exception: " + e.getMessage(), (Throwable)e);
                    this.sendResponse(ERROR, BAD_CONFIGURATION_VAL, null, resp);
                    return;
                }
            }
            try {
                profile.getConfigStore().commit(false);
            }
            catch (Exception e) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            NameValuePairs nvp = new NameValuePairs();
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, nvp, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void modifyInputConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            StringTokenizer st = new StringTokenizer(id, ";");
            String profileId = st.nextToken();
            String inputId = st.nextToken();
            Profile profile = null;
            try {
                profile = this.mProfileSub.getProfile(profileId);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            ProfileInput input = profile.getProfileInput(inputId);
            ConfigStore inputConfig = input.getConfigStore();
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equals("OP_SCOPE") || name.equals("OP_TYPE") || name.equals("RS_ID")) continue;
                inputConfig.putString("params." + name, req.getParameter(name));
            }
            try {
                profile.getConfigStore().commit(false);
            }
            catch (Exception e) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            NameValuePairs nvp = new NameValuePairs();
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, nvp, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void modifyOutputConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            StringTokenizer st = new StringTokenizer(id, ";");
            String profileId = st.nextToken();
            String outputId = st.nextToken();
            Profile profile = null;
            try {
                profile = this.mProfileSub.getProfile(profileId);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            ProfileOutput output = profile.getProfileOutput(outputId);
            ConfigStore outputConfig = output.getConfigStore();
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equals("OP_SCOPE") || name.equals("OP_TYPE") || name.equals("RS_ID")) continue;
                outputConfig.putString("params." + name, req.getParameter(name));
            }
            try {
                profile.getConfigStore().commit(false);
            }
            catch (Exception e) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            NameValuePairs nvp = new NameValuePairs();
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, nvp, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void modifyPolicyConstraintConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.info("ProfileAdminServlet: Modifying policy constraints");
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            StringTokenizer st = new StringTokenizer(id, ";");
            String profileId = st.nextToken();
            String policyId = st.nextToken();
            Profile profile = null;
            try {
                profile = this.mProfileSub.getProfile(profileId);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            StringTokenizer ss = new StringTokenizer(policyId, ":");
            String setId = ss.nextToken();
            String pId = ss.nextToken();
            ProfilePolicy policy = profile.getProfilePolicy(setId, pId);
            PolicyConstraint con = policy.getConstraint();
            Enumeration names = req.getParameterNames();
            logger.info("ProfileAdminServlet: Parameters:");
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equals("OP_SCOPE") || name.equals("OP_TYPE") || name.equals("RS_ID")) continue;
                String value = req.getParameter(name);
                logger.info("ProfileAdminServlet: - " + name + ": " + value);
                try {
                    con.setConfig(name, value);
                }
                catch (EPropertyException e) {
                    logger.error("ProfileAdminServlet: modifyPolicyConstraintsConfig setConfig exception: " + e.getMessage(), (Throwable)e);
                    this.sendResponse(ERROR, BAD_CONFIGURATION_VAL, null, resp);
                    return;
                }
            }
            try {
                profile.getConfigStore().commit(false);
            }
            catch (Exception e) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            NameValuePairs nvp = new NameValuePairs();
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, nvp, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void getPolicyDefaultConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("RS_ID");
        StringTokenizer st = new StringTokenizer(id, ";");
        String profileId = st.nextToken();
        String policyId = st.nextToken();
        Profile profile = null;
        try {
            profile = this.mProfileSub.getProfile(profileId);
        }
        catch (EBaseException e1) {
            logger.error("ProfileAdminServlet::getPolicyDefaultConfig() - profile is null! " + e1.getMessage(), (Throwable)e1);
            throw new ServletException(e1.toString());
        }
        PolicyDefault rule = null;
        StringTokenizer ss = new StringTokenizer(policyId, ":");
        String setId = ss.nextToken();
        String pId = ss.nextToken();
        ProfilePolicy policy = profile.getProfilePolicy(setId, pId);
        rule = policy.getDefault();
        NameValuePairs nvp = new NameValuePairs();
        Enumeration names = rule.getConfigNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            IDescriptor desc = rule.getConfigDescriptor(this.getLocale(req), name);
            if (desc == null) {
                nvp.put((Object)name, (Object)(";;" + rule.getConfig(name)));
                continue;
            }
            nvp.put((Object)name, (Object)(desc.getSyntax() + ";;" + this.getNonNull(desc.getConstraint()) + ";" + desc.getDescription(this.getLocale(req)) + ";" + rule.getConfig(name)));
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void getPolicyConstraintConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("RS_ID");
        String constraintsList = req.getParameter("constraintPolicy");
        if (constraintsList != null) {
            // empty if block
        }
        StringTokenizer st = new StringTokenizer(id, ";");
        String profileId = st.nextToken();
        String policyId = st.nextToken();
        Profile profile = null;
        try {
            profile = this.mProfileSub.getProfile(profileId);
        }
        catch (EBaseException e1) {
            logger.error("ProfileAdminServlet::getPolicyConstraintConfig() - profile is null! " + e1.getMessage(), (Throwable)e1);
            throw new ServletException(e1.toString());
        }
        StringTokenizer ss = new StringTokenizer(policyId, ":");
        String setId = ss.nextToken();
        String pId = ss.nextToken();
        ProfilePolicy policy = profile.getProfilePolicy(setId, pId);
        PolicyConstraint rule = policy.getConstraint();
        NameValuePairs nvp = new NameValuePairs();
        Enumeration names = rule.getConfigNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            IDescriptor desc = rule.getConfigDescriptor(this.getLocale(req), name);
            if (desc == null) {
                nvp.put((Object)name, (Object)(";" + rule.getConfig(name)));
                continue;
            }
            nvp.put((Object)name, (Object)(desc.getSyntax() + ";" + this.getNonNull(desc.getConstraint()) + ";" + desc.getDescription(this.getLocale(req)) + ";" + rule.getConfig(name)));
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void getProfilePolicy(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("RS_ID");
        Profile profile = null;
        try {
            profile = this.mProfileSub.getProfile(id);
        }
        catch (EBaseException e1) {
            logger.error("ProfileAdminServlet::getProfilePolicy() - profile is null! " + e1.getMessage(), (Throwable)e1);
            throw new ServletException(e1.toString());
        }
        NameValuePairs nvp = new NameValuePairs();
        Enumeration<String> setIds = profile.getProfilePolicySetIds();
        if (!setIds.hasMoreElements()) {
            this.sendResponse(SUCCESS, null, nvp, resp);
            return;
        }
        while (setIds.hasMoreElements()) {
            String setId = setIds.nextElement();
            Enumeration<ProfilePolicy> policies = profile.getProfilePolicies(setId);
            while (policies.hasMoreElements()) {
                ProfilePolicy policy = policies.nextElement();
                PolicyDefault def = policy.getDefault();
                PolicyConstraint con = policy.getConstraint();
                nvp.put((Object)(setId + ":" + policy.getId()), (Object)(def.getName(this.getLocale(req)) + ";" + con.getName(this.getLocale(req))));
            }
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void getProfileOutput(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("RS_ID");
        Profile profile = null;
        try {
            profile = this.mProfileSub.getProfile(id);
        }
        catch (EBaseException e1) {
            logger.error("ProfileAdminServlet::getProfileOutput() - profile is null! " + e1.getMessage(), (Throwable)e1);
            throw new ServletException(e1.toString());
        }
        NameValuePairs nvp = new NameValuePairs();
        Enumeration<String> outputs = profile.getProfileOutputIds();
        while (outputs.hasMoreElements()) {
            String outputId = outputs.nextElement();
            ProfileOutput output = profile.getProfileOutput(outputId);
            nvp.put((Object)outputId, (Object)output.getName(this.getLocale(req)));
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void getProfileInput(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("RS_ID");
        Profile profile = null;
        try {
            profile = this.mProfileSub.getProfile(id);
        }
        catch (EBaseException e1) {
            logger.error("ProfileAdminServlet::getProfileInput() - profile is null! " + e1.getMessage(), (Throwable)e1);
            throw new ServletException(e1.toString());
        }
        NameValuePairs nvp = new NameValuePairs();
        Enumeration<String> inputs = profile.getProfileInputIds();
        while (inputs.hasMoreElements()) {
            String inputId = inputs.nextElement();
            ProfileInput input = profile.getProfileInput(inputId);
            nvp.put((Object)inputId, (Object)input.getName(this.getLocale(req)));
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void getInputConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("RS_ID");
        StringTokenizer st = new StringTokenizer(id, ";");
        String profileId = st.nextToken();
        String inputId = st.nextToken();
        Profile profile = null;
        try {
            profile = this.mProfileSub.getProfile(profileId);
        }
        catch (EBaseException e1) {
            logger.error("ProfileAdminServlet::getInputConfig() - profile is null! " + e1.getMessage(), (Throwable)e1);
            throw new ServletException(e1.toString());
        }
        ProfileInput profileInput = null;
        NameValuePairs nvp = new NameValuePairs();
        profileInput = profile.getProfileInput(inputId);
        Enumeration names = profileInput.getConfigNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            IDescriptor desc = profileInput.getConfigDescriptor(this.getLocale(req), name);
            if (desc == null) {
                nvp.put((Object)name, (Object)(";;" + profileInput.getConfig(name)));
                continue;
            }
            nvp.put((Object)name, (Object)(desc.getSyntax() + ";" + this.getNonNull(desc.getConstraint()) + ";" + desc.getDescription(this.getLocale(req)) + ";" + profileInput.getConfig(name)));
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void getOutputConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("RS_ID");
        StringTokenizer st = new StringTokenizer(id, ";");
        String profileId = st.nextToken();
        String outputId = st.nextToken();
        Profile profile = null;
        try {
            profile = this.mProfileSub.getProfile(profileId);
        }
        catch (EBaseException e1) {
            logger.error("ProfileAdminServlet::getOutputConfig() - profile is null! " + e1.getMessage(), (Throwable)e1);
            throw new ServletException(e1.toString());
        }
        ProfileOutput profileOutput = null;
        NameValuePairs nvp = new NameValuePairs();
        profileOutput = profile.getProfileOutput(outputId);
        Enumeration names = profileOutput.getConfigNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            IDescriptor desc = profileOutput.getConfigDescriptor(this.getLocale(req), name);
            if (desc == null) {
                nvp.put((Object)name, (Object)(";;" + profileOutput.getConfig(name)));
                continue;
            }
            nvp.put((Object)name, (Object)(desc.getSyntax() + ";" + this.getNonNull(desc.getConstraint()) + ";" + desc.getDescription(this.getLocale(req)) + ";" + profileOutput.getConfig(name)));
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void listProfileInstances(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        NameValuePairs nvp = new NameValuePairs();
        Enumeration<String> e = this.mProfileSub.getProfileIds();
        while (e.hasMoreElements()) {
            String profileId = e.nextElement();
            String status = null;
            status = this.mProfileSub.isProfileEnable(profileId) ? "enabled" : "disabled";
            nvp.put((Object)profileId, (Object)(profileId + ";visible;" + status));
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void getProfileInstanceConfig(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String id = req.getParameter("RS_ID");
        Profile profile = this.mProfileSub.getProfile(id);
        NameValuePairs nvp = new NameValuePairs();
        nvp.put((Object)"name", (Object)profile.getName(this.getLocale(req)));
        nvp.put((Object)"desc", (Object)profile.getDescription(this.getLocale(req)));
        nvp.put((Object)"visible", (Object)Boolean.toString(profile.isVisible()));
        nvp.put((Object)"enable", (Object)Boolean.toString(this.mProfileSub.isProfileEnable(id)));
        String authid = profile.getAuthenticatorId();
        logger.debug("ProfileAdminServlet: authid: " + authid);
        if (authid == null) {
            nvp.put((Object)"auth", (Object)"");
        } else {
            nvp.put((Object)"auth", (Object)authid);
        }
        nvp.put((Object)"plugin", (Object)this.mProfileSub.getProfileClassId(id));
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void deleteProfileInstance(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            if (id == null) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, MISSING_POLICY_INST_ID, null, resp);
                return;
            }
            try {
                this.mProfileSub.deleteProfile(id);
            }
            catch (EBaseException e) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)e.toString(), (String[])new String[]{id}), null, resp);
                return;
            }
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, null, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void putUserPWPair(String combo) {
        int semicolon = combo.indexOf(";");
        String user = combo.substring(0, semicolon);
        String pw = combo.substring(semicolon + 1);
        CAEngine engine = CAEngine.getInstance();
        engine.putPasswordCache(user, pw);
    }

    public boolean isValidId(String id) {
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    public void addProfileInstance(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            if (id == null || id.trim().equals("") || !this.isValidId(id)) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, MISSING_POLICY_INST_ID, null, resp);
                return;
            }
            Profile p = null;
            try {
                p = this.mProfileSub.getProfile(id);
            }
            catch (EProfileException eProfileException) {
                // empty catch block
            }
            if (p != null) {
                this.sendResponse(ERROR, POLICY_INST_ID_ALREADY_USED, null, resp);
                return;
            }
            String impl = req.getParameter("impl");
            String name = req.getParameter("name");
            String visible = req.getParameter("visible");
            String auth = req.getParameter("auth");
            String config = null;
            CertificateAuthority ca = engine.getCA();
            String subname = "ca";
            String subpath = "/profiles/";
            try {
                int v;
                String version = cs.getString("cms.version");
                if (version.indexOf(46) > -1) {
                    version = version.substring(0, version.indexOf(46));
                }
                if ((v = Integer.parseInt(version)) >= 10) {
                    subpath = "/ca/profiles/";
                }
                config = CMS.getInstanceDir() + subpath + subname + "/" + id + ".cfg";
            }
            catch (EBaseException e) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            PluginInfo info = this.registry.getPluginInfo("profile", impl);
            Profile profile = null;
            try {
                profile = this.mProfileSub.createProfile(id, impl, info.getClassName());
                profile.setName(this.getLocale(req), name);
                profile.setDescription(this.getLocale(req), name);
                if (visible != null && visible.equals("true")) {
                    profile.setVisible(true);
                } else {
                    profile.setVisible(false);
                }
                profile.setAuthenticatorId(auth);
                profile.getConfigStore().commit(false);
                if (profile instanceof CAEnrollProfile) {
                    ((CAEnrollProfile)profile).populate();
                }
            }
            catch (Exception e) {
                logger.error("ProfileAdminServlet: " + e.getMessage(), (Throwable)e);
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, null, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    public void modifyProfileInstance(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            Profile profile = null;
            try {
                profile = this.mProfileSub.getProfile(id);
            }
            catch (EBaseException e1) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, null, null, resp);
                return;
            }
            String name = req.getParameter("name");
            String desc = req.getParameter("desc");
            String auth = req.getParameter("auth");
            String visible = req.getParameter("visible");
            profile.setAuthenticatorId(auth);
            profile.setName(this.getLocale(req), name);
            profile.setDescription(this.getLocale(req), desc);
            if (visible != null && visible.equals("true")) {
                profile.setVisible(true);
            } else {
                profile.setVisible(false);
            }
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            try {
                profile.getConfigStore().commit(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sendResponse(SUCCESS, null, null, resp);
        }
        catch (IOException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CERT_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
    }

    protected String getNonNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

