/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotDefined;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicConstraintsExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(BasicConstraintsExt.class);
    protected static final String PROP_MAXPATHLEN = "maxPathLen";
    protected static final String PROP_IS_CA = "isCA";
    protected static final String PROP_IS_CRITICAL = "critical";
    protected static final String ARG_PATHLEN = "BasicConstraintsPathLen";
    protected int mMaxPathLen = 0;
    protected String mOrigMaxPathLen = "";
    protected boolean mCritical = true;
    protected int mDefaultMaxPathLen = 0;
    protected int mCAPathLen = 0;
    protected boolean mRemoveExt = true;
    protected boolean mIsCA = true;
    public static final boolean DEFAULT_CRITICALITY = true;

    public BasicConstraintsExt() {
        this.NAME = "BasicConstraintsExt";
        this.DESC = "Sets critical basic constraints extension in subordinate CA certs";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        CertificateAuthority certAuthority = (CertificateAuthority)owner.getAuthority();
        if (certAuthority == null) {
            logger.error(CMS.getLogMessage((String)"CA_CANT_FIND_MANAGER", (Object[])new Object[0]));
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{"Cannot find the Certificate Manager or Registration Manager"}));
        }
        CertificateChain caChain = certAuthority.getCACertChain();
        CAEngine engine = CAEngine.getInstance();
        if (caChain == null || engine.isPreOpMode()) {
            logger.warn("BasicConstraintsExt.init(): Abort due to missing CA certificate chain or in pre-op-mode");
            return;
        }
        X509Certificate caCert = caChain.getFirstCertificate();
        this.mCAPathLen = caCert.getBasicConstraints();
        if (this.mCAPathLen < 0) {
            this.mDefaultMaxPathLen = -1;
        } else if (this.mCAPathLen > 0) {
            this.mDefaultMaxPathLen = this.mCAPathLen - 1;
        } else {
            logger.warn(CMS.getLogMessage((String)"POLICY_PATHLEN_ZERO", (Object[])new Object[0]));
        }
        boolean pathLenConfigured = true;
        try {
            this.mCritical = config.getBoolean(PROP_IS_CRITICAL, true);
            this.mIsCA = config.getBoolean(PROP_IS_CA, true);
            this.mMaxPathLen = config.getInteger(PROP_MAXPATHLEN);
            if (this.mMaxPathLen < 0) {
                logger.error(CMS.getLogMessage((String)"POLICY_INVALID_MAXPATHLEN_4", (Object[])new Object[]{"", String.valueOf(this.mMaxPathLen)}));
                throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_INVALID_MAXPATHLEN_1", (String[])new String[]{this.NAME, String.valueOf(this.mMaxPathLen)}));
            }
            this.mOrigMaxPathLen = Integer.toString(this.mMaxPathLen);
        }
        catch (EBaseException e) {
            if (!(e instanceof EPropertyNotFound) && !(e instanceof EPropertyNotDefined)) {
                logger.error(CMS.getLogMessage((String)"POLICY_INVALID_MAXPATHLEN", (Object[])new Object[0]));
                throw e;
            }
            pathLenConfigured = false;
            this.mMaxPathLen = this.mDefaultMaxPathLen;
            this.mOrigMaxPathLen = "";
        }
        if (pathLenConfigured) {
            if (this.mCAPathLen > 0 && (this.mMaxPathLen >= this.mCAPathLen || this.mMaxPathLen < 0)) {
                Object maxStr = this.mMaxPathLen < 0 ? String.valueOf(this.mMaxPathLen) + "(unlimited)" : String.valueOf(this.mMaxPathLen);
                logger.error(CMS.getLogMessage((String)"POLICY_MAXPATHLEN_TOO_BIG_3", (Object[])new Object[]{"", maxStr, String.valueOf(this.mCAPathLen)}));
                throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_MAXPATHLEN_TOO_BIG_1", (String[])new String[]{this.NAME, maxStr, Integer.toString(this.mCAPathLen)}));
            }
            if (this.mCAPathLen == 0 && this.mMaxPathLen != 0) {
                logger.error(CMS.getLogMessage((String)"POLICY_INVALID_MAXPATHLEN_2", (Object[])new Object[]{"", String.valueOf(this.mMaxPathLen)}));
                throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_INVALID_MAXPATHLEN", (String[])new String[]{this.NAME, String.valueOf(this.mMaxPathLen)}));
            }
        }
    }

    public PolicyResult apply(Request req) {
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        X509CertInfo certInfo = null;
        if (ci == null || (certInfo = ci[0]) == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[]{this.NAME}), "");
            return PolicyResult.REJECTED;
        }
        boolean isCA = this.mIsCA;
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certResult = this.applyCert(req, isCA, certInfo);
            if (certResult != PolicyResult.REJECTED) continue;
            return certResult;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, boolean isCA, X509CertInfo certInfo) {
        BasicConstraintsExtension newExt;
        int reqPathLen;
        String reqPathLenStr;
        CertificateExtensions extensions = null;
        BasicConstraintsExtension basicExt = null;
        try {
            extensions = (CertificateExtensions)certInfo.get("extensions");
            if (extensions != null) {
                basicExt = (BasicConstraintsExtension)extensions.get("BasicConstraints");
            }
        }
        catch (IOException iOException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if (!isCA) {
            BasicConstraintsExtension critExt;
            if (extensions == null) {
                try {
                    certInfo.set("version", (Object)new CertificateVersion(2));
                    extensions = new CertificateExtensions();
                    certInfo.set("extensions", (Object)extensions);
                }
                catch (CertificateException certificateException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (basicExt != null) {
                try {
                    extensions.delete("BasicConstraints");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                critExt = new BasicConstraintsExtension(isCA, this.mCritical, this.mMaxPathLen);
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"POLICY_ERROR_BASIC_CONSTRAINTS_2", (Object[])new Object[]{e.toString()}), (Throwable)e);
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_BASIC_CONSTRAINTS_ERROR", (String[])new String[]{this.NAME}), "");
                return PolicyResult.REJECTED;
            }
            try {
                extensions.set("BasicConstraints", (Object)critExt);
            }
            catch (IOException e) {
                // empty catch block
            }
            logger.debug("BasicConstraintsExt: PolicyRule BasicConstraintsExt: added the extension to request " + req.getRequestId());
            return PolicyResult.ACCEPTED;
        }
        if (this.mCAPathLen == 0) {
            logger.error(CMS.getLogMessage((String)"POLICY_NO_SUB_CA_CERTS_ALLOWED_1", (Object[])new Object[]{this.NAME}));
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_SUB_CA_CERTS_ALLOWED", (String[])new String[]{this.NAME}), "");
            return PolicyResult.REJECTED;
        }
        if (basicExt != null) {
            block43: {
                try {
                    BasicConstraintsExtension critExt;
                    boolean extIsCA = (Boolean)basicExt.get("is_ca");
                    int pathLen = (Integer)basicExt.get("path_len");
                    if (this.mMaxPathLen > -1 && (pathLen > this.mMaxPathLen || pathLen < 0)) {
                        logger.error(CMS.getLogMessage((String)"POLICY_MAXPATHLEN_TOO_BIG_3", (Object[])new Object[]{this.NAME, "unlimited", String.valueOf(pathLen)}));
                        if (pathLen < 0) {
                            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_MAXPATHLEN_TOO_BIG", (String[])new String[]{this.NAME, "unlimited", Integer.toString(this.mMaxPathLen)}), "");
                        } else {
                            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_MAXPATHLEN_TOO_BIG", (String[])new String[]{this.NAME, Integer.toString(pathLen), Integer.toString(this.mMaxPathLen)}), "");
                        }
                        return PolicyResult.REJECTED;
                    }
                    if (!extIsCA) {
                        basicExt.set("is_ca", (Object)true);
                    }
                    if (this.mMaxPathLen == 0) {
                        if (pathLen != 0) {
                            basicExt.set("path_len", (Object)0);
                            pathLen = 0;
                        }
                    } else if (this.mMaxPathLen > 0 && pathLen > this.mMaxPathLen) {
                        basicExt.set("path_len", (Object)this.mMaxPathLen);
                        pathLen = this.mMaxPathLen;
                    }
                    if (basicExt.isCritical()) break block43;
                    try {
                        critExt = new BasicConstraintsExtension(isCA, this.mCritical, pathLen);
                    }
                    catch (IOException e) {
                        logger.error(CMS.getLogMessage((String)"POLICY_ERROR_BASIC_CONSTRAINTS_1", (Object[])new Object[]{this.NAME}), (Throwable)e);
                        this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_BASIC_CONSTRAINTS_ERROR", (String[])new String[]{this.NAME}), "");
                        return PolicyResult.REJECTED;
                    }
                    extensions.delete("BasicConstraints");
                    extensions.set("BasicConstraints", (Object)critExt);
                }
                catch (IOException extIsCA) {
                    // empty catch block
                }
            }
            logger.debug("BasicConstraintsExt: PolicyRule BasicConstraintsExt: added the extension to request " + req.getRequestId());
            return PolicyResult.ACCEPTED;
        }
        if (extensions == null) {
            try {
                certInfo.set("version", (Object)new CertificateVersion(2));
                extensions = new CertificateExtensions();
                certInfo.set("extensions", (Object)extensions);
            }
            catch (CertificateException extIsCA) {
            }
            catch (IOException extIsCA) {
                // empty catch block
            }
        }
        if ((reqPathLenStr = req.getExtDataInString(ARG_PATHLEN)) == null) {
            reqPathLen = this.mMaxPathLen;
        } else {
            try {
                reqPathLen = Integer.parseInt(reqPathLenStr);
                if (this.mMaxPathLen == 0 && reqPathLen != 0 || this.mMaxPathLen > 0 && (reqPathLen > this.mMaxPathLen || reqPathLen < 0)) {
                    Object plenStr = reqPathLen < 0 ? reqPathLenStr + "(unlimited)" : reqPathLenStr;
                    logger.error(CMS.getLogMessage((String)"POLICY_PATHLEN_TOO_BIG_3", (Object[])new Object[]{plenStr, String.valueOf(this.mMaxPathLen)}));
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_PATHLEN_TOO_BIG", (String[])new String[]{this.NAME, plenStr, String.valueOf(this.mMaxPathLen)}), "");
                    return PolicyResult.REJECTED;
                }
            }
            catch (NumberFormatException e) {
                logger.error(CMS.getLogMessage((String)"POLICY_INVALID_PATHLEN_FORMAT_2", (Object[])new Object[]{this.NAME, reqPathLenStr}));
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_INVALID_PATHLEN_FORMAT", (String[])new String[]{this.NAME, reqPathLenStr}), "");
                return PolicyResult.REJECTED;
            }
        }
        try {
            newExt = new BasicConstraintsExtension(isCA, this.mCritical, reqPathLen);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"POLICY_ERROR_BASIC_CONSTRAINTS_2", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_BASIC_CONSTRAINTS_ERROR", (String[])new String[]{this.NAME}), "");
            return PolicyResult.REJECTED;
        }
        try {
            extensions.set("BasicConstraints", (Object)newExt);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.debug("BasicConstraintsExt: added the extension to request " + req.getRequestId());
        return PolicyResult.ACCEPTED;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> params = new Vector<String>();
        params.addElement("maxPathLen=" + this.mOrigMaxPathLen);
        params.addElement("critical=" + this.mCritical);
        params.addElement("isCA=" + this.mIsCA);
        return params;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> defParams = new Vector<String>();
        defParams.addElement("critical=true");
        defParams.addElement("maxPathLen=");
        defParams.addElement("isCA=true");
        return defParams;
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"maxPathLen;number;'0' means : no subordinates allowed, 'n' means : at most n subordinates allowed.", "critical;boolean;RFC 2459 recommendation: MUST be critical in CA certs, SHOULD NOT appear in EE certs.", "isCA;boolean;Identifies the subject of the certificate is a CA or not.", "HELP_TOKEN;configuration-policyrules-basicconstraints", "HELP_TEXT;Adds the Basic Constraints extension. See RFC 2459 (4.2.1.10)"};
        return params;
    }
}

