/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.rest;

import com.netscape.certsrv.base.BadRequestDataException;
import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.ConflictingOperationException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.HTTPGoneException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.ServiceUnavailableException;
import com.netscape.certsrv.ca.CADisabledException;
import com.netscape.certsrv.ca.CAMissingCertException;
import com.netscape.certsrv.ca.CAMissingKeyException;
import com.netscape.certsrv.ca.CANotFoundException;
import com.netscape.certsrv.cert.AgentCertRequestResource;
import com.netscape.certsrv.cert.CertRequestInfos;
import com.netscape.certsrv.cert.CertReviewResponse;
import com.netscape.certsrv.profile.EDeferException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestNotFoundException;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.util.Locale;
import javax.ws.rs.core.Response;
import org.dogtagpki.server.ca.rest.CertRequestDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentCertRequestService
extends PKIService
implements AgentCertRequestResource {
    public static final Logger logger = LoggerFactory.getLogger(AgentCertRequestService.class);
    public static final int DEFAULT_START = 0;
    public static final int DEFAULT_PAGESIZE = 20;
    public static final int DEFAULT_MAXRESULTS = 100;
    public static final int DEFAULT_MAXTIME = 10;

    public Response approveRequest(RequestId id, CertReviewResponse data) {
        logger.info("CertRequestService: Approving certificate request " + id.toHexString());
        this.changeRequestState(id, data, "approve");
        return this.createNoContentResponse();
    }

    public Response rejectRequest(RequestId id, CertReviewResponse data) {
        logger.info("CertRequestService: Rejecting certificate request " + id.toHexString());
        this.changeRequestState(id, data, "reject");
        return this.createNoContentResponse();
    }

    public Response cancelRequest(RequestId id, CertReviewResponse data) {
        logger.info("CertRequestService: Canceling certificate request " + id.toHexString());
        this.changeRequestState(id, data, "cancel");
        return this.createNoContentResponse();
    }

    public Response updateRequest(RequestId id, CertReviewResponse data) {
        logger.info("CertRequestService: Updating certificate request " + id.toHexString());
        this.changeRequestState(id, data, "update");
        return this.createNoContentResponse();
    }

    public Response validateRequest(RequestId id, CertReviewResponse data) {
        logger.info("CertRequestService: Validating certificate request " + id.toHexString());
        this.changeRequestState(id, data, "validate");
        return this.createNoContentResponse();
    }

    public Response unassignRequest(RequestId id, CertReviewResponse data) {
        logger.info("CertRequestService: Unassigning certificate request " + id.toHexString());
        this.changeRequestState(id, data, "unassign");
        return this.createNoContentResponse();
    }

    public Response assignRequest(RequestId id, CertReviewResponse data) {
        logger.info("CertRequestService: Assigning certificate request " + id.toHexString());
        this.changeRequestState(id, data, "assign");
        return this.createNoContentResponse();
    }

    public void changeRequestState(RequestId id, CertReviewResponse data, String op) {
        if (id == null) {
            throw new BadRequestException("Unable to change request state: Missing input data");
        }
        CertRequestDAO dao = new CertRequestDAO();
        try {
            dao.changeRequestState(id, this.servletRequest, data, this.getLocale(this.headers), op);
        }
        catch (ERejectException e) {
            String message = CMS.getUserMessage((Locale)this.getLocale(this.headers), (String)"CMS_PROFILE_REJECTED", (String[])new String[]{e.getMessage()});
            logger.error(message, (Throwable)e);
            throw new BadRequestException(message, (Throwable)e);
        }
        catch (EDeferException e) {
            String message = CMS.getUserMessage((Locale)this.getLocale(this.headers), (String)"CMS_PROFILE_DEFERRED", (String[])new String[]{e.toString()});
            logger.error(message, (Throwable)e);
            throw new BadRequestException(message, (Throwable)e);
        }
        catch (BadRequestDataException e) {
            String message = "Bad request data: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new BadRequestException(message, (Throwable)e);
        }
        catch (CANotFoundException e) {
            String message = "CA not found: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new HTTPGoneException(message, (Throwable)e);
        }
        catch (CADisabledException e) {
            String message = "CA disabled: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new ConflictingOperationException(message, (Throwable)e);
        }
        catch (CAMissingCertException | CAMissingKeyException e) {
            throw new ServiceUnavailableException(e.toString(), e);
        }
        catch (EPropertyException e) {
            logger.error("CertRequestService: Unable to change request state: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to change request state: " + e.getMessage(), (Throwable)e);
        }
        catch (EProfileException e) {
            String message = CMS.getUserMessage((Locale)this.getLocale(this.headers), (String)"CMS_INTERNAL_ERROR", (String[])new String[0]) + ": " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new PKIException(message, (Throwable)e);
        }
        catch (EBaseException e) {
            String message = "Unable to change request state: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new PKIException(message, (Throwable)e);
        }
        catch (RequestNotFoundException e) {
            String message = "Unable to change request state: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw e;
        }
    }

    public Response reviewRequest(RequestId id) {
        CertReviewResponse info;
        if (id == null) {
            String message = "Unable to review cert request: Missing request ID";
            logger.error(message);
            throw new BadRequestException(message);
        }
        logger.info("CertRequestService: Reviewing certificate request " + id.toHexString());
        CertRequestDAO dao = new CertRequestDAO();
        try {
            info = dao.reviewRequest(this.servletRequest, id, this.uriInfo, this.getLocale(this.headers));
        }
        catch (EBaseException e) {
            String message = "Unable to review cert request: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new PKIException(message, (Throwable)e);
        }
        if (info == null) {
            throw new RequestNotFoundException(id);
        }
        logger.info("CertRequestService: - profile: " + info.getProfileName());
        logger.info("CertRequestService: - type: " + info.getRequestType());
        logger.info("CertRequestService: - status: " + info.getRequestStatus());
        return this.createOKResponse(info);
    }

    public Response listRequests(String requestState, String requestType, RequestId start, Integer pageSize, Integer maxResults, Integer maxTime) {
        CertRequestInfos requests;
        String filter = this.createSearchFilter(requestState, requestType);
        logger.debug("listRequests: filter is " + filter);
        start = start == null ? new RequestId(0) : start;
        pageSize = pageSize == null ? 20 : pageSize;
        maxResults = maxResults == null ? 100 : maxResults;
        maxTime = maxTime == null ? 10 : maxTime;
        CertRequestDAO reqDAO = new CertRequestDAO();
        try {
            requests = reqDAO.listRequests(filter, start, pageSize, maxResults, maxTime, this.uriInfo);
        }
        catch (EBaseException e) {
            String message = "Unable to list cert requests: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new PKIException(message, (Throwable)e);
        }
        return this.createOKResponse(requests);
    }

    String createSearchFilter(String requestState, String requestType) {
        Object filter = "";
        int matches = 0;
        if (requestState == null && requestType == null) {
            filter = "(requeststate=*)";
            return filter;
        }
        if (requestState != null) {
            filter = (String)filter + "(requeststate=" + LDAPUtil.escapeFilter((Object)requestState) + ")";
            ++matches;
        }
        if (requestType != null) {
            filter = (String)filter + "(requesttype=" + LDAPUtil.escapeFilter((Object)requestType) + ")";
            ++matches;
        }
        if (matches > 1) {
            filter = "(&" + (String)filter + ")";
        }
        return filter;
    }
}

