/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools;

import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.SecretDecoderRing.Decryptor;
import org.mozilla.jss.SecretDecoderRing.Encryptor;
import org.mozilla.jss.SecretDecoderRing.KeyManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.util.Password;

class PWsdrCache {
    public static final String PROP_PWC_NICKNAME = "sso_key";
    private String mPWcachedb = null;
    private byte[] mKeyID = null;
    private String mTokenName = null;
    private CryptoToken mToken = null;
    private boolean mIsTool = false;

    public PWsdrCache(String pwCache, String pwcTokenname, byte[] keyId, boolean isTool) throws Exception {
        this.mPWcachedb = pwCache;
        this.mIsTool = isTool;
        this.mTokenName = pwcTokenname;
        CryptoManager cm = null;
        if (keyId != null) {
            this.mKeyID = keyId;
        }
        cm = CryptoManager.getInstance();
        this.mToken = CryptoUtil.getKeyStorageToken((String)this.mTokenName);
        this.debug("PWsdrCache: token: " + this.mToken.getName());
    }

    public byte[] getKeyId() {
        return this.mKeyID;
    }

    public String getTokenName() {
        return this.mTokenName;
    }

    public void deleteUniqueNamedKey(String nickName) throws Exception {
        KeyManager km = new KeyManager(this.mToken);
        km.deleteUniqueNamedKey(nickName);
    }

    public byte[] generateSDRKey() throws Exception {
        return this.generateSDRKeyWithNickName(PROP_PWC_NICKNAME);
    }

    public byte[] generateSDRKeyWithNickName(String nickName) throws Exception {
        block5: {
            try {
                if (!this.mIsTool) break block5;
                KeyManager km = new KeyManager(this.mToken);
                try {
                    if (!km.uniqueNamedKeyExists(nickName)) {
                        this.mKeyID = km.generateUniqueNamedKey(nickName);
                        this.debug("PWsdrCache: SDR key generated");
                    }
                }
                catch (TokenException e) {
                    this.log(0, "generateSDRKey() failed on " + e.toString());
                    throw e;
                }
            }
            catch (Exception e) {
                this.log(0, e.toString());
                throw e;
            }
        }
        return this.mKeyID;
    }

    public void addEntry(String tag, String pwd) throws IOException {
        this.addEntry(tag, pwd, null);
    }

    public void addEntry(Hashtable<String, String> ht) throws IOException {
        this.addEntry(null, null, ht);
    }

    public void addEntry(String tag, String pwd, Hashtable<String, String> tagPwds) throws IOException {
        System.out.println("PWsdrCache: in addEntry");
        StringBuffer stringToAdd = new StringBuffer();
        String bufs = null;
        if (tagPwds == null) {
            stringToAdd.append(tag + ":" + pwd + "\n");
        } else {
            Enumeration<String> enum1 = tagPwds.keys();
            while (enum1.hasMoreElements()) {
                tag = enum1.nextElement();
                pwd = tagPwds.get(tag);
                this.debug("password tag: " + tag + " stored in " + this.mPWcachedb);
                stringToAdd.append(tag + ":" + pwd + "\n");
            }
        }
        String dcrypts = this.readPWcache();
        System.out.println("PWsdrCache: after readPWcache()");
        if (dcrypts != null) {
            Hashtable<String, String> ht = this.string2Hashtable(dcrypts);
            if (!ht.containsKey(tag)) {
                this.debug("adding new tag: " + tag);
                ht.put(tag, pwd);
            } else {
                this.debug("replacing tag: " + tag);
                ht.put(tag, pwd);
            }
            bufs = this.hashtable2String(ht);
        } else {
            this.debug("adding new tag: " + tag);
            bufs = stringToAdd.toString();
        }
        this.writePWcache(bufs);
    }

    public void deleteEntry(String tag) throws IOException {
        String bufs = null;
        String dcrypts = this.readPWcache();
        if (dcrypts == null) {
            this.debug("password cache contains no tags");
            return;
        }
        Hashtable<String, String> ht = this.string2Hashtable(dcrypts);
        if (!ht.containsKey(tag)) {
            this.debug("tag: " + tag + " does not exist");
            return;
        }
        this.debug("deleting tag: " + tag);
        ht.remove(tag);
        bufs = this.hashtable2String(ht);
        this.writePWcache(bufs);
    }

    public String readPWcache() throws IOException {
        this.debug("about to read password cache");
        String dcrypts = null;
        if (this.mToken == null) {
            this.debug("mToken is null");
            throw new IOException("token must be specified");
        }
        Decryptor sdr = new Decryptor(this.mToken);
        int totalRead = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (FileInputStream inputs = null;){
            inputs = new FileInputStream(this.mPWcachedb);
            byte[] readbuf = new byte[2048];
            int numRead = 0;
            while ((numRead = inputs.read(readbuf)) != -1) {
                bos.write(readbuf, 0, numRead);
                totalRead += numRead;
            }
        }
        if (totalRead > 0) {
            try {
                byte[] dcryptb = sdr.decrypt(bos.toByteArray());
                dcrypts = new String(dcryptb, "UTF-8");
                CryptoUtil.obscureBytes((byte[])dcryptb, (String)"random");
            }
            catch (TokenException e) {
                System.out.println("password cache decrypto failed " + e.toString());
                e.printStackTrace();
                throw new IOException("password cache decrypt failed");
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("password cache decrypto failed " + e.toString());
                e.printStackTrace();
                throw new IOException("password cache decrypt failed");
            }
            catch (Exception e) {
                System.out.println("password cache decrypto failed " + e.toString());
                e.printStackTrace();
                throw new IOException("password cache decrypt failed");
            }
        }
        return dcrypts;
    }

    public void writePWcache(String bufs) throws IOException {
        try (FileOutputStream outstream = null;){
            Encryptor sdr = new Encryptor(this.mToken, this.mKeyID, Encryptor.DEFAULT_ENCRYPTION_ALG);
            byte[] writebuf = null;
            try {
                writebuf = sdr.encrypt(bufs.getBytes("UTF-8"));
            }
            catch (Exception e) {
                System.out.println("password cache encrypt failed " + e.toString());
                e.printStackTrace();
                throw new IOException("password cache encrypt failed");
            }
            File tmpPWcache = new File(this.mPWcachedb + ".tmp");
            if (tmpPWcache.exists() && !tmpPWcache.delete()) {
                this.debug("Could not delete the existing " + this.mPWcachedb + ".tmp file.");
            }
            outstream = new FileOutputStream(this.mPWcachedb + ".tmp");
            outstream.write(writebuf);
            if (!PWsdrCache.isNT()) {
                PWsdrCache.exec("chmod 00660 " + tmpPWcache.getAbsolutePath());
            }
            File origFile = new File(this.mPWcachedb);
            try {
                if (origFile.exists() && !origFile.delete()) {
                    this.debug("Could not delete the existing " + this.mPWcachedb + "file.");
                }
                if (PWsdrCache.isNT()) {
                    PWsdrCache.exec("copy " + tmpPWcache.getAbsolutePath().replace('/', '\\') + " " + origFile.getAbsolutePath().replace('/', '\\'));
                } else {
                    PWsdrCache.exec("cp -p " + tmpPWcache.getAbsolutePath() + " " + origFile.getAbsolutePath());
                }
                if (origFile.exists()) {
                    if (!tmpPWcache.delete()) {
                        this.debug("Could not delete the existing " + this.mPWcachedb + ".tmp file.");
                    }
                    if (!PWsdrCache.isNT()) {
                        PWsdrCache.exec("chmod 00660 " + origFile.getAbsolutePath());
                    }
                    this.debug("Renaming operation completed for " + this.mPWcachedb);
                } else {
                    this.debug("Renaming operation failed for " + this.mPWcachedb);
                    System.exit(1);
                }
            }
            catch (IOException exx) {
                System.out.println("sdrPWcache: Error " + exx.toString());
                throw new IOException(exx.toString() + ": " + this.mPWcachedb);
            }
        }
    }

    public String hashtable2String(Hashtable<String, String> ht) {
        Enumeration<String> enum1 = ht.keys();
        StringBuffer returnString = new StringBuffer();
        while (enum1.hasMoreElements()) {
            String tag = enum1.nextElement();
            String pwd = ht.get(tag);
            returnString.append(tag + ":" + pwd + "\n");
        }
        return returnString.toString();
    }

    public Hashtable<String, String> string2Hashtable(String cache) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        StringTokenizer st = new StringTokenizer(cache, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int colonIdx = line.indexOf(":");
            if (colonIdx == -1) continue;
            String tag = line.substring(0, colonIdx);
            String passwd = line.substring(colonIdx + 1, line.length());
            ht.put(tag.trim(), passwd.trim());
        }
        return ht;
    }

    public Password getEntry(String fileName, String tag) {
        this.mPWcachedb = fileName;
        return this.getEntry(tag);
    }

    public Password getEntry(String tag) {
        Hashtable<String, String> pwTable = null;
        String pw = null;
        this.debug("in getEntry, tag=" + tag);
        if (this.mPWcachedb == null) {
            this.debug("mPWcachedb file path name is not initialized");
            return null;
        }
        String dcrypts = null;
        try {
            dcrypts = this.readPWcache();
        }
        catch (IOException e) {
            System.out.println("dfailed readPWcache() " + e.toString());
            return null;
        }
        if (dcrypts != null) {
            String cache = dcrypts;
            pwTable = this.string2Hashtable(cache);
            this.debug("in getEntry, pw cache parsed");
            pw = pwTable.get(tag);
        }
        if (pw == null) {
            System.out.println("getEntry did not get password for tag " + tag);
            return null;
        }
        this.debug("getEntry gotten password for " + tag);
        return new Password(pw.toCharArray());
    }

    public static boolean isNT() {
        return File.separator.equals("\\");
    }

    public static boolean exec(String cmd) throws IOException {
        try {
            String[] cmds = null;
            cmds = PWsdrCache.isNT() ? new String[]{"cmd", "/c", cmd} : new String[]{"/bin/sh", "-c", cmd};
            Process process = Runtime.getRuntime().exec(cmds);
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void debug(String msg) {
        System.out.println(msg);
    }

    public void log(int level, String msg) {
        System.out.println(msg);
    }

    public boolean pprint() {
        String dcrypts = null;
        try {
            dcrypts = this.readPWcache();
        }
        catch (IOException e) {
            System.out.println("failed readPWcache() " + e.toString());
            return false;
        }
        this.debug("----- Password Cache Content -----");
        if (dcrypts != null) {
            StringTokenizer st = new StringTokenizer(dcrypts, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                int colonIdx = line.indexOf(":");
                if (colonIdx != -1) {
                    String tag = line.substring(0, colonIdx);
                    String passwd = line.substring(colonIdx + 1, line.length());
                    this.debug(tag.trim() + " : " + passwd.trim());
                    continue;
                }
                this.debug("invalid format");
            }
        }
        return true;
    }
}

